/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.task;

import java.sql.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.logorm.LogORM;
import kd.bos.openapi.base.queue.OpenQueueItemStatus;
import kd.bos.openapi.common.constant.ApiConstant;
import kd.bos.openapi.common.spi.OpenApiDataServiceFactory;
import kd.bos.openapi.common.util.DateUtil;
import kd.bos.openapi.kcf.utils.IdempotencyUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;

public class OpenApiFullLogCleanTask
extends AbstractTask {
    private static final Log log = LogFactory.getLog(OpenApiFullLogCleanTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        this.cleanFullLog();
        this.cleanApiLog();
        this.clearOpenQueueLog();
        this.clearAsyncApiData();
        this.clearDBIdempotency();
    }

    private void clearDBIdempotency() {
        try {
            IdempotencyUtil.clearExpireDbIdempotencyKey(null);
        }
        catch (Throwable e) {
            log.info("OpenApi DB\u9632\u91cd\u590d\u8fc7\u671f\u8bb0\u5f55\u6e05\u7406\u5931\u8d25\uff1a", (Object)e);
        }
    }

    private void cleanFullLog() {
        String apiLogLevel = OpenApiDataServiceFactory.getOpenApiDataService().getSysParameter("api_log_level", "summary");
        String days = OpenApiDataServiceFactory.getOpenApiDataService().getSysParameter("fulllog_days", "5");
        try {
            LogORM logORM = LogORM.create();
            java.util.Date timeBeforeNDay = DateUtil.getDateWithoutHour((java.util.Date)DateUtil.getDateAdd((java.util.Date)new java.util.Date(), (int)6, (int)(-Integer.parseInt(days))));
            QFilter[] qFilters = new QFilter[]{new QFilter("opdate", "<", (Object)timeBeforeNDay)};
            int count = logORM.delete("openapi_log_detail", qFilters);
            log.info(String.format("OpenApi\u5927\u6587\u672c\u65e5\u5fd7\u6e05\u7406\u4efb\u52a1\u6267\u884c\u6210\u529f,\u6e05\u7406\u4e86 %s \u6761\u8bb0\u5f55\u3002", count));
        }
        catch (Exception e) {
            log.info("OpenApi\u5927\u6587\u672c\u65e5\u5fd7\u6e05\u7406\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5931\u8d25", (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanApiLog() {
        String sysDays = OpenApiDataServiceFactory.getOpenApiDataService().getSysParameter("api_log_days", "30");
        long starTime = System.currentTimeMillis();
        java.util.Date minDate = null;
        try {
            java.util.Date timeBeforeNDay = DateUtil.getDateWithoutHour((java.util.Date)DateUtil.getDateAdd((java.util.Date)new java.util.Date(), (int)6, (int)(-Integer.parseInt(sysDays))));
            String querySql = "select min(fopdate) from t_openapi_log_data ";
            minDate = (java.util.Date)DB.query((DBRoute)DBRoute.log, (String)querySql, rs -> {
                java.util.Date resultDate = timeBeforeNDay;
                while (rs.next()) {
                    Date date = rs.getDate(1);
                    java.util.Date earliestNDay = DateUtil.getDateWithoutHour((java.util.Date)DateUtil.getDateAdd((java.util.Date)date, (int)6, (int)15));
                    resultDate = DateUtil.getMinDate((java.util.Date)timeBeforeNDay, (java.util.Date)earliestNDay);
                }
                return resultDate;
            });
            String delSql = "DELETE from t_openapi_log_data where fopdate < ?";
            Object[] params = new SqlParameter[]{new SqlParameter(":FTime", 91, (Object)minDate)};
            DB.execute((DBRoute)DBRoute.log, (String)delSql, (Object[])params);
        }
        catch (Exception e) {
            try {
                log.info("OpenApi \u8c03\u7528\u65e5\u5fd7\u6e05\u7406\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5931\u8d25", (Object)e);
            }
            catch (Throwable throwable) {
                log.info(String.format(ResManager.loadKDString((String)"OpenApi \u8c03\u7528\u65e5\u5fd7\u4fdd\u5b58\u5929\u6570== %1$s, OpenApi\u8c03\u7528\u65e5\u5fd7\u6e05\u7406\u5b9a\u65f6\u4efb\u52a1\u9700\u8981\u5220\u9664\u65e5\u5fd7\u7684\u65f6\u95f4\u70b9\u662f== %2$s,OpenApi\u8c03\u7528\u65e5\u5fd7\u6e05\u7406\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u8017\u8d39\u65f6\u95f4== %3$s", (String)"OpenApiFullLogCleanTask_0", (String)"bos-open-base", (Object[])new Object[0]), sysDays, minDate, System.currentTimeMillis() - starTime));
                throw throwable;
            }
            log.info(String.format(ResManager.loadKDString((String)"OpenApi \u8c03\u7528\u65e5\u5fd7\u4fdd\u5b58\u5929\u6570== %1$s, OpenApi\u8c03\u7528\u65e5\u5fd7\u6e05\u7406\u5b9a\u65f6\u4efb\u52a1\u9700\u8981\u5220\u9664\u65e5\u5fd7\u7684\u65f6\u95f4\u70b9\u662f== %2$s,OpenApi\u8c03\u7528\u65e5\u5fd7\u6e05\u7406\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u8017\u8d39\u65f6\u95f4== %3$s", (String)"OpenApiFullLogCleanTask_0", (String)"bos-open-base", (Object[])new Object[0]), sysDays, minDate, System.currentTimeMillis() - starTime));
        }
        log.info(String.format(ResManager.loadKDString((String)"OpenApi \u8c03\u7528\u65e5\u5fd7\u4fdd\u5b58\u5929\u6570== %1$s, OpenApi\u8c03\u7528\u65e5\u5fd7\u6e05\u7406\u5b9a\u65f6\u4efb\u52a1\u9700\u8981\u5220\u9664\u65e5\u5fd7\u7684\u65f6\u95f4\u70b9\u662f== %2$s,OpenApi\u8c03\u7528\u65e5\u5fd7\u6e05\u7406\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u8017\u8d39\u65f6\u95f4== %3$s", (String)"OpenApiFullLogCleanTask_0", (String)"bos-open-base", (Object[])new Object[0]), sysDays, minDate, System.currentTimeMillis() - starTime));
    }

    public void clearOpenQueueLog() {
        try {
            String strLog = ResManager.loadKDString((String)"OpenApi_Queue_ClearLog-\u6d88\u606f\u961f\u5217\u4fdd\u7559\u65f6\u957f - \u72b6\u6001\u6210\u529f\uff08F)\uff1a%1s \u5929, \u5168\u90e8\u6d88\u606f\uff08ALL)\uff1a %2s \u5929", (String)"OpenQueueClearLog_1", (String)"bos-open-base", (Object[])new Object[]{3L, 7L});
            log.info(strLog);
            java.util.Date checkDate = new java.util.Date(System.currentTimeMillis() - 259200000L);
            String sql = "DELETE FROM t_openapi_queue WHERE fscheduletime<=? and fstatus=?";
            DB.execute((DBRoute)ApiConstant.QUEUE_DB_ROUTE, (String)sql, (Object[])new Object[]{checkDate, OpenQueueItemStatus.F1});
            java.util.Date checkDate2 = new java.util.Date(System.currentTimeMillis() - 604800000L);
            String sql2 = "DELETE FROM t_openapi_queue WHERE fscheduletime<=? ";
            DB.execute((DBRoute)ApiConstant.QUEUE_DB_ROUTE, (String)sql2, (Object[])new Object[]{checkDate2});
            String str = ResManager.loadKDString((String)"OpenApi_Queue_ClearLog-QueueLog\u961f\u5217\u6e05\u7406\u4efb\u52a1\u6267\u884c\u6210\u529f\u3002", (String)"OpenQueueClearLog_2", (String)"bos-open-base", (Object[])new Object[0]);
            log.info(str);
        }
        catch (Exception e) {
            String str = ResManager.loadKDString((String)"OpenApi_Queue_ClearLog-Kem_QueueLog\u961f\u5217\u6e05\u7406\u5b9a\u65f6\u4efb\u52a1\u6267\u884c\u5931\u8d25:%s\u3002", (String)"OpenQueueClearLog_3", (String)"bos-open-base", (Object[])new Object[]{e.getMessage()});
            log.error(str, (Throwable)e);
            throw e;
        }
    }

    public void clearAsyncApiData() {
        try {
            String strLog = ResManager.loadKDString((String)"OpenApi_Queue_ClearLog-OpenApi_AsyncData_ClearLog-\u4fdd\u7559\u65f6\u957f\uff1a%s\u5929", (String)"OpenQueueClearLog_4", (String)"bos-open-base", (Object[])new Object[]{3L});
            log.info(strLog);
            java.util.Date checkDate = new java.util.Date(System.currentTimeMillis() - 259200000L);
            String sql = "DELETE FROM t_openapi_asyncdata WHERE fcreatetime<=? ";
            DB.execute((DBRoute)ApiConstant.QUEUE_DB_ROUTE, (String)sql, (Object[])new Object[]{checkDate});
            String str = ResManager.loadKDString((String)"OpenApi_AsyncData_ClearLog-\u5f02\u6b65API\u4e2d\u95f4\u8868\u6570\u636e\u6e05\u7406\u4efb\u52a1\u6267\u884c\u6210\u529f\u3002", (String)"OpenQueueClearLog_5", (String)"bos-open-base", (Object[])new Object[0]);
            log.info(str);
        }
        catch (Exception e) {
            String str = ResManager.loadKDString((String)"OpenApi_AsyncData_ClearLog-\u5f02\u6b65API\u4e2d\u95f4\u8868\u6570\u636e\u6e05\u7406\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff0c\u539f\u56e0:%s\u3002", (String)"OpenQueueClearLog_6", (String)"bos-open-base", (Object[])new Object[]{e.getMessage()});
            log.error(str, (Throwable)e);
            throw e;
        }
    }
}

