/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.openapi.base.model.ApiModel;
import kd.bos.openapi.base.util.LocalCacheUtil;
import kd.bos.openapi.common.model.ApiUriModel;
import kd.bos.openapi.common.util.CacheUtil;

public class ApiUriModelCacheUtil {
    private static final String API_URI_MODEL = "ApiUriModel_Key";
    private static final int TIME_OUT_IN_SECONDS = 604800;
    private static final ReentrantLock R_LOCK = new ReentrantLock();

    private static LocalMemoryCache getLocalMemoryCache() {
        return ApiUriModelCacheUtil.getLocalMemoryCache(ApiUriModel.class.getName());
    }

    private static LocalMemoryCache getLocalMemoryCache(String cacheType) {
        return CacheUtil.getLocalMemoryCache((String)cacheType, (int)604800, (String)RequestContext.get().getAccountId());
    }

    public static void removeAndSetApiUriModelCache(String id, String uriPattern) {
        Map<String, ApiUriModel> map = ApiUriModelCacheUtil.getAllApiUriModelCache();
        map.put(id, new ApiUriModel(uriPattern));
        ApiUriModelCacheUtil.getLocalMemoryCache().put(API_URI_MODEL, map);
    }

    public static void removeApiUriModelCache(String id) {
        ApiUriModelCacheUtil.getLocalMemoryCache().removeMapFields(API_URI_MODEL, new String[]{id});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, ApiUriModel> getAllApiUriModelCache() {
        ConcurrentHashMap<String, ApiUriModel> map;
        block17: {
            map = (ConcurrentHashMap<String, ApiUriModel>)ApiUriModelCacheUtil.getLocalMemoryCache().get(API_URI_MODEL);
            if (map != null) {
                return map;
            }
            R_LOCK.lock();
            try {
                map = (Map)ApiUriModelCacheUtil.getLocalMemoryCache().get(API_URI_MODEL);
                if (map != null) break block17;
                map = new ConcurrentHashMap<String, ApiUriModel>(16);
                try (DataSet dataSet = DB.queryDataSet((String)(LocalCacheUtil.class.getName() + ".getAllApiUriModelCache"), (DBRoute)DBRoute.base, (String)"select fid, furlformat from t_open_apiservice", (Object[])new Object[0]);){
                    while (dataSet.hasNext()) {
                        Row row = dataSet.next();
                        map.put(row.getString("fid"), new ApiUriModel(row.getString("furlformat")));
                    }
                    ApiUriModelCacheUtil.getLocalMemoryCache().put(API_URI_MODEL, map);
                }
            }
            finally {
                R_LOCK.unlock();
            }
        }
        return map;
    }

    public static void removeApiModelCache(String url) {
        LocalCacheUtil.removeCacheByKey(ApiModel.class, url);
        LocalCacheUtil.removeCacheByKey("kd.bos.openapi.base.model.ApiFilterModel", url);
    }
}

