/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.util;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.CompareType;
import kd.bos.entity.filter.CompareTypeEnum;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.filter.FilterMetadata;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;

public class CompareTypeUtil {
    public static final Map<CompareTypeEnum, String> ALL_COMPARE_TYPE = new LinkedHashMap<CompareTypeEnum, String>(16);
    public static final Map<CompareTypeEnum, Set<CompareType>> SAME_TYPE = new HashMap<CompareTypeEnum, Set<CompareType>>(16);
    private static final String BOS_OPEN_BASE = "bos-open-base";

    public static void initCompareTypeMap() {
        ALL_COMPARE_TYPE.put(CompareTypeEnum.EQUAL, ResManager.loadKDString((String)"\u7b49\u4e8e", (String)"CompareTypeUtil_0", (String)BOS_OPEN_BASE, (Object[])new Object[0]));
        ALL_COMPARE_TYPE.put(CompareTypeEnum.NOTEQUAL, ResManager.loadKDString((String)"\u4e0d\u7b49\u4e8e", (String)"CompareTypeUtil_1", (String)BOS_OPEN_BASE, (Object[])new Object[0]));
        ALL_COMPARE_TYPE.put(CompareTypeEnum.IN, ResManager.loadKDString((String)"\u5728\u2026\u2026\u4e2d", (String)"CompareTypeUtil_2", (String)BOS_OPEN_BASE, (Object[])new Object[0]));
        ALL_COMPARE_TYPE.put(CompareTypeEnum.NOTIN, ResManager.loadKDString((String)"\u4e0d\u5728\u2026\u2026\u4e2d", (String)"CompareTypeUtil_3", (String)BOS_OPEN_BASE, (Object[])new Object[0]));
        ALL_COMPARE_TYPE.put(CompareTypeEnum.ISNULL, ResManager.loadKDString((String)"\u4e3a\u7a7a", (String)"CompareTypeUtil_4", (String)BOS_OPEN_BASE, (Object[])new Object[0]));
        ALL_COMPARE_TYPE.put(CompareTypeEnum.ISNOTNULL, ResManager.loadKDString((String)"\u4e0d\u4e3a\u7a7a", (String)"CompareTypeUtil_5", (String)BOS_OPEN_BASE, (Object[])new Object[0]));
        ALL_COMPARE_TYPE.put(CompareTypeEnum.LIKE, ResManager.loadKDString((String)"\u5305\u542b", (String)"CompareTypeUtil_6", (String)BOS_OPEN_BASE, (Object[])new Object[0]));
        ALL_COMPARE_TYPE.put(CompareTypeEnum.NOTLIKE, ResManager.loadKDString((String)"\u4e0d\u5305\u542b", (String)"CompareTypeUtil_7", (String)BOS_OPEN_BASE, (Object[])new Object[0]));
        ALL_COMPARE_TYPE.put(CompareTypeEnum.LEFTLIKE, ResManager.loadKDString((String)"\u4ee5\u2026\u2026\u5f00\u59cb", (String)"CompareTypeUtil_8", (String)BOS_OPEN_BASE, (Object[])new Object[0]));
        ALL_COMPARE_TYPE.put(CompareTypeEnum.RIGHTLIKE, ResManager.loadKDString((String)"\u4ee5\u2026\u2026\u7ed3\u675f", (String)"CompareTypeUtil_9", (String)BOS_OPEN_BASE, (Object[])new Object[0]));
        ALL_COMPARE_TYPE.put(CompareTypeEnum.GREATER, ResManager.loadKDString((String)"\u5927\u4e8e", (String)"CompareTypeUtil_10", (String)BOS_OPEN_BASE, (Object[])new Object[0]));
        ALL_COMPARE_TYPE.put(CompareTypeEnum.LESS, ResManager.loadKDString((String)"\u5c0f\u4e8e", (String)"CompareTypeUtil_11", (String)BOS_OPEN_BASE, (Object[])new Object[0]));
        ALL_COMPARE_TYPE.put(CompareTypeEnum.GREATEROREQUAL, ResManager.loadKDString((String)"\u5927\u4e8e\u7b49\u4e8e", (String)"CompareTypeUtil_12", (String)BOS_OPEN_BASE, (Object[])new Object[0]));
        ALL_COMPARE_TYPE.put(CompareTypeEnum.LESSOREQUAL, ResManager.loadKDString((String)"\u5c0f\u4e8e\u7b49\u4e8e", (String)"CompareTypeUtil_13", (String)BOS_OPEN_BASE, (Object[])new Object[0]));
        FilterMetadata filterMetadata = FilterMetadata.get();
        List compareTypes = filterMetadata.getCompareCategories().stream().flatMap(it -> it.getCompareTypes().stream()).collect(Collectors.toList());
        for (Map.Entry<CompareTypeEnum, String> entry : ALL_COMPARE_TYPE.entrySet()) {
            SAME_TYPE.put(entry.getKey(), compareTypes.stream().filter(it -> !it.getId().equals(((CompareTypeEnum)entry.getKey()).getId())).filter(it -> it.getName().getLocaleValue().equals(entry.getValue())).collect(Collectors.toSet()));
        }
    }

    public static String getDesc(String compareType) {
        return CompareTypeUtil.getDesc(CompareTypeEnum.valueOf((String)compareType));
    }

    public static String getDesc(CompareTypeEnum key) {
        CompareTypeUtil.initCompareTypeMap();
        if (ALL_COMPARE_TYPE.get(key) != null) {
            return ALL_COMPARE_TYPE.get(key);
        }
        return key.name();
    }

    public static boolean isMustInput(String typeName) {
        CompareTypeEnum typeEnum = CompareTypeEnum.valueOf((String)typeName);
        return CompareTypeUtil.isMustInput(typeEnum);
    }

    public static boolean isMustInput(CompareTypeEnum typeEnum) {
        switch (typeEnum) {
            case EQUAL: 
            case NOTEQUAL: 
            case IN: 
            case NOTIN: 
            case LIKE: 
            case NOTLIKE: 
            case LEFTLIKE: 
            case RIGHTLIKE: 
            case GREATER: 
            case LESS: 
            case GREATEROREQUAL: 
            case LESSOREQUAL: {
                return true;
            }
        }
        return false;
    }

    public static boolean checkCompare(String type, String compare, String filterColumn, String entityNumber) {
        CompareTypeEnum compareTypeEnum = CompareTypeEnum.valueOf((String)compare);
        try {
            CompareTypeUtil.getCompareType(compareTypeEnum, FilterField.create((MainEntityType)EntityMetadataCache.getDataEntityType((String)entityNumber), (String)filterColumn));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getCompareType(CompareTypeEnum origin, FilterField filterField) {
        CompareTypeUtil.initCompareTypeMap();
        Set compareIds = filterField.getCompareTypes().stream().map(CompareType::getId).collect(Collectors.toSet());
        if (compareIds.contains(origin.getId())) {
            return origin.getId();
        }
        Set<CompareType> sameTypes = SAME_TYPE.get(origin);
        for (CompareType sameType : sameTypes) {
            if (!compareIds.contains(sameType.getId())) continue;
            return sameType.getId();
        }
        throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u6761\u4ef6\u5b57\u6bb5 \u3010{0}\u3011 \u4e0d\u652f\u6301 \u3010{1}\u3011 \u6bd4\u8f83\u65b9\u5f0f\u3002", (String)"CompareTypeUtil_14", (String)BOS_OPEN_BASE, (Object[])new Object[0]), new Object[]{filterField.getFieldName(), CompareTypeUtil.getDesc(origin)});
    }
}

