/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.util;

import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.openapi.base.util.ApiUriModelCacheUtil;
import kd.bos.openapi.common.util.CacheUtil;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public class LocalCacheUtil {
    private static LocalMemoryCache getLocalMemoryCache(String cacheType) {
        return CacheUtil.getLocalMemoryCache((String)cacheType, (String)RequestContext.get().getAccountId());
    }

    private static LocalMemoryCache getLocalMemoryCache(String cacheType, int timeOutInSeconds) {
        return CacheUtil.getLocalMemoryCache((String)cacheType, (int)timeOutInSeconds, (String)RequestContext.get().getAccountId());
    }

    public static Object getCacheByKey(String cacheType, String key) {
        String newKey = CacheUtil.getNewCacheKey((String)cacheType, (String)key);
        return LocalCacheUtil.getLocalMemoryCache(cacheType).get(newKey);
    }

    public static void setCacheByKey(String cacheType, String key, Object value) {
        String newKey = CacheUtil.getNewCacheKey((String)cacheType, (String)key);
        LocalCacheUtil.getLocalMemoryCache(cacheType).put(newKey, value);
    }

    public static void setCacheByKey(String cacheType, String key, Object value, int timeOutInSeconds) {
        String newKey = CacheUtil.getNewCacheKey((String)cacheType, (String)key);
        LocalCacheUtil.getLocalMemoryCache(cacheType, timeOutInSeconds).put(newKey, value);
    }

    public static void removeCacheByKey(String cacheType, String key) {
        String newKey = CacheUtil.getNewCacheKey((String)cacheType, (String)key);
        LocalCacheUtil.getLocalMemoryCache(cacheType).remove(new String[]{newKey});
    }

    public static void clear(String cacheType) {
        LocalCacheUtil.getLocalMemoryCache(cacheType).clear();
    }

    public static <T> boolean checkIsInCache(Class<T> dataType, String key) {
        String newKey = CacheUtil.getNewCacheKey((String)dataType.getName(), (String)key);
        Object object = LocalCacheUtil.getLocalMemoryCache(dataType.getName()).get(newKey);
        return object != null;
    }

    public static <T> T getCacheByKey(Class<T> dataType, String key) {
        String newKey = CacheUtil.getNewCacheKey((String)dataType.getName(), (String)key);
        return (T)LocalCacheUtil.getLocalMemoryCache(dataType.getName()).get(newKey);
    }

    public static <T> void removeCacheByKey(Class<T> dataType, String key) {
        LocalCacheUtil.removeCacheByKey(dataType.getName(), key);
    }

    public static <T> void setCacheByKey(String key, T object) {
        LocalCacheUtil.setCacheByKey(object.getClass().getName(), key, object);
    }

    public static <T> void clear(Class<T> dataType) {
        LocalCacheUtil.clear(dataType.getName());
    }

    @Deprecated
    public static void removeApiModelCache(String url) {
        ApiUriModelCacheUtil.removeApiModelCache(url);
    }
}

