/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.api.client.HttpMethod;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.api.result.ApiQueryResult;
import kd.bos.openapi.api.result.ApiServiceResult;
import kd.bos.openapi.api.util.ApiService;
import kd.bos.openapi.common.constant.ApiConstant;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.ApiOperationType;
import kd.bos.openapi.common.constant.DataType;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.result.OpenApiResult;
import kd.bos.openapi.common.util.OpenJsonUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.xdb.util.Pair;

public class OpenApiDataPreviewUtil
implements ApiConstant {
    private static final Log LOG = LogFactory.getLog(OpenApiDataPreviewUtil.class);
    private static final int SIZE = 10;

    private OpenApiDataPreviewUtil() {
    }

    public static Pair<Map<String, Object>, Boolean> getDataPair(String title, String entryKey, DynamicObjectCollection entryCollection, String operation, int httpMethod) {
        Pair result = new Pair();
        result.setValue((Object)Boolean.FALSE);
        Map<String, Object> structMap = OpenApiDataPreviewUtil.checkBeforeSaveOrPreview(title, entryKey, entryCollection);
        if ("respentryentity".equals(entryKey)) {
            ApiServiceResult data = ApiService.getTypeByOp((String)operation.toUpperCase()).getResultType();
            if (null != data && data instanceof ApiQueryResult) {
                ArrayList<Map<String, Object>> rows;
                List resultData = (List)structMap.get("data");
                if (resultData != null) {
                    rows = ((Map)resultData.get(0)).get("rows");
                    ((ApiQueryResult)data).setRows((List)rows);
                } else {
                    rows = new ArrayList<Map<String, Object>>();
                    rows.add(structMap);
                    ((ApiQueryResult)data).setRows(rows);
                }
                ((ApiQueryResult)data).setPageNo(1);
                ((ApiQueryResult)data).setPageSize(10);
            }
            OpenApiResult openApiResult = OpenApiResult.builder().success((Object)data);
            openApiResult.setMessage("");
            String jsonString = OpenJsonUtil.toJson((Object)openApiResult);
            result.setKey(JSON.parseObject((String)jsonString, LinkedHashMap.class, (Feature[])new Feature[]{Feature.OrderedField}));
            return result;
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(16);
        map.put("data", structMap);
        if ("query".equalsIgnoreCase(operation)) {
            map.put("pageSize", 10);
            map.put("pageNo", 1);
            if (HttpMethod.GET.ordinal() == httpMethod) {
                result.setValue((Object)Boolean.TRUE);
                if (structMap.containsKey("pageSize") || structMap.containsKey("pageNo")) {
                    throw new OpenApiException(ApiErrorCode.HTTP_BAD_REQUEST, ResManager.loadKDString((String)"GET \u8bf7\u6c42Query\u53c2\u6570\u4e0d\u80fd\u5305\u542b\u53c2\u6570\u540d %1$s, %2$s \u3002", (String)"OpenApiDataPreviewUtil_0", (String)"bos-open-base", (Object[])new Object[0]), new Object[]{"pageSize", "pageNo"});
                }
            }
        }
        if (ApiOperationType.getTypeByOp((String)operation.toUpperCase()).isReqBatch()) {
            map.put("data", Collections.singletonList(structMap));
        }
        result.setKey(map);
        return result;
    }

    private static void checkRepeatParam(String title, Supplier<Stream<DynamicObject>> supplier, String paramName, String levelName, String objPropName) {
        if (supplier.get() == null) {
            return;
        }
        Map<String, Map<String, Long>> pidMap = supplier.get().sorted((a, b) -> {
            int aa = a.getInt(levelName);
            int bb = b.getInt(levelName);
            return Integer.compare(bb, aa);
        }).collect(Collectors.groupingBy(it -> it.getString("pid"), Collectors.groupingBy(it -> it.getString(paramName), Collectors.counting())));
        Map idMap = supplier.get().collect(Collectors.toMap(it -> it.getString("id"), Function.identity()));
        for (Map.Entry<String, Map<String, Long>> entry : pidMap.entrySet()) {
            for (Map.Entry<String, Long> en : entry.getValue().entrySet()) {
                if (en.getValue() <= 1L) continue;
                String tip = null;
                if ("0".equals(entry.getKey())) {
                    tip = String.format(ResManager.loadKDString((String)"\u5c42\u7ea7 1 \u4e2d\u5b58\u5728\u91cd\u590d\u7684\u53c2\u6570\u540d\u79f0\u3010%s", (String)"OpenApiDataPreviewUtil_1", (String)"bos-open-base", (Object[])new Object[0]), en.getKey());
                } else {
                    DynamicObject pObj = (DynamicObject)idMap.get(entry.getKey());
                    tip = String.format(ResManager.loadKDString((String)"\u5c42\u7ea7 %1$s \u7684\u5206\u5f55\u53c2\u6570 %2$s \u4e0b\u5b58\u5728\u91cd\u590d\u7684\u53c2\u6570\u540d\u79f0\u3010 %3$s", (String)"OpenApiDataPreviewUtil_2", (String)"bos-open-base", (Object[])new Object[0]), pObj.getString(levelName), pObj.getString(paramName), en.getKey());
                }
                throw new OpenApiException(ApiErrorCode.Data_Invalid, String.format(ResManager.loadKDString((String)"%1$s\uff1a%2$s\u3011\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OpenApiDataPreviewUtil_3", (String)"bos-open-base", (Object[])new Object[0]), title, tip), new Object[0]);
            }
        }
        Map objPropMap = supplier.get().map(it -> it.getString(objPropName)).collect(Collectors.groupingBy(Function.identity(), Collectors.counting()));
        for (Map.Entry entry : objPropMap.entrySet()) {
            if (entry.getValue() <= 1L) continue;
            throw new OpenApiException(ApiErrorCode.Data_Invalid, String.format(ResManager.loadKDString((String)"%1$s\uff1a\u5bf9\u8c61\u5c5e\u6027\u540d\u79f0 \u3010%2$s\u3011\u5b58\u5728\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"OpenApiDataPreviewUtil_4", (String)"bos-open-base", (Object[])new Object[0]), title, entry.getKey()), new Object[0]);
        }
    }

    public static Map<String, Object> checkBeforeSaveOrPreview(String title, String entryKey, DynamicObjectCollection entryCollection) {
        if (CollectionUtils.isEmpty((Collection)entryCollection)) {
            return Collections.emptyMap();
        }
        String paramName = "bodyentryentity".equals(entryKey) ? "paramname" : "respparamname";
        Supplier<Stream<DynamicObject>> supplier = () -> entryCollection.stream().filter(it -> StringUtils.isNotEmpty((CharSequence)it.getString(paramName)));
        if (supplier.get() == null) {
            return Collections.emptyMap();
        }
        String paramTypeName = "bodyentryentity".equals(entryKey) ? "paramtype" : "respparamtype";
        String objPropName = "bodyentryentity".equals(entryKey) ? "objpropname" : "respobjpropname";
        String levelName = "bodyentryentity".equals(entryKey) ? "body_level" : "resp_level";
        String exampleName = "bodyentryentity".equals(entryKey) ? "example" : "respexample";
        OpenApiDataPreviewUtil.checkRepeatParam(title, supplier, paramName, levelName, objPropName);
        Map pidMap = supplier.get().collect(Collectors.groupingBy(it -> it.getString("pid"), LinkedHashMap::new, Collectors.toList()));
        return OpenApiDataPreviewUtil.getStructMap(title, pidMap, "0", paramName, paramTypeName, objPropName, null, exampleName);
    }

    private static Map<String, Object> getStructMap(String title, Map<String, List<DynamicObject>> pidMap, String parentPid, String paramName, String dataTypeName, String objPropName, String pObjPropVal, String exampleName) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (CollectionUtils.isEmpty(pidMap) || CollectionUtils.isEmpty((Collection)pidMap.get(parentPid))) {
            return map;
        }
        for (DynamicObject obj : pidMap.get(parentPid)) {
            String objPropVal = obj.getString(objPropName);
            String dataType = obj.getString(dataTypeName);
            if ("Entries".equals(dataType) || "Array".equals(dataType)) {
                Map<String, Object> entryProp = OpenApiDataPreviewUtil.getStructMap(title, pidMap, obj.getString("id"), paramName, dataTypeName, objPropName, objPropVal, exampleName);
                if (CollectionUtils.isEmpty(entryProp)) {
                    throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"%1$s : \u5bf9\u8c61\u5c5e\u6027\u540d\u79f0 %2$s \u53c2\u6570\u7c7b\u578b\u4e3a\u5206\u5f55\uff0c\u8bf7\u6dfb\u52a0\u5206\u5f55\u5c5e\u6027\u3002", (String)"OpenApiDataPreviewUtil_5", (String)"bos-open-base", (Object[])new Object[0]), new Object[]{title, objPropVal});
                }
                map.put(obj.getString(paramName), Collections.singletonList(entryProp));
                continue;
            }
            if (pidMap.containsKey(obj.getString("id"))) {
                throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"%1$s: \u5bf9\u8c61\u5c5e\u6027\u540d\u79f0 %2$s \u6709\u5b50\u5c5e\u6027\uff0c\u5176\u53c2\u6570\u7c7b\u578b\u987b\u4e3a %3$s\u3002", (String)"OpenApiDataPreviewUtil_6", (String)"bos-open-base", (Object[])new Object[0]), new Object[]{title, objPropVal, "Entries"});
            }
            if (pObjPropVal != null && !objPropVal.startsWith(pObjPropVal + ".")) {
                throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"%1$s: \u5bf9\u8c61\u5c5e\u6027\u540d\u79f0 %2$s \u7684\u7236\u7ea7\u4e0d\u662f %3$s\u3002", (String)"OpenApiDataPreviewUtil_7", (String)"bos-open-base", (Object[])new Object[0]), new Object[]{title, objPropVal, pObjPropVal});
            }
            try {
                String example;
                String string = example = StringUtil.isEmpty((String)obj.getLocaleString(exampleName).getLocaleValue()) ? (String)obj.getLocaleString(exampleName).getDefaultItem() : obj.getLocaleString(exampleName).getLocaleValue();
                if (DataType.FLEX.type().equals(dataType) && (StringUtil.isEmpty((String)example) || "-".equals(example) || "{}".equals(example))) {
                    map.put(obj.getString(paramName), JSON.parse((String)DataType.FLEX.defaultStringValue()));
                    continue;
                }
                map.put(obj.getString(paramName), JSON.parse((String)example));
            }
            catch (Exception e) {
                LOG.info("paramUtilInfo:%1$s, paramName:%2$s, obj.getString(exampleName):%3$s", new Object[]{e.getMessage(), paramName, obj.get(exampleName)});
                map.put(obj.getString(paramName), null);
            }
        }
        return map;
    }
}

