/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.util;

import com.alibaba.fastjson.JSONArray;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.api.result.ApiServiceResult;
import kd.bos.openapi.api.util.ApiService;
import kd.bos.openapi.base.custom.CustomApiUtil;
import kd.bos.openapi.base.dataservice.OpenApiDataUtil;
import kd.bos.openapi.base.model.ApiModel;
import kd.bos.openapi.base.util.OpenApiDataPreviewUtil;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.ApiServiceType;
import kd.bos.openapi.common.constant.HttpMethod;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.result.OpenApiResult;
import kd.bos.openapi.common.util.DataUtil;
import kd.bos.openapi.common.util.OpenJsonUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.xdb.util.Pair;

public class OpenApiParamsExampleUtil {
    private static Log log = LogFactory.getLog(OpenApiParamsExampleUtil.class);

    public static String getRequestExample(DynamicObject apiInfo) {
        try {
            Map requestParams;
            if (apiInfo == null) {
                return "";
            }
            String apiServiceType = apiInfo.getString("apiservicetype");
            if (String.valueOf(ApiServiceType.OPERATION.ordinal()).equals(apiServiceType)) {
                requestParams = (Map)OpenApiDataPreviewUtil.getDataPair("request params", "bodyentryentity", apiInfo.getDynamicObjectCollection("bodyentryentity"), apiInfo.getString("operation"), DataUtil.i((Object)apiInfo.getString("httpmethod"))).getKey();
            } else if (apiServiceType.equals(String.valueOf(ApiServiceType.CUSTOM.ordinal()))) {
                String classname = apiInfo.getString("classname");
                String methodname = apiInfo.getString("methodname");
                DynamicObject appid = (DynamicObject)apiInfo.get("appid");
                String appNumber = appid.getString("number");
                Object resultObj = CustomApiUtil.getRequestObj(appNumber, classname, methodname);
                requestParams = (Map)resultObj;
            } else {
                DynamicObjectCollection bodyentryentity = apiInfo.getDynamicObjectCollection("bodyentryentity");
                Object bodyEx = CustomApiUtil.getCustomParams("bodyentryentity", bodyentryentity);
                requestParams = (Map)bodyEx;
            }
            if (HttpMethod.POST.getCode().equals(apiInfo.getString("httpmethod"))) {
                return OpenJsonUtil.toJson((Object)requestParams);
            }
            return OpenApiParamsExampleUtil.connectParams(requestParams);
        }
        catch (Exception e) {
            log.info("OpenApiParamsExampleUtil:" + e.getMessage());
            return "";
        }
    }

    public static String getRequestExampleByUrl(String url) {
        OpenApiParamsExampleUtil.checkUrlExist(url);
        ApiModel model = OpenApiDataUtil.getApiModelFromCache(url);
        DynamicObject apiInfo = model.getApi();
        return OpenApiParamsExampleUtil.getRequestExample(apiInfo);
    }

    public static String getResponseExample(DynamicObject apiInfo) {
        try {
            if (apiInfo == null) {
                return "";
            }
            String apiServiceType = apiInfo.getString("apiservicetype");
            if (String.valueOf(ApiServiceType.OPERATION.ordinal()).equals(apiServiceType)) {
                String operation = apiInfo.getString("operation");
                if (StringUtil.isEmpty((String)operation)) {
                    return OpenJsonUtil.toJson((Object)new OpenApiResult());
                }
                if ("query".equals(operation)) {
                    Pair<Map<String, Object>, Boolean> result = OpenApiDataPreviewUtil.getDataPair("response params", "respentryentity", apiInfo.getDynamicObjectCollection("respentryentity"), operation, DataUtil.i((Object)apiInfo.getString("httpmethod")));
                    return OpenJsonUtil.toJson((Object)result.getKey());
                }
                ApiServiceResult data = ApiService.getTypeByOp((String)operation.toUpperCase()).getResultType();
                OpenApiResult openApiResult = OpenApiResult.builder().success((Object)data);
                return OpenJsonUtil.toJson((Object)openApiResult);
            }
            if (apiServiceType.equals(String.valueOf(ApiServiceType.CUSTOM.ordinal()))) {
                String classname = apiInfo.getString("classname");
                String methodname = apiInfo.getString("methodname");
                DynamicObject appid = (DynamicObject)apiInfo.get("appid");
                String appNumber = appid.getString("number");
                Object responseObj = CustomApiUtil.getResponseObj(appNumber, classname, methodname);
                OpenApiResult openApiResult = OpenApiResult.builder().success(responseObj);
                return OpenJsonUtil.toJson((Object)openApiResult);
            }
            DynamicObjectCollection respentryentity = apiInfo.getDynamicObjectCollection("respentryentity");
            Object resultObj = CustomApiUtil.getCustomParams("respentryentity", respentryentity);
            return OpenJsonUtil.toJson((Object)resultObj);
        }
        catch (Exception e) {
            log.info("OpenApiParamsExampleUtil:" + e.getMessage());
            return "";
        }
    }

    public static String getResponseExampleByUrl(String url) {
        OpenApiParamsExampleUtil.checkUrlExist(url);
        ApiModel model = OpenApiDataUtil.getApiModelFromCache(url);
        DynamicObject apiInfo = model.getApi();
        return OpenApiParamsExampleUtil.getResponseExample(apiInfo);
    }

    private static String connectParams(Map<String, Object> params) {
        params = OpenApiParamsExampleUtil.getMethodData(params);
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> entry : params.entrySet()) {
            Object value;
            if (sb.length() > 0) {
                sb.append('&');
            }
            if ((value = entry.getValue()) instanceof JSONArray) {
                JSONArray valArray = (JSONArray)value;
                for (int i = 0; i < valArray.size(); ++i) {
                    sb.append(i == 0 ? "" : Character.valueOf('&')).append(entry.getKey()).append('=').append(valArray.get(i));
                }
                continue;
            }
            sb.append(entry.getKey()).append('=').append(value);
        }
        return sb.toString();
    }

    private static Map<String, Object> getMethodData(Map<String, Object> map) {
        LinkedHashMap<String, Object> getDataMap = (LinkedHashMap<String, Object>)map.get("data");
        if (getDataMap == null) {
            getDataMap = new LinkedHashMap<String, Object>(map.size());
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if ("data".equals(entry.getKey())) continue;
            getDataMap.put(entry.getKey(), entry.getValue());
        }
        return getDataMap;
    }

    private static void checkUrlExist(String url) {
        boolean exists = QueryServiceHelper.exists((String)"openapi_apilist", (QFilter[])new QFilter("urlformat", "=", (Object)url).toArray());
        if (!exists) {
            throw new OpenApiException(ApiErrorCode.HTTP_NOT_FOUND, "The api for this url does not exist!", new Object[0]);
        }
    }
}

