/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.util;

import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.StringUtil;

public enum ProductLineEnum {
    XING_HAN(1670332740597209088L, "Constellation", "1"),
    XING_KONG(1670332968834456576L, "kdgalaxy", "2");

    private Long id;
    private String code;
    private String source;

    private ProductLineEnum(Long id, String code, String source) {
        this.id = id;
        this.code = code;
        this.source = source;
    }

    public static ProductLineEnum getProductLineByCode(String code) {
        if (StringUtil.isEmpty((String)code)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "The code is null.", new Object[0]);
        }
        for (ProductLineEnum productLine : ProductLineEnum.values()) {
            if (!productLine.getCode().equals(code)) continue;
            return productLine;
        }
        throw new OpenApiException(ApiErrorCode.Data_Invalid, "Cannot find productLine for code:" + code, new Object[0]);
    }

    public Long getId() {
        return this.id;
    }

    public String getCode() {
        return this.code;
    }

    public String getSource() {
        return this.source;
    }
}

