/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.util;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kd.bos.exception.KDException;
import kd.bos.exception.LoginErrorCode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.util.McConfigUtil;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;

public class ShaSignUtils {
    private static final String UTF_8 = "UTF-8";
    private static final String SIGNATURE_TIME_RANGE_MINUTES = "signature_time_range_minutes";
    private static final String SHA256 = "HmacSHA256";
    public static String SIGNATUR_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static Log logger = LogFactory.getLog(ShaSignUtils.class);

    public static String genSHA256(String data, String key) {
        try {
            if (StringUtils.isEmpty((CharSequence)data) || StringUtils.isEmpty((CharSequence)key)) {
                return null;
            }
            SecretKeySpec signKey = new SecretKeySpec(key.getBytes(UTF_8), SHA256);
            Mac mac = Mac.getInstance(SHA256);
            mac.init(signKey);
            byte[] rawHmac = mac.doFinal(data.getBytes(UTF_8));
            byte[] result = Base64.encodeBase64((byte[])rawHmac);
            if (null != result) {
                return new String(result, UTF_8);
            }
            return null;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{e.getMessage()});
        }
    }

    public static String genSHA256(String data) {
        try {
            if (StringUtils.isEmpty((CharSequence)data)) {
                return null;
            }
            Mac mac = Mac.getInstance(SHA256);
            byte[] rawHmac = mac.doFinal(data.getBytes(UTF_8));
            byte[] result = Base64.encodeBase64((byte[])rawHmac);
            if (null != result) {
                return new String(result, UTF_8);
            }
            return null;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw new KDException(LoginErrorCode.loginBizException, new Object[]{e.getMessage()});
        }
    }

    public static String getSHA256StrJava1(String str) {
        String encodeStr = "";
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(str.getBytes(UTF_8));
            encodeStr = ShaSignUtils.byte2Hex(messageDigest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            logger.error((Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Throwable)e);
        }
        return encodeStr;
    }

    public static String HMACSHA256StrByKey(String data, String key) throws Exception {
        Mac sha256_HMAC = Mac.getInstance(SHA256);
        SecretKeySpec secret_key = new SecretKeySpec(key.getBytes(UTF_8), SHA256);
        sha256_HMAC.init(secret_key);
        byte[] array = sha256_HMAC.doFinal(data.getBytes(UTF_8));
        StringBuilder sb = new StringBuilder();
        for (byte item : array) {
            sb.append(Integer.toHexString(item & 0xFF | 0x100).substring(1, 3));
        }
        return sb.toString();
    }

    private static String byte2Hex(byte[] bytes) {
        StringBuilder stringBuffer = new StringBuilder();
        String temp = null;
        for (int i = 0; i < bytes.length; ++i) {
            temp = Integer.toHexString(bytes[i] & 0xFF);
            if (temp.length() == 1) {
                stringBuffer.append("0");
            }
            stringBuffer.append(temp);
        }
        return stringBuffer.toString();
    }

    public static int getSignRangeMinutes(String tenantId) {
        int returnValue = 10;
        String signRangeMinuteString = McConfigUtil.getPropertyByTenantWithDefault((String)tenantId, (String)SIGNATURE_TIME_RANGE_MINUTES, (String)"10");
        if (StringUtils.isEmpty((CharSequence)signRangeMinuteString)) {
            signRangeMinuteString = System.getProperty(SIGNATURE_TIME_RANGE_MINUTES);
        }
        try {
            returnValue = Integer.parseInt(signRangeMinuteString);
        }
        catch (Exception e) {
            logger.error("getSignRangeMinutes:" + e.getMessage(), (Throwable)e);
        }
        return returnValue;
    }

    public static StringBuilder getSignatureString(String datetimeString, String signatureNonce, String body) {
        StringBuilder sb = new StringBuilder();
        sb.append(body);
        sb.append(datetimeString);
        sb.append(signatureNonce);
        return sb;
    }
}

