/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.base.util;

import com.alibaba.fastjson.JSON;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.resource.SubSystemType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.RequestContextInfo;
import kd.bos.db.SqlParameter;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.dc.utils.MCDBUtil;
import kd.bos.dc.utils.SQLUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.isc.util.dt.D;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.base.security.api.impl.ApiSecurityFactory;
import kd.bos.openapi.base.util.LocalCacheUtil;
import kd.bos.openapi.base.util.LocalCacheUtils;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.ResSystemType;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.CacheUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.security.CertKeyUtil;
import kd.bos.openapi.security.model.BaseAuthInfoDto;
import kd.bos.openapi.security.model.CertificateInfo;
import kd.bos.openapi.security.model.Open3rdappsDto;

public class ThirdAppSecurityUtil {
    private static final Log log = LogFactory.getLog(ThirdAppSecurityUtil.class);
    private static final String ENABLE = "1";
    public static final String COSMIC_LOCAL_THIRDAPP = "cosmic_local_thirdapp";
    public static final String SPLIT = "-";
    private static String CACHE_TYPE_THIRD_NUM = "CACHE_TYPE_THIRD_NUM_AND_ID";
    private static final String FIND_THIRD_SQL = "select t.fid, t.fnumber,t.fstatus,t.fcreatorid,t.fmodifierid,t.fenable,t.fcreatetime,t.fmodifytime,t.fmasterid,t.fsyspwd, t.flastenabletime,t.flaststoptime,t.fpublickey,t.fwhitelist, t.fisbasicauth, t.fissignauth,t.fisresultsign, t.fisdigestauth, t.fisjwtauth, t.fjwtsigntype, t.fjwtshakey, t.fsigntype, t.fsignshakey, t.fisencryptallapi, t.fisallowalluser, t.fencryption, t.fisencryptallapi, t.fisenhancetoken, t.fisagencyuser, fauthpluginenable   from t_open_3rdapps t where  t.fenable='1' ";
    public static final String COSMIC_LOCAL_BASICAUTH = "cosmic_local_basicauth";
    private static final String AUTH_SQL = "select t.fid,p.fnumber,t.fagentuserid,t.fbasesigncode,t.fsystag,t.fremark, p.fisbasicauth from t_open_3rdapps_basicauth t left join t_open_3rdapps p on t.fid=p.fid where t.fstatus='1' and  p.fenable='1' and t.fbasesigncode = ? ";
    private static final String BASE_SIGN_CODE = "fbasesigncode";
    private static final String THIRD_NUMBER = "fnumber";
    private static final String FID = "fid";
    private static final String AGENT_USER_ID = "fagentuserid";

    public static Open3rdappsDto getOpen3rdApps(String accountId, String appId) {
        return ThirdAppSecurityUtil.getOpen3rdAppsBy(accountId, null, appId);
    }

    public static Open3rdappsDto getOpen3rdAppsById(String accountId, Long thirdId) {
        return ThirdAppSecurityUtil.getOpen3rdAppsBy(accountId, thirdId, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Open3rdappsDto getOpen3rdAppsBy(String accountId, Long thirdId, String appId) {
        if (StringUtil.isEmpty((String)accountId)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "getOpen3rdAppsBy failed: accountId is null", new Object[0]);
        }
        if (thirdId == null && StringUtil.isEmpty((String)appId)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "getOpen3rdAppsBy failed: thirdId/appId is null", new Object[0]);
        }
        Account account = AccountUtils.getAccountById((String)accountId);
        Properties dataBaseProperties = AccountUtils.getTenantDBInfo((Account)account);
        if (dataBaseProperties == null) {
            String msg = ResManager.loadKDString((String)"\u65e0\u6cd5\u83b7\u53d6\u79df\u6237\u6570\u636e\u5e93\u8fde\u63a5!", (String)"ThirdAppSecurityUtil_1", (String)ResSystemType.BASE.getType(), (Object[])new Object[0]);
            log.error(msg);
            throw new KDException(BosErrorCode.configNotFound, new Object[]{msg});
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        Open3rdappsDto apps = null;
        try {
            conn = MCDBUtil.getConnection((Account)account, (Properties)dataBaseProperties);
            String sql = FIND_THIRD_SQL;
            if (thirdId != null) {
                sql = sql + " and t.fid=? ";
            } else if (StringUtil.isNotEmpty((String)appId)) {
                sql = sql + " and t.fnumber=? ";
            }
            pstmt = conn.prepareStatement(sql);
            if (thirdId != null) {
                pstmt.setLong(1, thirdId);
            } else if (StringUtil.isNotEmpty((String)appId)) {
                pstmt.setString(1, appId);
            }
            rs = pstmt.executeQuery();
            if (rs.next()) {
                apps = new Open3rdappsDto();
                apps.setEnable(true);
                apps.setFid(Long.valueOf(rs.getLong(FID)));
                apps.setNumber(rs.getString(THIRD_NUMBER));
                apps.setWhiteList(rs.getString("fwhitelist"));
                apps.setDigestAuthEnable(ENABLE.equalsIgnoreCase(rs.getString("fisdigestauth")));
                apps.setDigestSignType(Long.valueOf(1L));
                apps.setDigestSignKey(rs.getString("fpublickey"));
                apps.setBasicAuthEnable(ENABLE.equalsIgnoreCase(rs.getString("fisbasicauth")));
                apps.setJwtAuthEnable(ENABLE.equalsIgnoreCase(rs.getString("fisjwtauth")));
                apps.setJwtSignType(Long.valueOf(rs.getLong("fjwtsigntype")));
                apps.setJwtShaKey(rs.getString("fjwtshakey"));
                apps.setSignAuthEnable(ENABLE.equalsIgnoreCase(rs.getString("fissignauth")));
                apps.setSignType(Long.valueOf(rs.getLong("fsigntype")));
                apps.setSignShaKey(rs.getString("fsignshakey"));
                apps.setEncryption(Long.valueOf(rs.getLong("fencryption")));
                apps.setEncryptAllApi(ENABLE.equalsIgnoreCase(rs.getString("fisencryptallapi")));
                apps.setResultSignHandle(ENABLE.equalsIgnoreCase(rs.getString("fisresultsign")));
                apps.setAccessToken(rs.getString("fsyspwd"));
                apps.setEnhanceToken(ENABLE.equalsIgnoreCase(rs.getString("fisenhancetoken")));
                apps.setEnableStartDate(rs.getTimestamp("flastenabletime") != null ? new java.util.Date(rs.getTimestamp("flastenabletime").getTime()) : null);
                apps.setEnableEndDate(rs.getTimestamp("flaststoptime") != null ? new java.util.Date(rs.getTimestamp("flaststoptime").getTime()) : null);
                apps.setEnableAgency(ENABLE.equalsIgnoreCase(rs.getString("fisagencyuser")));
                apps.setEnableAuthExtPlugin(ENABLE.equalsIgnoreCase(rs.getString("fauthpluginenable")));
            }
            if (apps != null) {
                ThirdAppSecurityUtil.loadCertMap(apps, conn);
            }
            if (apps != null) {
                ThirdAppSecurityUtil.loadEncryptApi(apps, conn);
            }
            if (apps != null) {
                ThirdAppSecurityUtil.loadAgencentUser(apps, conn);
            }
        }
        catch (SQLException e) {
            try {
                throw new KDException((Throwable)e, BosErrorCode.sQLConnection, new Object[]{String.format(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u914d\u7f6e\u6216\u8868\u7ed3\u6784\u4e0d\u6b63\u786e\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002%1$s", (String)"ThirdAppSecurityUtil_0", (SubSystemType)SubSystemType.BASE, (Object[])new Object[0]), e.getMessage())});
                catch (Exception e2) {
                    throw new KDException((Throwable)e2, BosErrorCode.sQLConnection, new Object[]{String.format(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u914d\u7f6e\u6216\u8868\u7ed3\u6784\u4e0d\u6b63\u786e\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002%1$s", (String)"ThirdAppSecurityUtil_0", (SubSystemType)SubSystemType.BASE, (Object[])new Object[0]), e2.getMessage())});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return apps;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void loadCertMap(Open3rdappsDto open3rdappsDto, Connection conn) {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            String sql = "select a.fnumber,a.fstarttime,a.fendtime, c.fpublickey,c.fprivatekey,c.fcertificatetype  from T_OPEN_CERTIFICATE_USE u  left join T_OPEN_CERT_AUTHORIZ a on u.fcaid=a.fid  left join T_OPEN_CERTIFICATE c on u.fcertificateid=c.fid  where a.fstatus='A' and c.fstatus='A' and u.fstatus='A' and u.fthirdid=? ";
            pstmt = conn.prepareStatement(sql);
            pstmt.setLong(1, open3rdappsDto.getFid());
            HashMap<String, CertificateInfo> certMap = new HashMap<String, CertificateInfo>(1);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                CertificateInfo certificateInfo;
                String publickey = rs.getString("fpublickey");
                String privatekey = rs.getString("fprivatekey");
                String certificatetype = rs.getString("fcertificatetype");
                Date startDate = rs.getDate("fstarttime");
                Date endDate = rs.getDate("fendtime");
                if (open3rdappsDto.isJwtAuthEnable() && "2".equalsIgnoreCase(certificatetype)) {
                    String jwtRSAKey = CertKeyUtil.getCertKey((String)"3", (String)certificatetype);
                    certificateInfo = new CertificateInfo(privatekey, publickey, certificatetype, (java.util.Date)startDate, (java.util.Date)endDate, "A");
                    certMap.put(jwtRSAKey, certificateInfo);
                }
                if (!open3rdappsDto.isSignAuthEnable() || "2".equalsIgnoreCase(certificatetype)) continue;
                String signRSAKey = CertKeyUtil.getCertKey((String)"5", (String)certificatetype);
                certificateInfo = new CertificateInfo(privatekey, publickey, certificatetype, (java.util.Date)startDate, (java.util.Date)endDate, "A");
                certMap.put(signRSAKey, certificateInfo);
            }
            open3rdappsDto.setCertMaps(certMap);
        }
        catch (SQLException e) {
            try {
                throw new KDException((Throwable)e, BosErrorCode.sQLConnection, new Object[]{String.format(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u914d\u7f6e\u6216\u8868\u7ed3\u6784\u4e0d\u6b63\u786e\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002%1$s", (String)"ThirdAppSecurityUtil_0", (SubSystemType)SubSystemType.BASE, (Object[])new Object[0]), e.getMessage())});
                catch (Exception e2) {
                    throw new KDException((Throwable)e2, BosErrorCode.sQLConnection, new Object[]{String.format(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u914d\u7f6e\u6216\u8868\u7ed3\u6784\u4e0d\u6b63\u786e\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002%1$s", (String)"ThirdAppSecurityUtil_0", (SubSystemType)SubSystemType.BASE, (Object[])new Object[0]), e2.getMessage())});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)pstmt, null);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, null);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void loadEncryptApi(Open3rdappsDto open3rdappsDto, Connection conn) {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            String sql = "select t.FAPIID,i.furlformat from T_OPEN_3RDAPPS_ENCRYPTAPI t left join t_open_apiservice i on t.fapiid=i.fid  where t.fid = ? and i.fversion ='2' and fhttpmethod='1' ";
            pstmt = conn.prepareStatement(sql);
            pstmt.setLong(1, open3rdappsDto.getFid());
            HashMap<String, String> encryptApiMap = new HashMap<String, String>(1);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                String sortUrl = rs.getString("furlformat");
                encryptApiMap.put(sortUrl, ENABLE);
            }
            open3rdappsDto.setEncryptApiMap(encryptApiMap);
        }
        catch (SQLException e) {
            try {
                throw new KDException((Throwable)e, BosErrorCode.sQLConnection, new Object[]{String.format(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u914d\u7f6e\u6216\u8868\u7ed3\u6784\u4e0d\u6b63\u786e\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002%1$s", (String)"ThirdAppSecurityUtil_0", (SubSystemType)SubSystemType.BASE, (Object[])new Object[0]), e.getMessage())});
                catch (Exception e2) {
                    throw new KDException((Throwable)e2, BosErrorCode.sQLConnection, new Object[]{String.format(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u914d\u7f6e\u6216\u8868\u7ed3\u6784\u4e0d\u6b63\u786e\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002%1$s", (String)"ThirdAppSecurityUtil_0", (SubSystemType)SubSystemType.BASE, (Object[])new Object[0]), e2.getMessage())});
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)pstmt, null);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, null);
    }

    private static void loadAgencentUser(Open3rdappsDto open3rdappsDto, Connection conn) {
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            String sql = "select t.fpkid,t.fid,t.fbasedataid from t_open_3rdapps_agency t where t.fid=? ";
            pstmt = conn.prepareStatement(sql);
            pstmt.setLong(1, open3rdappsDto.getFid());
            ArrayList<Long> agentUserIdList = new ArrayList<Long>(1);
            rs = pstmt.executeQuery();
            while (rs.next()) {
                Long agentUserId = rs.getLong("fbasedataid");
                if (agentUserId == null || agentUserId == 0L) continue;
                agentUserIdList.add(agentUserId);
            }
            open3rdappsDto.setAgentUserIdList(agentUserIdList);
        }
        catch (Exception e) {
            try {
                throw new KDException((Throwable)e, BosErrorCode.sQLConnection, new Object[]{String.format(ResManager.loadKDString((String)"\u6570\u636e\u5e93\u914d\u7f6e\u6216\u8868\u7ed3\u6784\u4e0d\u6b63\u786e\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002%1$s", (String)"ThirdAppSecurityUtil_0", (SubSystemType)SubSystemType.BASE, (Object[])new Object[0]), e.getMessage())});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, (Statement)pstmt, null);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, null);
    }

    public static Long getThirdIdByNum(String thirdAppNumber, String accountId) {
        Long value = D.l((Object)CacheUtil.getCacheByKey((String)CACHE_TYPE_THIRD_NUM, (String)thirdAppNumber, (String)accountId));
        if (value != null && value != 0L) {
            return value;
        }
        Long thirdId = null;
        Account account = AccountUtils.getAccountById((String)accountId);
        RequestContextInfo rc = new RequestContextInfo(account.getTenantId(), account.getAccountId());
        try (AutoCloseable ignored = rc.setupThreadRequestContext();){
            String sql = " select fid from t_open_3rdapps t where t.fnumber = ? and t.fenable ='1' ";
            Object[] params = new SqlParameter[]{new SqlParameter(":fnumber", 12, (Object)thirdAppNumber)};
            thirdId = (Long)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, rs -> {
                if (rs.next()) {
                    return rs.getLong(FID);
                }
                return null;
            });
        }
        catch (Exception e) {
            log.error("getThirdIdByNum error:" + e.getMessage(), (Throwable)e);
        }
        if (thirdId != null) {
            CacheUtil.setCacheByKey((String)CACHE_TYPE_THIRD_NUM, (String)thirdAppNumber, thirdId, (String)accountId);
        }
        return thirdId;
    }

    public static Open3rdappsDto getThirdByAccountAndAppId(String accountId, String appId) {
        Long thirdId = ThirdAppSecurityUtil.getThirdIdByNum(appId, accountId);
        if (thirdId == null) {
            return null;
        }
        return ThirdAppSecurityUtil.getThirdByAccountAndThirdId(accountId, thirdId);
    }

    public static Open3rdappsDto getThirdByAccountAndThirdId(String accountId, Long thirdId) {
        if (StringUtil.isEmpty((String)accountId)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "getOpen3rdAppsBy failed: accountId is null", new Object[0]);
        }
        if (thirdId == null) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "getOpen3rdAppsBy failed: thirdId is null", new Object[0]);
        }
        Open3rdappsDto thirdApp = null;
        String key = COSMIC_LOCAL_THIRDAPP.concat(SPLIT).concat(accountId).concat(SPLIT).concat(thirdId.toString());
        if (accountId != null) {
            Object listObj = LocalCacheUtil.getCacheByKey(COSMIC_LOCAL_THIRDAPP, key);
            if (listObj == null) {
                thirdApp = ThirdAppSecurityUtil.getOpen3rdAppsById(accountId, thirdId);
                if (thirdApp != null) {
                    LocalCacheUtil.setCacheByKey(COSMIC_LOCAL_THIRDAPP, key, thirdApp);
                }
            } else {
                thirdApp = (Open3rdappsDto)listObj;
            }
        }
        return thirdApp;
    }

    public static void removeCache(String accountId, String thirdId) {
        String key = COSMIC_LOCAL_THIRDAPP.concat(SPLIT).concat(accountId).concat(SPLIT).concat(thirdId);
        LocalCacheUtils.remove(key);
        LocalCacheUtil.removeCacheByKey(COSMIC_LOCAL_THIRDAPP, key);
    }

    public static void removeThirdNumCache(String accountId, String thirdAppNumber) {
        CacheUtil.removeCacheByKey((String)CACHE_TYPE_THIRD_NUM, (String)thirdAppNumber, (String)accountId);
    }

    public static BaseAuthInfoDto getBaseAuthInfoBySign(String accountId, String sign) {
        if (ApiSecurityFactory.isSecurityLogOpen()) {
            log.info("--------getBaseAuthInfoBySign traceId:" + RequestContext.get().getTraceId() + " accountId:" + accountId + " sign:" + sign);
        }
        if (StringUtil.isEmpty((String)accountId)) {
            return BaseAuthInfoDto.fail((String)"invalid account is null");
        }
        BaseAuthInfoDto baseAuthInfo = null;
        String cacheSignKey = "cosmic_local_basicauth-" + accountId + SPLIT + sign;
        Object listObj = LocalCacheUtils.get(cacheSignKey);
        if (listObj == null) {
            baseAuthInfo = ThirdAppSecurityUtil.getBasicAuthInfo(accountId, sign);
            if (baseAuthInfo != null) {
                LocalCacheUtils.put(cacheSignKey, baseAuthInfo);
            }
        } else {
            baseAuthInfo = (BaseAuthInfoDto)listObj;
        }
        if (ApiSecurityFactory.isSecurityLogOpen() && baseAuthInfo != null) {
            log.info("--------getBaseAuthInfoBySign traceId:" + RequestContext.get().getTraceId() + " baseAuthInfo:" + JSON.toJSONString((Object)baseAuthInfo));
        }
        return baseAuthInfo;
    }

    public static BaseAuthInfoDto getBasicAuthInfo(String accountId, String baseSignCode) {
        BaseAuthInfoDto baseAuthInfoDto;
        Account account = AccountUtils.getAccountById((String)accountId);
        Properties dataBaseProperties = AccountUtils.getTenantDBInfo((Account)account);
        BaseAuthInfoDto baseAuthInfo = new BaseAuthInfoDto();
        if (StringUtil.isEmpty((String)baseSignCode)) {
            return BaseAuthInfoDto.fail((String)"failed");
        }
        Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            conn = MCDBUtil.getConnection((Account)account, (Properties)dataBaseProperties);
            pstmt = conn.prepareStatement(AUTH_SQL);
            pstmt.setString(1, baseSignCode);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                baseAuthInfo.setAgentUserId(rs.getLong(AGENT_USER_ID) != 0L ? Long.valueOf(rs.getLong(AGENT_USER_ID)) : null);
                baseAuthInfo.setThirdId(Long.valueOf(rs.getLong(FID)));
                baseAuthInfo.setThirdNumber(rs.getString(THIRD_NUMBER));
                baseAuthInfo.setStatus(true);
                baseAuthInfo.setBasicAuth(ENABLE.equals(rs.getString("fisbasicauth")));
                baseAuthInfo.setSysTag(rs.getString("fsystag"));
                baseAuthInfo.setRemark(rs.getString("fremark"));
            }
            baseAuthInfoDto = baseAuthInfo;
        }
        catch (Exception e) {
            try {
                throw new KDException((Throwable)e, BosErrorCode.sQLConnection, new Object[]{e.getMessage()});
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pstmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pstmt, (Connection)conn);
        return baseAuthInfoDto;
    }
}

