/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.action.api.operation;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.openapi.action.api.operation.upper.AbstractEntryApiOperation;
import kd.bos.openapi.action.util.DataMappingUtil;
import kd.bos.openapi.api.QueryApiService;
import kd.bos.openapi.api.model.OpenApiRequest;
import kd.bos.openapi.api.params.ApiQueyParam;
import kd.bos.openapi.api.result.ApiQueryResult;
import kd.bos.openapi.api.result.ApiServiceData;
import kd.bos.openapi.base.model.ApiResponseModel;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.ApiServiceType;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.spi.OpenApiDataServiceFactory;
import kd.bos.openapi.common.util.DataUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.servicehelper.DispatchApiServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ApiQuery
extends AbstractEntryApiOperation<Void, ApiQueryResult> {
    public static final int MAX_PAGE_SIZE = 10000;
    private static final String BOS_OPEN_ACTION = "bos-open-action";
    private final int pageSize;
    private final int pageNum;

    public ApiQuery(OpenApiRequest<Map<String, Object>> request) {
        super(request);
        int maxPageSize;
        Object pageNumObj = this.requestData.get("pageNo");
        if (pageNumObj == null) {
            this.pageNum = 1;
        } else {
            try {
                this.pageNum = DataUtil.i(pageNumObj);
            }
            catch (Exception e) {
                throw new OpenApiException(ApiErrorCode.HTTP_BAD_REQUEST, ResManager.loadKDString((String)"\u9875\u7801pageNo\u7684\u53d6\u503c\u8303\u56f4\u662f[%1$s, %2$s]\u7684\u6b63\u6574\u6570\u3002", (String)"ApiQuery_0", (String)BOS_OPEN_ACTION, (Object[])new Object[0]), new Object[]{1, Integer.MAX_VALUE});
            }
            if (this.pageNum <= 0) {
                throw new OpenApiException(ApiErrorCode.HTTP_BAD_REQUEST, ResManager.loadKDString((String)"\u9875\u7801pageNo\u7684\u53d6\u503c\u8303\u56f4\u662f[%1$s, %2$s]\u7684\u6b63\u6574\u6570\u3002", (String)"ApiQuery_0", (String)BOS_OPEN_ACTION, (Object[])new Object[0]), new Object[]{1, Integer.MAX_VALUE});
            }
        }
        String maxPageSizeStr = OpenApiDataServiceFactory.getOpenApiDataService().getSysParameter("api_query_maxpagesize", String.valueOf(10000));
        try {
            maxPageSize = maxPageSizeStr == null ? 10000 : DataUtil.i((Object)maxPageSizeStr);
        }
        catch (Exception e) {
            throw new OpenApiException(ApiErrorCode.HTTP_BAD_REQUEST, ResManager.loadKDString((String)"\u53c2\u6570\u9762\u677f\u8bbe\u7f6e\u6700\u5927\u9875\u5927\u5c0f\u975e\u6cd5\uff0c\u5fc5\u987b\u662f\u5927\u4e8e0\u7684\u6b63\u6574\u6570\u3002", (String)"ApiQuery_1", (String)BOS_OPEN_ACTION, (Object[])new Object[0]), new Object[0]);
        }
        if (maxPageSize < 1) {
            throw new OpenApiException(ApiErrorCode.HTTP_BAD_REQUEST, ResManager.loadKDString((String)"\u53c2\u6570\u9762\u677f\u8bbe\u7f6e\u6700\u5927\u9875\u5927\u5c0f\u975e\u6cd5\uff0c\u5fc5\u987b\u662f\u5927\u4e8e0\u7684\u6b63\u6574\u6570\u3002", (String)"ApiQuery_1", (String)BOS_OPEN_ACTION, (Object[])new Object[0]), new Object[0]);
        }
        Object pageSizeObj = this.requestData.get("pageSize");
        if (pageSizeObj == null) {
            throw new OpenApiException(ApiErrorCode.HTTP_BAD_REQUEST, ResManager.loadKDString((String)"\u9875\u5927\u5c0fpageSize\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ApiQuery_2", (String)BOS_OPEN_ACTION, (Object[])new Object[0]), new Object[0]);
        }
        try {
            this.pageSize = DataUtil.i(pageSizeObj);
        }
        catch (Exception e) {
            throw new OpenApiException(ApiErrorCode.HTTP_BAD_REQUEST, ResManager.loadKDString((String)"\u9875\u5927\u5c0fpageSize\u7684\u53d6\u503c\u8303\u56f4\u662f[%1$s, %2$s]\u7684\u6b63\u6574\u6570\u3002", (String)"ApiQuery_3", (String)BOS_OPEN_ACTION, (Object[])new Object[0]), new Object[]{1, maxPageSize});
        }
        if (this.pageSize < 1 || this.pageSize > maxPageSize) {
            throw new OpenApiException(ApiErrorCode.HTTP_BAD_REQUEST, ResManager.loadKDString((String)"\u9875\u5927\u5c0fpageSize\u7684\u53d6\u503c\u8303\u56f4\u662f[%1$s, %2$s]\u7684\u6b63\u6574\u6570\u3002", (String)"ApiQuery_3", (String)BOS_OPEN_ACTION, (Object[])new Object[0]), new Object[]{1, maxPageSize});
        }
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getPageNum() {
        return this.pageNum;
    }

    @Override
    public void validator() {
        super.validator();
    }

    @Override
    public ApiServiceData<ApiQueryResult> invoke(Void aVoid) {
        ApiQueyParam param = new ApiQueyParam(this.request);
        param.setPlugins(this.getApiPlugin());
        param.setFormId(this.api.getFormId());
        param.setOrderBys(this.api.getOrderBy());
        param.setPageSize(this.getPageSize());
        param.setPageNo(this.getPageNum());
        param.setDyObjResult(this.api.isDyObjResult());
        param.setPluginOriginTypeMap(this.api.getPluginOriginTypeMap());
        param.setSelectSet(this.api.getSelectSet());
        param.setQuerySelect(this.api.getQuerySelect());
        long offset = BigInteger.valueOf(this.getPageNum()).multiply(BigInteger.valueOf(this.getPageSize())).longValue();
        if (offset > Integer.MAX_VALUE || offset < 0L) {
            throw new OpenApiException(ApiErrorCode.HTTP_BAD_REQUEST, ResManager.loadKDString((String)"\u5206\u9875\u53c2\u6570[%1$s, %2$s]\u7684\u6570\u636e\u504f\u79fb\u91cf\u8d85\u8fc7\u6700\u5927\u503c %3$s\u3002", (String)"ApiQuery_5", (String)BOS_OPEN_ACTION, (Object[])new Object[0]), new Object[]{this.getPageSize(), this.getPageNum(), Integer.MAX_VALUE});
        }
        ApiServiceData queryResult = (ApiServiceData)DispatchApiServiceHelper.invokeApiService((String)QueryApiService.class.getSimpleName(), (Object[])new Object[]{param});
        if (param.isDyObjResult()) {
            return queryResult;
        }
        List<ApiResponseModel> responseList = this.checkIsQueryId();
        List<Map<String, Object>> mappingResult = DataMappingUtil.mappingResult(((ApiQueryResult)queryResult.getResponse().getData()).getRows(), responseList);
        ((ApiQueryResult)queryResult.getResponse().getData()).setRows(mappingResult);
        return queryResult;
    }

    private List<ApiResponseModel> checkIsQueryId() {
        String queryId;
        Map requestHeaders = this.request.getRequestHeaders();
        List responseList = this.api.getResponseList();
        if (requestHeaders != null && requestHeaders.size() > 0 && StringUtil.isNotEmpty((String)(queryId = (String)requestHeaders.get("X-OpenApi-QueryId"))) && "true".equals(queryId)) {
            ArrayList<ApiResponseModel> newResponseList = new ArrayList<ApiResponseModel>(responseList);
            DynamicObject newApi = BusinessDataServiceHelper.newDynamicObject((String)"openapi_apilist");
            DynamicObjectCollection respentryentity = newApi.getDynamicObjectCollection("respentryentity");
            DynamicObject resEntry = respentryentity.addNew();
            resEntry.set("respparamname", (Object)"id");
            resEntry.set("respobjpropname", (Object)"id");
            resEntry.set("respparamtype", (Object)"Long");
            resEntry.set("resp_level", (Object)1);
            ApiResponseModel apiResponseModel = new ApiResponseModel(resEntry, ApiServiceType.OPERATION);
            newResponseList.add(apiResponseModel);
            return newResponseList;
        }
        return responseList;
    }
}

