/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.action.api.script;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.openapi.base.model.ApiRequestModel;
import kd.bos.openapi.base.model.ApiResponseModel;
import kd.bos.openapi.base.model.BaseApiParamModel;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.DataType;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.StringUtil;

public class ApiScriptUtil {
    private static final String BOS_OPEN_ACTION = "bos-open-action";

    public static void validator(Map<String, Object> reqData, List<ApiRequestModel> list) {
        if (reqData == null || list == null) {
            return;
        }
        Map<Long, List<ApiRequestModel>> map = list.stream().collect(Collectors.groupingBy(BaseApiParamModel::getPid));
        ApiScriptUtil.validator(0L, map, reqData, null);
    }

    private static void validator(Long pid, Map<Long, List<ApiRequestModel>> map, Map<?, ?> reqData, String parentParamName) {
        List<ApiRequestModel> list = map.remove(pid);
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        for (ApiRequestModel model : list) {
            String currParamName = ApiScriptUtil.getParentPrefix(parentParamName) + model.getParamName();
            Object value = reqData.get(model.getParamName());
            ApiScriptUtil.validator(map, model, currParamName, value);
        }
    }

    private static void validator(Map<Long, List<ApiRequestModel>> map, ApiRequestModel model, String currParamName, Object value) {
        DataType dataType = DataType.getByType((String)model.getParamType());
        boolean isArray = ApiScriptUtil.isArray(value);
        if (DataType.ANY == dataType) {
            if (value != null && model.isMulValue() && !isArray) {
                throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u3010{0}\u3011\u7684\u7c7b\u578b\u4e3a {1} \u6570\u7ec4\uff0c\u53c2\u6570\u503c\u7c7b\u578b\u9519\u8bef\u3002", (String)"ApiScriptUtil_0", (String)BOS_OPEN_ACTION, (Object[])new Object[0]), new Object[]{currParamName, model.getParamType()});
            }
            return;
        }
        ApiScriptUtil.checkParam(model, currParamName, value);
        value = ApiScriptUtil.getStructValue(model, value, dataType);
        if (value instanceof Map) {
            ApiScriptUtil.validator(model.getId(), map, (Map)value, currParamName);
        } else if (value instanceof List) {
            List array = (List)value;
            for (int i = 0; i < array.size(); ++i) {
                String newCurrParamName = ApiScriptUtil.getCurrArrayParamName(currParamName, i);
                Object obj = array.get(i);
                if ((obj = ApiScriptUtil.getStructValue(model, obj, model.getParamType())) instanceof Map) {
                    ApiScriptUtil.validator(model.getId(), map, (Map)obj, newCurrParamName);
                    continue;
                }
                if (obj instanceof List) {
                    List jsonArray = (List)obj;
                    for (int j = 0; j < jsonArray.size(); ++j) {
                        String newCurrParamName2 = ApiScriptUtil.getCurrArrayParamName(newCurrParamName, j);
                        Object o = jsonArray.get(j);
                        ApiScriptUtil.validator2(map, model, newCurrParamName2, o);
                    }
                    continue;
                }
                ApiScriptUtil.checkValue(model, newCurrParamName, obj);
            }
        } else {
            ApiScriptUtil.checkValue(model, currParamName, value);
        }
    }

    private static Object getStructValue(ApiRequestModel model, Object value, String dataType) {
        return ApiScriptUtil.getStructValue(model, value, DataType.getByType((String)dataType));
    }

    private static Object getStructValue(ApiRequestModel model, Object value, DataType dataType) {
        if (value == null && DataType.STRUCT == dataType) {
            value = model.isMulValue() ? Collections.singletonList(Collections.emptyMap()) : Collections.emptyMap();
        }
        return value;
    }

    private static void validator2(Long pid, Map<Long, List<ApiRequestModel>> map, Map<?, ?> reqData, String parentParamName) {
        List<ApiRequestModel> list = map.remove(pid);
        if (CollectionUtil.isEmpty(list)) {
            return;
        }
        for (ApiRequestModel model : list) {
            String currParamName = ApiScriptUtil.getParentPrefix(parentParamName) + model.getParamName();
            Object value = reqData.get(model.getParamName());
            ApiScriptUtil.checkMustInput(model, currParamName, value);
            ApiScriptUtil.validator2(map, model, currParamName, value);
        }
    }

    private static void validator2(Map<Long, List<ApiRequestModel>> map, ApiRequestModel model, String currParamName, Object value) {
        if ((value = ApiScriptUtil.getStructValue(model, value, model.getParamType())) instanceof Map) {
            ApiScriptUtil.validator2(model.getId(), map, (Map)value, currParamName);
        } else if (value instanceof List) {
            List array = (List)value;
            for (int i = 0; i < array.size(); ++i) {
                String newCurrParamName = ApiScriptUtil.getCurrArrayParamName(currParamName, i);
                Object obj = array.get(i);
                if ((obj = ApiScriptUtil.getStructValue(model, obj, model.getParamType())) instanceof Map) {
                    ApiScriptUtil.validator2(model.getId(), map, (Map)obj, newCurrParamName);
                    continue;
                }
                if (obj instanceof List) {
                    List jsonArray = (List)obj;
                    for (int j = 0; j < jsonArray.size(); ++j) {
                        String newCurrParamName2 = ApiScriptUtil.getCurrArrayParamName(newCurrParamName, j);
                        Object o = jsonArray.get(j);
                        ApiScriptUtil.validator2(map, model, newCurrParamName2, o);
                    }
                    continue;
                }
                ApiScriptUtil.checkValue(model, newCurrParamName, obj);
            }
        } else {
            ApiScriptUtil.checkValue(model, currParamName, value);
        }
    }

    private static boolean isArray(Object value) {
        if (value == null) {
            return false;
        }
        return value instanceof List || value.getClass().isArray();
    }

    private static void checkParam(ApiRequestModel model, String currParamName, Object value) {
        ApiScriptUtil.checkType(model, currParamName, value);
        ApiScriptUtil.checkMustInput(model, currParamName, value);
    }

    private static void checkMustInput(ApiRequestModel model, String currParamName, Object value) {
        if (model.isMustInput()) {
            String message = ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570 %s \u5fc5\u586b", (String)"ApiScriptUtil_1", (String)BOS_OPEN_ACTION, (Object[])new Object[0]);
            if (value == null) {
                throw new OpenApiException(ApiErrorCode.Data_Invalid, message, new Object[]{currParamName});
            }
            if (DataType.STRING.type().equals(model.getParamType()) && value instanceof String && StringUtil.isEmpty((String)((String)value))) {
                throw new OpenApiException(ApiErrorCode.Data_Invalid, message, new Object[]{currParamName});
            }
            if (model.isMulValue()) {
                if (value instanceof List && CollectionUtil.isEmpty((Collection)((List)value))) {
                    throw new OpenApiException(ApiErrorCode.Data_Invalid, message, new Object[]{currParamName});
                }
                if (value.getClass().isArray() && CollectionUtil.isEmpty((Object[])((Object[])value))) {
                    throw new OpenApiException(ApiErrorCode.Data_Invalid, message, new Object[]{currParamName});
                }
            }
        }
    }

    private static void checkType(ApiRequestModel model, String currParamName, Object value) {
        if (value == null) {
            return;
        }
        DataType dataType = DataType.getByType((String)model.getParamType());
        String message = ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u3010{0}\u3011\u7684\u7c7b\u578b\u4e3a {1} \u6570\u7ec4\uff0c\u53c2\u6570\u503c\u7c7b\u578b\u9519\u8bef\u3002", (String)"ApiScriptUtil_0", (String)BOS_OPEN_ACTION, (Object[])new Object[0]);
        String message1 = ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u3010{0}\u3011\u7684\u7c7b\u578b\u4e3a {1}\uff0c\u53c2\u6570\u503c\u7c7b\u578b\u9519\u8bef\u3002", (String)"ApiScriptUtil_2", (String)BOS_OPEN_ACTION, (Object[])new Object[0]);
        if (DataType.STRUCT == dataType && !model.isMulValue() && !(value instanceof Map)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, message1, new Object[]{currParamName, model.getParamType()});
        }
        boolean isArray = ApiScriptUtil.isArray(value);
        if (model.isMulValue() && !isArray) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, message, new Object[]{ApiScriptUtil.conventCurrParamName(currParamName), model.getParamType()});
        }
        if (isArray && !model.isMulValue()) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, message1, new Object[]{currParamName, model.getParamType()});
        }
    }

    private static String conventCurrParamName(String currParamName) {
        if (currParamName.endsWith("]")) {
            return ApiScriptUtil.conventCurrParamName(currParamName.substring(0, currParamName.lastIndexOf(91)));
        }
        return currParamName;
    }

    private static void checkValue(ApiRequestModel model, String currParamName, Object value) {
        DataType dataType = DataType.getByType((String)model.getParamType());
        try {
            dataType.validator(value);
        }
        catch (Exception e) {
            String message = ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u3010{0}\u3011\u7684\u7c7b\u578b\u4e3a {1}\uff0c\u53c2\u6570\u503c\u7c7b\u578b\u9519\u8bef\u3002", (String)"ApiScriptUtil_2", (String)BOS_OPEN_ACTION, (Object[])new Object[0]);
            throw new OpenApiException((Throwable)e, ApiErrorCode.Data_Invalid, message, new Object[]{currParamName, model.getParamType()});
        }
    }

    private static String getCurrArrayParamName(String parentParamName, int i) {
        return parentParamName + "[" + i + "]";
    }

    private static String getParentPrefix(String parentParamName) {
        return parentParamName == null ? "" : parentParamName + ".";
    }

    public static Map<String, Object> getResult(Map<String, Object> data, List<ApiResponseModel> responseList) {
        if (CollectionUtil.isEmpty(responseList)) {
            return Collections.emptyMap();
        }
        if (data == null) {
            data = Collections.emptyMap();
        }
        Map<Long, List<ApiResponseModel>> map = responseList.stream().collect(Collectors.groupingBy(BaseApiParamModel::getPid));
        return ApiScriptUtil.getResult(0L, map, (Map<String, Object>)new JSONObject(data), null);
    }

    private static Map<String, Object> getResult(Long pid, Map<Long, List<ApiResponseModel>> map, Map<String, Object> respData, String parentParamName) {
        List<ApiResponseModel> list = map.get(pid);
        if (CollectionUtil.isEmpty(list)) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> result = new HashMap<String, Object>(list.size());
        String message = ResManager.loadKDString((String)"\u8fd4\u56de\u53c2\u6570\u3010{0}\u3011\u7684\u7c7b\u578b\u4e3a {1} \u6570\u7ec4\uff0c\u8fd4\u56de\u503c\u7c7b\u578b\u9519\u8bef\u3002", (String)"ApiScriptUtil_3", (String)BOS_OPEN_ACTION, (Object[])new Object[0]);
        String message1 = ResManager.loadKDString((String)"\u8fd4\u56de\u53c2\u6570\u3010%1$s\u3011\u7684\u7c7b\u578b\u4e3a %2$s\uff0c\u8fd4\u56de\u503c\u7c7b\u578b\u9519\u8bef\u3002", (String)"ApiScriptUtil_4", (String)BOS_OPEN_ACTION, (Object[])new Object[0]);
        for (ApiResponseModel model : list) {
            Object value = respData.get(model.getParamName());
            if (value == null) {
                result.put(model.getParamName(), null);
                continue;
            }
            String currParamName = ApiScriptUtil.getParentPrefix(parentParamName) + model.getParamName();
            DataType dataType = DataType.getByType((String)model.getParamType());
            if (DataType.ANY == dataType) {
                boolean isArray = ApiScriptUtil.isArray(value);
                if (model.isMulValue() && !isArray) {
                    throw new OpenApiException(ApiErrorCode.Data_Invalid, message, new Object[]{currParamName, model.getParamType()});
                }
                result.put(model.getParamName(), value);
                continue;
            }
            if (value instanceof Map) {
                Map obj = (Map)value;
                if (model.isMulValue() || DataType.STRUCT != dataType) {
                    throw new OpenApiException(ApiErrorCode.Data_Invalid, message, new Object[]{currParamName, model.getParamType()});
                }
                result.put(model.getParamName(), ApiScriptUtil.getResult(model.getId(), map, obj, currParamName));
                continue;
            }
            if (value instanceof List) {
                if (!model.isMulValue()) {
                    throw new OpenApiException(ApiErrorCode.Data_Invalid, message1, new Object[]{currParamName, model.getParamType()});
                }
                List array = (List)value;
                List<Object> objectList = ApiScriptUtil.getArrayResult(map, model, array, currParamName);
                result.put(model.getParamName(), objectList);
                continue;
            }
            if (model.isMulValue()) {
                throw new OpenApiException(ApiErrorCode.Data_Invalid, message, new Object[]{currParamName, model.getParamType()});
            }
            try {
                result.put(model.getParamName(), dataType.validator(value));
            }
            catch (Exception e) {
                throw new OpenApiException((Throwable)e, ApiErrorCode.Data_Invalid, message1, new Object[]{currParamName, model.getParamType()});
            }
        }
        return result;
    }

    private static List<Object> getArrayResult(Map<Long, List<ApiResponseModel>> map, ApiResponseModel model, List<?> array, String currParamName) {
        ArrayList<Object> objectList = new ArrayList<Object>(array.size());
        for (int i = 0; i < array.size(); ++i) {
            Object obj;
            String newCurrParamName = ApiScriptUtil.getCurrArrayParamName(currParamName, i);
            Object value = ApiScriptUtil.getObj(map, model, newCurrParamName, obj = array.get(i));
            if (value instanceof Map && ((Map)value).isEmpty()) continue;
            objectList.add(value);
        }
        return objectList;
    }

    private static Object getObj(Map<Long, List<ApiResponseModel>> map, ApiResponseModel model, String currParamName, Object obj) {
        DataType dataType = DataType.getByType((String)model.getParamType());
        String message = ResManager.loadKDString((String)"\u8fd4\u56de\u53c2\u6570\u3010%1$s\u3011\u7684\u7c7b\u578b\u4e3a %2$s\uff0c\u8fd4\u56de\u503c\u7c7b\u578b\u9519\u8bef\u3002", (String)"ApiScriptUtil_4", (String)BOS_OPEN_ACTION, (Object[])new Object[0]);
        if (obj instanceof Map) {
            if (DataType.STRUCT != dataType) {
                throw new OpenApiException(ApiErrorCode.Data_Invalid, message, new Object[]{currParamName, model.getParamType()});
            }
            return ApiScriptUtil.getResult(model.getId(), map, (Map)obj, currParamName);
        }
        if (obj instanceof List) {
            List array2 = (List)obj;
            ArrayList<Object> objList = new ArrayList<Object>(array2.size());
            for (int j = 0; j < array2.size(); ++j) {
                String newCurrParamName = ApiScriptUtil.getCurrArrayParamName(currParamName, j);
                Object obj2 = array2.get(j);
                objList.add(ApiScriptUtil.getObj(map, model, newCurrParamName, obj2));
            }
            return objList;
        }
        try {
            return dataType.validator(obj);
        }
        catch (Exception e) {
            throw new OpenApiException((Throwable)e, ApiErrorCode.Data_Invalid, message, new Object[]{currParamName, model.getParamType()});
        }
    }
}

