/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.web.api;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDException;
import kd.bos.kcf.ServiceContext;
import kd.bos.kcf.ServiceType;
import kd.bos.kcf.message.HttpMethod;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.model.OpenApiData;
import kd.bos.openapi.common.spi.OpenApiDataService;
import kd.bos.openapi.common.spi.OpenApiDataServiceFactory;
import kd.bos.openapi.kcf.utils.IdempotencyUtil;
import kd.bos.web.DispatchServiceHelper;
import kd.bos.web.api.ApiServiceLogHelper;
import kd.bos.web.api.OpenApiExceptionUtils;
import kd.bos.web.api.OpenApiLocalCache;
import kd.bos.web.api.OpenApiUtils;
import org.apache.commons.lang3.StringUtils;

public class AIServiceType
extends ServiceType {
    private Log log = LogFactory.getLog(AIServiceType.class);
    private static final String BOS_WEBACTIONS = "bos-webactions";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ServiceContext ctx) {
        JSONObject data;
        this.checkClientIP();
        RequestContext rc = RequestContext.get();
        String api3rdAppId = rc.getApi3rdAppId();
        String json = (String)ctx.getRequest().getData();
        if (ctx.getRequest().getMethod() == HttpMethod.Post) {
            ApiServiceLogHelper.LogInfo(json);
        }
        try {
            if (StringUtils.isEmpty((CharSequence)json)) {
                ctx.getResponse().fail("data not found!");
                return;
            }
            data = (JSONObject)JSONObject.parse((String)json);
        }
        catch (Exception e) {
            ctx.getResponse().fail("incorrect json format!");
            return;
        }
        String command = data.getString("command");
        if (StringUtils.isEmpty((CharSequence)command)) {
            ctx.getResponse().fail("command not found!");
            return;
        }
        String apiserviceId = OpenApiUtils.getApiserviceIdforAi(command);
        boolean canUseed = OpenApiLocalCache.open3rdappsApiCanUsed(api3rdAppId, apiserviceId);
        if (!canUseed) {
            ctx.getResponse().fail(ResManager.loadKDString((String)"\u8be5\u7b2c\u4e09\u65b9\u6ca1\u6709\u6b64\u63a5\u53e3\u8bbf\u95ee\u6743\u9650", (String)"ApiServiceType_6", (String)BOS_WEBACTIONS, (Object[])new Object[0]));
            return;
        }
        String appId = data.getString("appid");
        ApiServiceLogHelper.writeLog(appId, command, "AI");
        if (OpenApiUtils.checkHMApiforAi(command, ctx.getRequest().getMethod().toString())) {
            ctx.getResponse().fail(ResManager.loadKDString((String)"\u63a5\u53e3\u8c03\u7528\u201c\u8bf7\u6c42\u65b9\u5f0f\u201d\u4e0e\u8bbe\u7f6e\u7684\u4e0d\u5339\u914d\u3002", (String)"ApiServiceType_5", (String)BOS_WEBACTIONS, (Object[])new Object[0]));
            return;
        }
        Boolean checkAppIsTrue = (Boolean)DispatchServiceHelper.invokeBOSService((String)"ApiService", (String)"checkAppByAppNumber", (Object[])new Object[]{appId});
        Boolean checkUserIsTrue = (Boolean)DispatchServiceHelper.invokeBOSService((String)"ApiService", (String)"checkApiUserIsTrue", (Object[])new Object[]{command});
        if (!checkUserIsTrue.booleanValue()) {
            ctx.getResponse().fail(ResManager.loadKDString((String)"\u8be5\u7528\u6237\u6ca1\u6709\u6b64\u63a5\u53e3\u8bbf\u95ee\u6743\u9650", (String)"AIServiceType_0", (String)BOS_WEBACTIONS, (Object[])new Object[0]));
        } else if (StringUtils.isEmpty((CharSequence)appId)) {
            ctx.getResponse().fail(ResManager.loadKDString((String)"\u8bf7\u6c42\u6d88\u606f\u4e2d\uff0c\u5fc5\u987b\u5305\u542bappid\u7684\u53c2\u6570\uff0c\u800c\u4e14\u4e0d\u80fd\u4e3a\u7a7a", (String)"AIServiceType_1", (String)BOS_WEBACTIONS, (Object[])new Object[0]));
        } else if (!checkAppIsTrue.booleanValue()) {
            String errorinfo = String.format(ResManager.loadKDString((String)"\u8be5\u63a5\u53e3\u6240\u5728\u5e94\u7528%S\u5df2\u88ab\u7981\u6b62\u8bbf\u95ee", (String)"AIServiceType_2", (String)BOS_WEBACTIONS, (Object[])new Object[0]), appId);
            ctx.getResponse().fail(errorinfo);
        } else {
            long timeST = System.currentTimeMillis();
            try {
                IdempotencyUtil.doIdempotency((HttpServletRequest)ctx.getRequest().getRequest(), (OpenApiData)ctx.getOpenApiData(), () -> {
                    String ret = (String)DispatchServiceHelper.invokeBOSServiceByAppId((String)appId, (String)"OperationWebApi", (String)"executeAICommand", (Object[])new Object[]{json});
                    ApiServiceLogHelper.writeApiLogInfoApiResult(ret);
                    Map retmap = (Map)SerializationUtils.fromJsonString((String)ret, Map.class);
                    Boolean success = (Boolean)retmap.get("success");
                    if (success.booleanValue()) {
                        ctx.getResponse().success(retmap.get("data"), (String)retmap.get("errorCode"));
                    } else {
                        ctx.getResponse().fail(retmap.get("message") == null ? ResManager.loadKDString((String)"\u8c03\u7528AI\u547d\u4ee4\u5f02\u5e38", (String)"AIServiceType_3", (String)BOS_WEBACTIONS, (Object[])new Object[0]) : (String)retmap.get("message"), (String)retmap.get("errorCode"));
                    }
                    return null;
                });
            }
            catch (KDException e) {
                OpenApiExceptionUtils.dealThrowable(e, ctx);
            }
            catch (Exception ne) {
                String errorMessage = OpenApiExceptionUtils.getErrorMsg(ne);
                ctx.getResponse().fail(errorMessage);
            }
            finally {
                int timeCost = (int)(System.currentTimeMillis() - timeST);
                ApiServiceLogHelper.writeApiLog(ctx, OpenApiLocalCache.getOpenApiData(apiserviceId), timeCost);
            }
        }
    }

    private void checkClientIP() {
        OpenApiDataService openApiDataService = OpenApiDataServiceFactory.getOpenApiDataService();
        openApiDataService.checkClientIP();
    }

    public void meta(ServiceContext ctx) {
    }
}

