/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.web.api;

import java.util.HashMap;
import java.util.Map;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.kcf.ServiceContext;
import kd.bos.kcf.WebApiLog;
import kd.bos.kcf.message.KRequest;
import kd.bos.kcf.message.KResponse;
import kd.bos.log.api.AppLogInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.query.QueryResult;
import kd.bos.openapi.common.model.OpenApiData;
import kd.bos.openapi.common.model.OpenApiLogModel;
import kd.bos.openapi.common.model.OpenApiStatModel;
import kd.bos.openapi.common.spi.OpenApiDataServiceFactory;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.web.DispatchServiceHelper;
import kd.bos.web.api.OpenApiLocalCache;
import kd.bos.web.api.OpenApiUtils;

public class ApiServiceLogHelper {
    private static Log log = LogFactory.getLog(ApiServiceLogHelper.class);
    private static final String WEBAPI_LOGKEY = "WebApi_log";
    private static final String LOG_REGEX = "[\\t\\r\\n\\s]";

    public static void LogInfo(String info) {
        WebApiLog.reqContentWriteLog((String)info);
    }

    static boolean getApiLogInfoStatus() {
        return WebApiLog.getApiLogInfo().getResult() != null && WebApiLog.getApiLogInfo().getResult().get("success") != null && WebApiLog.getApiLogInfo().getResult().get("success").toString().equals("true");
    }

    public static void setApiLogInfoApiResult(Map<String, Object> result) {
        WebApiLog.getApiLogInfo().setResult(result);
    }

    static void writeLog(String appNumber, String opName, String desc) {
        String apiNeedOperationLog = "ApiNeedOperationLog";
        LocalMemoryCache localMemoryCache = OpenApiLocalCache.getLocalMemoryCache("ApiLogConfig", 600);
        String cacheValue = (String)localMemoryCache.get("ApiNeedOperationLog");
        if (StringUtil.isEmpty((String)cacheValue)) {
            Boolean isApiNeedOpLog = (Boolean)DispatchServiceHelper.invokeBOSService((String)"ApiService", (String)"getApiNeedOperationLog", (Object[])new Object[0]);
            cacheValue = isApiNeedOpLog.toString();
            localMemoryCache.put("ApiNeedOperationLog", (Object)cacheValue);
        }
        if ("true".equals(cacheValue)) {
            AppLogInfo logInfo = ApiServiceLogHelper.buildLogInfo(appNumber, opName, desc);
            DispatchServiceHelper.invokeBOSService((String)"ILogService", (String)"addLog", (Object[])new Object[]{logInfo});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeApiLog(ServiceContext ctx, OpenApiData openApiData, int timeCost) {
        try {
            KRequest req = ctx.getRequest();
            String reqUrl = OpenApiUtils.getApiUrl(req.getRequest());
            ApiServiceLogHelper.writeApiOperationLog(req, openApiData, timeCost, ctx.getResponse());
            ApiServiceLogHelper.writeApiStatLog(reqUrl, openApiData, timeCost);
        }
        catch (Throwable ex) {
            log.error("OpenApi-An error occurred while writing the ApiOperationLog:" + ex.getMessage(), ex);
        }
        finally {
            WebApiLog.reomveApiLogInfo();
        }
    }

    private static void writeApiOperationLog(KRequest req, OpenApiData openApiData, int timeCost, KResponse resp) {
        String reqUrl = OpenApiUtils.getApiUrl(req.getRequest());
        String apiLogLevel = OpenApiDataServiceFactory.getOpenApiDataService().getSysParameter("api_log_level", "summary");
        if ("none".equals(apiLogLevel)) {
            return;
        }
        OpenApiLogModel logModel = new OpenApiLogModel();
        logModel.setTimeCost(timeCost);
        logModel.setHttpStatus(Integer.valueOf(resp != null ? resp.getStatusCode() : 0));
        if (openApiData != null) {
            logModel.setUrl(openApiData.getUrl());
            logModel.setApiId(openApiData.getApiId());
            logModel.setCloudId(openApiData.getCloudId());
            logModel.setAppId(openApiData.getAppId());
            logModel.setApiNumber(openApiData.getApiNumber());
            logModel.setBizObject(openApiData.getBizObject());
            logModel.setApiName(openApiData.getApiName());
        }
        logModel.setStatus(ApiServiceLogHelper.getApiLogInfoStatus());
        if ("detail".equals(apiLogLevel) || "full".equals(apiLogLevel)) {
            try {
                HashMap<String, String> respMap = new HashMap<String, String>();
                String responsetext = WebApiLog.getApiLogInfo().getResptext();
                String respstr = "";
                if (responsetext != null) {
                    String resptemp = responsetext.replaceAll(LOG_REGEX, "");
                    respstr = resptemp.replaceFirst("Response", "");
                    Map oresp = (Map)SerializationUtils.fromJsonString((String)respstr, Map.class);
                    if (oresp.containsKey("message")) {
                        logModel.setErrMsg(oresp.get("message") == null ? null : oresp.remove("message").toString());
                        logModel.setErrorCode(oresp.get("errorCode") == null ? null : oresp.remove("errorCode").toString());
                    } else {
                        respMap.put("Response", "_resptagstr_");
                    }
                    respMap.put("Response", "_resptagstr_");
                }
                HashMap<String, Object> reqMap = new HashMap<String, Object>();
                reqMap.put("QueryString", req.getParameters());
                String reqtext = WebApiLog.getApiLogInfo().getReqtext();
                String reqstr = "";
                if (reqtext != null) {
                    String reqtemp = reqtext.replaceAll(LOG_REGEX, "");
                    reqstr = reqtemp.replaceFirst("Request", "");
                    reqMap.put("Request", "_reqtagstr_");
                }
                logModel.setRequest(reqtext == null ? SerializationUtils.toJsonString(reqMap) : SerializationUtils.toJsonString(reqMap).replace("\"_reqtagstr_\"", reqstr));
                logModel.setResponse(responsetext == null ? SerializationUtils.toJsonString(respMap) : SerializationUtils.toJsonString(respMap).replace("\"_resptagstr_\"", respstr));
            }
            catch (Exception e) {
                log.info("webapi_log_new setRequest or setResponse error");
            }
        }
        OpenApiDataServiceFactory.getOpenApiDataService().writeApiOperationLog(reqUrl, logModel);
    }

    private static void writeApiStatLog(String reqUrl, OpenApiData openApiData, int timeCost) {
        if (openApiData != null) {
            OpenApiStatModel statModel = new OpenApiStatModel(openApiData.getApiId(), openApiData.getApiNumber(), ApiServiceLogHelper.getApiLogInfoStatus(), timeCost);
            OpenApiDataServiceFactory.getOpenApiDataService().writeApiStatData(openApiData.getApiId(), statModel);
        }
    }

    static AppLogInfo buildLogInfo(String appNumber, String opName, String desc) {
        AppLogInfo logInfo = new AppLogInfo();
        logInfo.setUserID(Long.valueOf(RequestContext.get().getCurrUserId()));
        String bizAppid = BizAppServiceHelp.getAppIdByAppNumber((String)appNumber);
        if (bizAppid != null) {
            logInfo.setBizAppID(bizAppid);
        } else {
            desc = desc.concat("_bizAppid:").concat(appNumber != null ? appNumber : "");
        }
        logInfo.setOpTime(TimeServiceHelper.now());
        logInfo.setClientType(RequestContext.get().getClient());
        logInfo.setClientIP(RequestContext.get().getLoginIP());
        logInfo.setOpName(opName);
        logInfo.setOpDescription(desc);
        return logInfo;
    }

    static void writeLog(String msg) {
        log.info(WEBAPI_LOGKEY.concat(" ").concat(msg));
    }

    static void writeApiLogInfoApiResult(Object invokeResult) {
        try {
            if (!ObjectUtils.isEmpty((Object)invokeResult)) {
                if (invokeResult instanceof QueryResult) {
                    QueryResult queryResult = (QueryResult)invokeResult;
                    HashMap<String, Object> result = new HashMap<String, Object>();
                    result.put("success", queryResult.getSuccess());
                    ApiServiceLogHelper.setApiLogInfoApiResult(result);
                } else {
                    Map result = (Map)SerializationUtils.fromJsonString((String)((String)invokeResult), Map.class);
                    ApiServiceLogHelper.setApiLogInfoApiResult(result);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

