/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.web.api;

import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.constant.ApiServiceType;
import kd.bos.openapi.common.constant.HttpMethod;
import kd.bos.openapi.common.model.OpenApiData;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.web.api.OpenApiUtils;

public class OpenApiLocalCache {
    private static Log log = LogFactory.getLog(OpenApiLocalCache.class);
    private static final int CACHE_TIME_OUT = 1200;
    private static final int CACHE_MAX_ITEM_SIZE = 100000;
    private static final int CACHE_MAX_MEM_SIZE = 100;
    private static final String REGION = "OpenAPI";
    private static final String OPEN3RDAPPSAPITYPE = "Open3rdAppsApi";
    private static final String ALLOWGUESTTYPE = "AllowGuestApi";
    private static final String OPENAPISERVICE = "OpenApiService";
    private static final String OPEN3RDAPPSAPIFORMID = "open_3rdapps_new";
    private static final String ALLOWALLAPI = "allowallapi";
    private static final String LOGIN_API_SUPPORT_ANONYMOUS = "login_api_support_anonymous";

    private static LocalMemoryCache getLocalMemoryCache(String type) {
        return OpenApiLocalCache.getLocalMemoryCache(type, 1200);
    }

    static LocalMemoryCache getLocalMemoryCache(String type, int timeOutInSeconds) {
        CacheConfigInfo info = new CacheConfigInfo();
        info.setTimeout(timeOutInSeconds);
        info.setMaxItemSize(100000);
        info.setMaxMemSize(100);
        info.setTimeToLive(true);
        return CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(REGION.concat(RequestContext.get().getAccountId()), type, info);
    }

    public static boolean checkIsInCache(String key) {
        Object object = OpenApiLocalCache.getLocalMemoryCache(OPENAPISERVICE).get(key);
        return object != null;
    }

    public static Object getCacheByKey(String key) {
        return OpenApiLocalCache.getLocalMemoryCache(OPENAPISERVICE).get(key);
    }

    public static boolean setCacheByKey(String key, Object object) {
        boolean setSuccess = false;
        if (StringUtils.isNotEmpty((CharSequence)key) && null != object) {
            OpenApiLocalCache.getLocalMemoryCache(OPENAPISERVICE).remove(new String[]{key});
            OpenApiLocalCache.getLocalMemoryCache(OPENAPISERVICE).put(key, object);
            setSuccess = true;
        }
        return setSuccess;
    }

    protected static boolean open3rdappsApiCanUsed(String api3rdAppId, String apiserviceId) {
        if (apiserviceId == null) {
            return true;
        }
        if (api3rdAppId == null || api3rdAppId.isEmpty() || "null".equals(api3rdAppId)) {
            log.info(String.format("WebApi_log open3rdappsApiCanUsed_1 return true api3rdAppId:%s", api3rdAppId));
            return true;
        }
        if (OpenApiLocalCache.getLocalMemoryCache(ALLOWGUESTTYPE).get(LOGIN_API_SUPPORT_ANONYMOUS) == null) {
            String login_api_support_anonymous = System.getProperty(LOGIN_API_SUPPORT_ANONYMOUS);
            if (login_api_support_anonymous != null && "true".equals(login_api_support_anonymous)) {
                OpenApiLocalCache.getLocalMemoryCache(ALLOWGUESTTYPE).put(LOGIN_API_SUPPORT_ANONYMOUS, (Object)1);
                for (String allowGuestApi : OpenApiUtils.getAllowGuestApis()) {
                    OpenApiLocalCache.getLocalMemoryCache(ALLOWGUESTTYPE).put(allowGuestApi, (Object)1);
                }
            } else {
                OpenApiLocalCache.getLocalMemoryCache(ALLOWGUESTTYPE).put(LOGIN_API_SUPPORT_ANONYMOUS, (Object)0);
            }
        }
        if (OpenApiLocalCache.getLocalMemoryCache(ALLOWGUESTTYPE).get(LOGIN_API_SUPPORT_ANONYMOUS).equals(1) && OpenApiLocalCache.getLocalMemoryCache(ALLOWGUESTTYPE).get(apiserviceId) != null) {
            log.info(String.format("WebApi_log open3rdappsApiCanUsed_2 return true getLocalMemoryCache(%s).get(%s)", ALLOWGUESTTYPE, apiserviceId));
            return true;
        }
        if (apiserviceId == null || apiserviceId.isEmpty()) {
            log.info(String.format("WebApi_log open3rdappsApiCanUsed_3 return false api3rdAppId:%s apiserviceId:%s", api3rdAppId, apiserviceId));
            return false;
        }
        String key = api3rdAppId.concat(ALLOWALLAPI);
        if (OpenApiLocalCache.getLocalMemoryCache(OPEN3RDAPPSAPITYPE).get(key) == null) {
            DynamicObject open3rdapps = BusinessDataServiceHelper.loadSingle((Object)api3rdAppId, (String)OPEN3RDAPPSAPIFORMID);
            if (open3rdapps == null) {
                log.info(String.format("WebApi_log open3rdappsApiCanUsed_4 open3rdapps == null return false key:%s", key));
                return false;
            }
            boolean allowallapi = open3rdapps.getBoolean(ALLOWALLAPI);
            if (allowallapi) {
                OpenApiLocalCache.getLocalMemoryCache(OPEN3RDAPPSAPITYPE).put(key, (Object)1);
                log.info(String.format("WebApi_log open3rdappsApiCanUsed_5 setLocalMemoryCache allowallapi return true key:%s", key));
                return true;
            }
            OpenApiLocalCache.getLocalMemoryCache(OPEN3RDAPPSAPITYPE).put(key, (Object)0);
            DynamicObjectCollection apiserviceIds = open3rdapps.getDynamicObjectCollection("entryentity");
            for (DynamicObject obj : apiserviceIds) {
                String tempapiserviceId = obj.getString("apiservice.id");
                if (tempapiserviceId == null) continue;
                String tempKey = api3rdAppId.concat(tempapiserviceId);
                OpenApiLocalCache.getLocalMemoryCache(OPEN3RDAPPSAPITYPE).put(tempKey, (Object)1);
            }
            String currentkey = api3rdAppId.concat(apiserviceId);
            log.info(String.format("WebApi_log open3rdappsApiCanUsed_6 set_getLocalMemoryCache not allowallapi return getLocalMemoryCache currentkey:%s ", currentkey));
            return OpenApiLocalCache.getLocalMemoryCache(OPEN3RDAPPSAPITYPE).get(currentkey) != null && OpenApiLocalCache.getLocalMemoryCache(OPEN3RDAPPSAPITYPE).get(currentkey).equals(1);
        }
        if (OpenApiLocalCache.getLocalMemoryCache(OPEN3RDAPPSAPITYPE).get(key).equals(1)) {
            log.info(String.format("WebApi_log open3rdappsApiCanUsed_7 getLocalMemoryCache return true key:%s ", key));
            return true;
        }
        key = api3rdAppId.concat(apiserviceId);
        log.info(String.format("WebApi_log open3rdappsApiCanUsed_8 getLocalMemoryCache return getLocalMemoryCache key:%s ", key));
        return OpenApiLocalCache.getLocalMemoryCache(OPEN3RDAPPSAPITYPE).get(key) != null && OpenApiLocalCache.getLocalMemoryCache(OPEN3RDAPPSAPITYPE).get(key).equals(1);
    }

    static OpenApiData getOpenApiData(String apiId) {
        Object api;
        DynamicObject apiservice;
        if (StringUtil.isEmpty((String)apiId)) {
            return null;
        }
        if (OpenApiLocalCache.getLocalMemoryCache(OPENAPISERVICE).get(apiId) == null && (apiservice = BusinessDataServiceHelper.loadSingle((Object)apiId, (String)"open_apiservice_new")) != null) {
            DynamicObject bizcloud;
            OpenApiData apiData = new OpenApiData();
            apiData.setApiId(Long.parseLong(apiId));
            apiData.setApiNumber(apiservice.getString("number"));
            apiData.setApiName(apiservice.getString("name"));
            apiData.setApiNameML(apiservice.getLocaleString("name"));
            DynamicObject appid = apiservice.getDynamicObject("appid");
            if (appid != null) {
                apiData.setAppId(appid.getString("number"));
            }
            if ((bizcloud = apiservice.getDynamicObject("appid.bizcloud")) != null) {
                apiData.setCloudId(bizcloud.getString("number"));
            }
            apiData.setUrl(apiservice.getString("urlformat"));
            switch (apiservice.getInt("apiservicetype")) {
                case 0: {
                    apiData.setApiServiceType(ApiServiceType.OPERATION);
                }
                case 1: {
                    apiData.setApiServiceType(ApiServiceType.AI);
                }
                case 2: {
                    apiData.setApiServiceType(ApiServiceType.CUSTOM);
                }
            }
            switch (apiservice.getInt("httpmethod")) {
                case 0: {
                    apiData.setHttpMethod(HttpMethod.GET);
                }
                case 1: {
                    apiData.setHttpMethod(HttpMethod.POST);
                }
            }
            DynamicObject bizobject = apiservice.getDynamicObject("bizobject");
            if (bizobject != null) {
                apiData.setBizObject(bizobject.getString("number"));
            }
            OpenApiLocalCache.getLocalMemoryCache(OPENAPISERVICE).put(apiId, (Object)apiData);
        }
        return (api = OpenApiLocalCache.getLocalMemoryCache(OPENAPISERVICE).get(apiId)) != null ? (OpenApiData)api : null;
    }
}

