/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.web.api;

import java.util.HashSet;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.openapi.base.util.LocalCacheUtil;
import kd.bos.openapi.common.model.OpenApiData;
import kd.bos.openapi.common.spi.OpenApiDataService;
import kd.bos.openapi.common.spi.OpenApiDataServiceFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.web.api.OpenApiLocalCache;

public class OpenApiUtils {
    private static final String FORMID_APISERVICE_NEW = "open_apiservice_new";
    private static final String FORMID_APISERVICE = "open_apiservice";
    private static final String APISERVICETYPE = "apiservicetype";
    private static final String ENABLE = "enable";
    private static final String APISERVICEID = "id";
    private static final String VERSION = "version";
    private static final String APISERVICETYPE_OPERATION = "0";
    private static final String APISERVICETYPE_AI = "1";
    private static final String APISERVICETYPE_CUSTOM = "2";

    static boolean checkHMApiforOp(String formId, String operationKey, String httpmethod) {
        if (OpenApiUtils.verifyHttpmethodMatched()) {
            return false;
        }
        QFilter[] qFilters = OpenApiUtils.getFilterforOp(formId, operationKey);
        return OpenApiUtils.httpmethodMatch(httpmethod, qFilters);
    }

    private static boolean httpmethodMatch(String httpmethod, QFilter[] qFilters) {
        return OpenApiUtils.httpmethodMatch(FORMID_APISERVICE_NEW, httpmethod, qFilters);
    }

    private static boolean httpmethodMatch(String formId, String httpmethod, QFilter[] qFilters) {
        DynamicObjectCollection apis = OpenApiUtils.getApis(formId, "httpmethod", qFilters);
        if (!apis.isEmpty()) {
            String httpMethodapiSet = ((DynamicObject)apis.get(0)).getString("httpmethod");
            return !httpmethod.equals(httpMethodapiSet.equals(APISERVICETYPE_OPERATION) ? "Get" : "Post");
        }
        return false;
    }

    private static DynamicObjectCollection getApis(String selectFields, QFilter[] qFilters) {
        return OpenApiUtils.getApis(FORMID_APISERVICE, selectFields, qFilters);
    }

    private static DynamicObjectCollection getApis(String formId, String selectFields, QFilter[] qFilters) {
        return QueryServiceHelper.query((String)formId, (String)selectFields, (QFilter[])qFilters);
    }

    static boolean checkHMApiforCus(String number, String httpmethod) {
        if (OpenApiUtils.verifyHttpmethodMatched()) {
            return false;
        }
        QFilter[] qFilters = OpenApiUtils.getFilterforCus(number);
        return OpenApiUtils.httpmethodMatch(httpmethod, qFilters);
    }

    static boolean checkHMApiforAi(String command, String httpmethod) {
        if (OpenApiUtils.verifyHttpmethodMatched()) {
            return false;
        }
        QFilter[] qFilters = OpenApiUtils.getFilterforAi(command);
        return OpenApiUtils.httpmethodMatch(FORMID_APISERVICE, httpmethod, qFilters);
    }

    static Set<String> getAllowGuestApis() {
        QFilter[] qFilters = new QFilter[]{new QFilter("allowguest", "=", (Object)Boolean.TRUE), new QFilter(ENABLE, "=", (Object)Boolean.TRUE)};
        DynamicObjectCollection allowGuestApis = OpenApiUtils.getApis(APISERVICEID, qFilters);
        HashSet<String> apis = new HashSet<String>();
        for (DynamicObject obj : allowGuestApis) {
            String url = obj.getString(APISERVICEID);
            apis.add(url);
        }
        return apis;
    }

    private static QFilter[] getFilterforOp(String formId, String operationKey) {
        QFilter[] qFilters = new QFilter[]{new QFilter("bizobject", "=", (Object)formId), new QFilter("operation", "=", (Object)operationKey), new QFilter(APISERVICETYPE, "=", (Object)APISERVICETYPE_OPERATION), new QFilter(ENABLE, "=", (Object)Boolean.TRUE), new QFilter(VERSION, "!=", (Object)APISERVICETYPE_CUSTOM)};
        return qFilters;
    }

    private static QFilter[] getFilterforCus(String number) {
        QFilter[] qFilters = new QFilter[]{new QFilter("number", "=", (Object)number), new QFilter(APISERVICETYPE, "=", (Object)APISERVICETYPE_CUSTOM), new QFilter(ENABLE, "=", (Object)Boolean.TRUE), new QFilter(VERSION, "!=", (Object)APISERVICETYPE_CUSTOM)};
        return qFilters;
    }

    private static QFilter[] getFilterforAi(String command) {
        QFilter[] qFilters = new QFilter[]{new QFilter("aicommand.ainumber", "=", (Object)command), new QFilter(APISERVICETYPE, "=", (Object)APISERVICETYPE_AI), new QFilter(ENABLE, "=", (Object)Boolean.TRUE)};
        return qFilters;
    }

    static String getApiserviceIdforOp(String formId, String operationKey) {
        String cacheKey = formId.concat("-" + operationKey);
        String apiserviceIdCached = OpenApiUtils.getApiserviceIdFromCache(cacheKey);
        if (apiserviceIdCached != null) {
            return apiserviceIdCached;
        }
        QFilter[] qFilters = OpenApiUtils.getFilterforOp(formId, operationKey);
        String apiserviceId = OpenApiUtils.getApiserviceId(FORMID_APISERVICE_NEW, qFilters);
        OpenApiUtils.setApiserviceIdToCache(cacheKey, apiserviceId);
        return apiserviceId;
    }

    static String getApiserviceIdforCus(String number) {
        String apiserviceIdCacheed = OpenApiUtils.getApiserviceIdFromCache(number);
        if (apiserviceIdCacheed != null) {
            return apiserviceIdCacheed;
        }
        QFilter[] qFilters = OpenApiUtils.getFilterforCus(number);
        String apiserviceId = OpenApiUtils.getApiserviceId(qFilters);
        OpenApiUtils.setApiserviceIdToCache(number, apiserviceId);
        return apiserviceId;
    }

    static String getApiserviceIdforAi(String command) {
        String apiserviceIdCacheed = OpenApiUtils.getApiserviceIdFromCache(command);
        if (apiserviceIdCacheed != null) {
            return apiserviceIdCacheed;
        }
        QFilter[] qFilters = OpenApiUtils.getFilterforAi(command);
        String apiserviceId = OpenApiUtils.getApiserviceId(FORMID_APISERVICE, qFilters);
        OpenApiUtils.setApiserviceIdToCache(command, apiserviceId);
        return apiserviceId;
    }

    static String getApiserviceIdFromCache(String cacheKey) {
        Object cacheObj = LocalCacheUtil.getCacheByKey((String)"apiserviceId", (String)OpenApiUtils.getCacheKey(cacheKey));
        return cacheObj == null ? null : cacheObj.toString();
    }

    static void setApiserviceIdToCache(String cacheKey, String apiserviceId) {
        if (apiserviceId == null) {
            return;
        }
        LocalCacheUtil.setCacheByKey((String)"apiserviceId", (String)OpenApiUtils.getCacheKey(cacheKey), (Object)apiserviceId);
    }

    private static String getCacheKey(String cacheKey) {
        return "apiserviceId-" + cacheKey;
    }

    private static String getApiserviceId(QFilter[] qFilters) {
        return OpenApiUtils.getApiserviceId(FORMID_APISERVICE_NEW, qFilters);
    }

    private static String getApiserviceId(String formId, QFilter[] qFilters) {
        DynamicObjectCollection apis = OpenApiUtils.getApis(formId, APISERVICEID, qFilters);
        if (!apis.isEmpty()) {
            return ((DynamicObject)apis.get(0)).getString(APISERVICEID);
        }
        return null;
    }

    private static boolean verifyHttpmethodMatched() {
        return !"true".equals(System.getProperty("api.httpmethod.match", "false"));
    }

    static void checkACL(String apiserviceId) {
        OpenApiData openApiData = OpenApiLocalCache.getOpenApiData(apiserviceId);
        if (openApiData != null) {
            String url = openApiData.getUrl();
            OpenApiDataService openApiDataService = OpenApiDataServiceFactory.getOpenApiDataService();
            openApiDataService.checkThirdACL(url);
        }
    }

    static String getApiUrl(HttpServletRequest req) {
        String contextPath = req.getContextPath() + "/kapi";
        String requestURI = req.getRequestURI();
        String url = requestURI.substring(contextPath.length());
        return url;
    }
}

