/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.servicehelper;

import java.text.MessageFormat;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.api.params.ApiParam;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.ApiServiceType;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.model.OpenApiData;
import kd.bos.openapi.common.spi.OpenApiDataServiceFactory;
import kd.bos.openapi.common.util.McConfigUtil;
import kd.bos.service.lookup.ServiceLookup;
import kd.bos.servicehelper.DispatchServiceHelper;

public class DispatchApiServiceHelper {
    private static Log log = LogFactory.getLog(DispatchApiServiceHelper.class);
    public static final String APP_ID = "api";
    public static final String FACTORY_QUALIFIED_PREFIX = "kd.bos.openapi.servicehelper";
    public static final String EXECUTE = "execute";
    private static final String CUSTAPI = "custapi";
    private static final String AIAPI = "aiapi";
    private static final String SCRIPT_API = "scriptapi";
    private static final String APP_BOS = "bos";
    private static final String SPLITTAG = ".";

    public static <T> T invokeApiService(String serviceName, Object ... params) {
        return DispatchApiServiceHelper.invokeApiService(serviceName, EXECUTE, params);
    }

    public static <T> T invokeApiService(String serviceName, String methodName, Object ... params) {
        return DispatchApiServiceHelper.invokeApiService(APP_ID, serviceName, methodName, params);
    }

    public static <T> T invokeApiService(String appId, String serviceName, String methodName, Object ... params) {
        return DispatchApiServiceHelper.invokeApiService(FACTORY_QUALIFIED_PREFIX, appId, serviceName, methodName, params);
    }

    public static <T> T invokeApiService(String factoryQualifiedPrefix, String appId, String serviceName, String methodName, Object ... params) {
        OpenApiData api;
        String url;
        String API_STR = APP_ID;
        String currentAppId = appId;
        String serviceOpId = "";
        if (params != null && params.length > 0 && params[0] instanceof ApiParam && !StringUtils.isEmpty((CharSequence)(url = ((ApiParam)params[0]).getRequest().getServiceApiData().getUrl())) && (api = OpenApiDataServiceFactory.getOpenApiDataService().getOpenApiData(url)) != null) {
            String strappId = api.getAppId();
            if (!StringUtils.isEmpty((CharSequence)strappId)) {
                currentAppId = strappId;
            }
            if (ApiServiceType.OPERATION == api.getApiServiceType()) {
                String formId;
                serviceOpId = formId = api.getBizObject();
            } else if (api.getApiServiceType() == ApiServiceType.CUSTOM) {
                serviceOpId = CUSTAPI;
            } else if (api.getApiServiceType() == ApiServiceType.AI) {
                serviceOpId = AIAPI;
            } else if (ApiServiceType.SCRIPT == api.getApiServiceType()) {
                serviceOpId = SCRIPT_API;
            } else {
                throw new OpenApiException(ApiErrorCode.Data_Invalid, String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u670d\u52a1\u7c7b\u578b\uff1a%s", (String)"DispatchApiServiceHelper_0", (String)"bos-open-service", (Object[])new Object[0]), api.getApiServiceType()), new Object[0]);
            }
        }
        String currentAppApiStr = currentAppId + "-api";
        String invokeAppId = APP_BOS.concat(SPLITTAG).concat(currentAppId).concat(SPLITTAG).concat(API_STR).concat(SPLITTAG).concat(currentAppApiStr).concat(SPLITTAG).concat(serviceOpId);
        String serviceAppId = ServiceLookup.getServiceAppId((String)invokeAppId);
        if (McConfigUtil.needWriteLogDetail()) {
            log.info(MessageFormat.format("{0} ServiceLookup invokeAppId {1},serviceAppId {2}", "WebApi_log", invokeAppId, serviceAppId));
        }
        return (T)DispatchServiceHelper.invokeService((String)factoryQualifiedPrefix, (String)serviceAppId, (String)serviceName, (String)methodName, (Object[])params);
    }

    public static <T> T invokeService(String appId, String serviceName, String methodName, Object ... params) {
        return (T)DispatchServiceHelper.invokeService((String)FACTORY_QUALIFIED_PREFIX, (String)appId, (String)serviceName, (String)methodName, (Object[])params);
    }
}

