/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.common.constant;

import kd.bos.openapi.api.plugin.ApiAppendEntryRowsPlugin;
import kd.bos.openapi.api.plugin.ApiAuditPlugin;
import kd.bos.openapi.api.plugin.ApiCommonPlugin;
import kd.bos.openapi.api.plugin.ApiDeleteEntryRowsPlugin;
import kd.bos.openapi.api.plugin.ApiDeletePlugin;
import kd.bos.openapi.api.plugin.ApiDisablePlugin;
import kd.bos.openapi.api.plugin.ApiEnablePlugin;
import kd.bos.openapi.api.plugin.ApiQueryPlugin;
import kd.bos.openapi.api.plugin.ApiSavePlugin;
import kd.bos.openapi.api.plugin.ApiSubmitPlugin;
import kd.bos.openapi.api.plugin.ApiUnAuditPlugin;
import kd.bos.openapi.api.plugin.ApiUnSubmitPlugin;
import kd.bos.openapi.api.plugin.upper.ApiPlugin;
import kd.bos.openapi.common.constant.MultiLangEnumBridge;
import kd.bos.openapi.common.util.StringUtil;

public enum ApiOperationType {
    QUERY{

        @Override
        public String getName() {
            return new MultiLangEnumBridge("\u67e5\u8be2", "ApiOperationType_0", "bos-open-common").loadKDString();
        }

        @Override
        public boolean hasCondition() {
            return true;
        }

        @Override
        public Class<? extends ApiPlugin> getPluginClass() {
            return ApiQueryPlugin.class;
        }
    }
    ,
    SAVE{

        @Override
        public String getName() {
            return new MultiLangEnumBridge("\u4fdd\u5b58", "ApiOperationType_1", "bos-open-common").loadKDString();
        }

        @Override
        public boolean isReqBatch() {
            return true;
        }

        @Override
        public Class<? extends ApiPlugin> getPluginClass() {
            return ApiSavePlugin.class;
        }
    }
    ,
    DELETE{

        @Override
        public String getName() {
            return new MultiLangEnumBridge("\u5220\u9664", "ApiOperationType_2", "bos-open-common").loadKDString();
        }

        @Override
        public boolean hasCondition() {
            return true;
        }

        @Override
        public Class<? extends ApiPlugin> getPluginClass() {
            return ApiDeletePlugin.class;
        }
    }
    ,
    APPENDENTRYROWS{

        @Override
        public String getName() {
            return new MultiLangEnumBridge("\u8ffd\u52a0\u5206\u5f55", "ApiOperationType_3", "bos-open-common").loadKDString();
        }

        @Override
        public boolean isReqBatch() {
            return true;
        }

        @Override
        public Class<? extends ApiPlugin> getPluginClass() {
            return ApiAppendEntryRowsPlugin.class;
        }
    }
    ,
    DELETEENTRYROWS{

        @Override
        public String getName() {
            return new MultiLangEnumBridge("\u5220\u9664\u5206\u5f55", "ApiOperationType_4", "bos-open-common").loadKDString();
        }

        @Override
        public boolean isReqBatch() {
            return true;
        }

        @Override
        public Class<? extends ApiPlugin> getPluginClass() {
            return ApiDeleteEntryRowsPlugin.class;
        }
    }
    ,
    SUBMIT{

        @Override
        public String getName() {
            return new MultiLangEnumBridge("\u63d0\u4ea4", "ApiOperationType_5", "bos-open-common").loadKDString();
        }

        @Override
        public boolean hasCondition() {
            return true;
        }

        @Override
        public Class<? extends ApiPlugin> getPluginClass() {
            return ApiSubmitPlugin.class;
        }
    }
    ,
    UNSUBMIT{

        @Override
        public String getName() {
            return new MultiLangEnumBridge("\u64a4\u9500", "ApiOperationType_6", "bos-open-common").loadKDString();
        }

        @Override
        public boolean hasCondition() {
            return true;
        }

        @Override
        public Class<? extends ApiPlugin> getPluginClass() {
            return ApiUnSubmitPlugin.class;
        }
    }
    ,
    AUDIT{

        @Override
        public String getName() {
            return new MultiLangEnumBridge("\u5ba1\u6838", "ApiOperationType_7", "bos-open-common").loadKDString();
        }

        @Override
        public boolean hasCondition() {
            return true;
        }

        @Override
        public Class<? extends ApiPlugin> getPluginClass() {
            return ApiAuditPlugin.class;
        }
    }
    ,
    UNAUDIT{

        @Override
        public String getName() {
            return new MultiLangEnumBridge("\u53cd\u5ba1\u6838", "ApiOperationType_8", "bos-open-common").loadKDString();
        }

        @Override
        public boolean hasCondition() {
            return true;
        }

        @Override
        public Class<? extends ApiPlugin> getPluginClass() {
            return ApiUnAuditPlugin.class;
        }
    }
    ,
    ENABLE{

        @Override
        public String getName() {
            return new MultiLangEnumBridge("\u542f\u7528", "ApiOperationType_9", "bos-open-common").loadKDString();
        }

        @Override
        public boolean hasCondition() {
            return true;
        }

        @Override
        public Class<? extends ApiPlugin> getPluginClass() {
            return ApiEnablePlugin.class;
        }
    }
    ,
    DISABLE{

        @Override
        public String getName() {
            return new MultiLangEnumBridge("\u7981\u7528", "ApiOperationType_10", "bos-open-common").loadKDString();
        }

        @Override
        public boolean hasCondition() {
            return true;
        }

        @Override
        public Class<? extends ApiPlugin> getPluginClass() {
            return ApiDisablePlugin.class;
        }
    }
    ,
    $_COMMON_OP{

        @Override
        public String getOp() {
            return "";
        }

        @Override
        public String getName() {
            return "";
        }

        @Override
        public boolean hasCondition() {
            return true;
        }

        @Override
        public Class<? extends ApiPlugin> getPluginClass() {
            return ApiCommonPlugin.class;
        }
    };


    public String getOp() {
        return this.name().toLowerCase();
    }

    public abstract String getName();

    public boolean isReqBatch() {
        return false;
    }

    public boolean hasCondition() {
        return false;
    }

    public static ApiOperationType getTypeByOp(String op) {
        if (StringUtil.isEmpty(op)) {
            throw new NullPointerException("operator not null");
        }
        for (ApiOperationType type : ApiOperationType.values()) {
            if (!type.getOp().equalsIgnoreCase(op)) continue;
            return type;
        }
        return $_COMMON_OP;
    }

    public abstract Class<? extends ApiPlugin> getPluginClass();
}

