/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.common.constant;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.DataUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.sdk.annotation.SdkInternal;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.RandomUtils;

@SdkInternal
public enum DataType {
    STRING("string"){

        @Override
        public String type() {
            return "String";
        }

        @Override
        public Object defaultValue() {
            return DataType.getRandom(String.class);
        }

        @Override
        public Object validator(Object value) {
            return DataUtil.s2(value);
        }
    }
    ,
    DATE("date"){

        @Override
        public String type() {
            return "Date";
        }

        @Override
        public Object defaultValue() {
            return DataType.getRandom(LocalDate.class);
        }

        @Override
        public Object validator(Object value) {
            DataType.checkNumStr(value);
            return DataUtil.toTimestamp(DataUtil.localDate(DataUtil.s(value)));
        }
    }
    ,
    DATE_TIME("dateTime"){

        @Override
        public String type() {
            return "DateTime";
        }

        @Override
        public Object defaultValue() {
            return DataType.getRandom(Date.class);
        }

        @Override
        public Object validator(Object value) {
            DataType.checkNumStr(value);
            return DataUtil.toTimestamp(DataUtil.localDateTime(DataUtil.s(value)));
        }
    }
    ,
    LONG("long"){

        @Override
        public String type() {
            return "Long";
        }

        @Override
        public Object defaultValue() {
            return DataType.getRandom(Long.class);
        }

        @Override
        public Object validator(Object value) {
            if (value == null) {
                return null;
            }
            DataType.checkNumStr(value);
            return DataUtil.l(value);
        }
    }
    ,
    INTEGER("integer"){

        @Override
        public String type() {
            return "Integer";
        }

        @Override
        public Object defaultValue() {
            return DataType.getRandom(Integer.class);
        }

        @Override
        public Object validator(Object value) {
            if (value == null) {
                return null;
            }
            DataType.checkNumStr(value);
            return DataUtil.i(value);
        }
    }
    ,
    BOOLEAN("boolean"){

        @Override
        public String type() {
            return "Boolean";
        }

        @Override
        public Object defaultValue() {
            return Boolean.FALSE;
        }

        @Override
        public Object validator(Object value) {
            if (value == null) {
                return null;
            }
            DataType.checkNumStr(value);
            return DataUtil.x(value);
        }
    }
    ,
    DECIMAL("decimal"){

        @Override
        public String type() {
            return "Decimal";
        }

        @Override
        public Object defaultValue() {
            return DataType.getRandom(BigDecimal.class);
        }

        @Override
        public Object validator(Object value) {
            if (value == null) {
                return null;
            }
            DataType.checkNumStr(value);
            return DataUtil.n(value);
        }
    }
    ,
    ARRAY_INTEGER("integer"){

        @Override
        public String type() {
            return "Array<Integer>";
        }

        @Override
        public Object defaultValue() {
            return Arrays.asList(DataType.getRandom(Integer.class), DataType.getRandom(Integer.class));
        }

        @Override
        public Object validator(Object value) {
            if (value == null) {
                return null;
            }
            Collection list = DataType.getList(value, true);
            return list.stream().map(INTEGER::validator).collect(Collectors.toList());
        }
    }
    ,
    ARRAY_STRING("string"){

        @Override
        public String type() {
            return "Array<String>";
        }

        @Override
        public Object defaultValue() {
            return Arrays.asList(DataType.getRandom(String.class), DataType.getRandom(String.class));
        }

        @Override
        public Object validator(Object value) {
            if (value == null) {
                return null;
            }
            Collection list = DataType.getList(value, true);
            return list.stream().map(STRING::validator).collect(Collectors.toList());
        }
    }
    ,
    ARRAY_LONG("long"){

        @Override
        public String type() {
            return "Array<Long>";
        }

        @Override
        public Object defaultValue() {
            return Arrays.asList(DataType.getRandom(Long.class), DataType.getRandom(Long.class));
        }

        @Override
        public Object validator(Object value) {
            if (value == null) {
                return null;
            }
            Collection list = DataType.getList(value, true);
            return list.stream().map(LONG::validator).collect(Collectors.toList());
        }
    }
    ,
    ARRAY_DATE("date"){

        @Override
        public String type() {
            return "Array<Date>";
        }

        @Override
        public Object defaultValue() {
            return Collections.singletonList(DataType.getRandom(LocalDate.class));
        }

        @Override
        public Object validator(Object value) {
            if (value == null) {
                return null;
            }
            Collection list = DataType.getList(value, true);
            return list.stream().map(DATE::validator).collect(Collectors.toList());
        }
    }
    ,
    FLEX("flex"){

        @Override
        public String type() {
            return "Flex";
        }

        @Override
        public Object defaultValue() {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>(3);
            map.put("id", LONG.defaultValue());
            map.put("number", STRING.defaultValue());
            map.put("name", STRING.defaultValue());
            LinkedHashMap<String, Object> mapValue = new LinkedHashMap<String, Object>(4);
            mapValue.put("id", LONG.defaultValue());
            mapValue.put(ResManager.loadKDString((String)"\u5f39\u6027\u57df\u540d\u79f0-\u57fa\u7840\u8d44\u6599\u7c7b\u578b", (String)"DataType_0", (String)"bos-open-common", (Object[])new Object[0]), map);
            mapValue.put(ResManager.loadKDString((String)"\u5f39\u6027\u57df\u540d\u79f0-\u8f85\u52a9\u8d44\u6599\u7c7b\u578b", (String)"DataType_1", (String)"bos-open-common", (Object[])new Object[0]), map);
            mapValue.put(ResManager.loadKDString((String)"\u5f39\u6027\u57df\u540d\u79f0-\u5176\u4ed6\u7c7b\u578b", (String)"DataType_2", (String)"bos-open-common", (Object[])new Object[0]), STRING.defaultValue());
            return mapValue;
        }

        @Override
        public Object validator(Object value) {
            if (value == null) {
                return null;
            }
            if (JSON.toJSON((Object)value) instanceof Map) {
                return value;
            }
            throw new OpenApiException(ApiErrorCode.HTTP_BAD_REQUEST, ResManager.loadKDString((String)"%s \u4e0d\u662fFlex\u7ed3\u6784\u6570\u636e\u3002", (String)"DataType_7", (String)"bos-open-common", (Object[])new Object[0]), value.getClass().getSimpleName());
        }
    }
    ,
    ENTRIES("entries"){

        @Override
        public String type() {
            return "Entries";
        }

        @Override
        public Object defaultValue() {
            return Arrays.asList(DataType.getRandom(Object.class), DataType.getRandom(Object.class));
        }

        @Override
        public Object validator(Object value) {
            if (value == null) {
                return null;
            }
            return DataType.getList(value, false);
        }
    }
    ,
    STRUCT("struct"){

        @Override
        public String type() {
            return "Struct";
        }

        @Override
        public Object defaultValue() {
            return "-";
        }

        @Override
        public Object validator(Object value) {
            if (value == null || "-".equals(value)) {
                return value;
            }
            Object obj = JSON.toJSON((Object)value);
            if (obj instanceof JSONObject) {
                return obj;
            }
            throw new OpenApiException(ApiErrorCode.HTTP_BAD_REQUEST, ResManager.loadKDString((String)"%s \u4e0d\u662f\u7ed3\u6784\u6570\u636e\u3002", (String)"DataType_3", (String)"bos-open-common", (Object[])new Object[0]), value.getClass().getSimpleName());
        }
    }
    ,
    BYTE("byte"){

        @Override
        public String type() {
            return Byte.class.getSimpleName();
        }

        @Override
        public Object defaultValue() {
            return DataType.getRandom(Byte.class);
        }

        @Override
        public Object validator(Object value) {
            if (value == null) {
                return null;
            }
            DataType.checkNumStr(value);
            return DataUtil.b(value);
        }
    }
    ,
    ANY("anyType"){

        @Override
        public String type() {
            return "Any";
        }

        @Override
        public Object defaultValue() {
            return null;
        }

        @Override
        public Object validator(Object value) {
            return value;
        }
    };

    private String xmlType;

    private static void checkNumStr(Object value) {
        if (value instanceof String && StringUtil.isEmpty((String)value)) {
            throw new NumberFormatException();
        }
    }

    private DataType(String xmlType) {
        this.xmlType = xmlType;
    }

    public String getXmlType() {
        return this.xmlType;
    }

    public static boolean isArray(String type) {
        EnumSet<DataType> enumSet = EnumSet.of(ARRAY_DATE, ARRAY_INTEGER, ARRAY_LONG, ARRAY_STRING);
        boolean isArray = false;
        for (DataType dataType : enumSet) {
            if (!dataType.type().equalsIgnoreCase(type)) continue;
            isArray = true;
            break;
        }
        return isArray;
    }

    public static EnumSet<DataType> getServiceDataType() {
        EnumSet<DataType> enumSet = EnumSet.allOf(DataType.class);
        enumSet.remove((Object)STRUCT);
        enumSet.remove((Object)BYTE);
        enumSet.remove((Object)ANY);
        return enumSet;
    }

    public static EnumSet<DataType> getCustomDataType() {
        EnumSet<DataType> enumSet = EnumSet.allOf(DataType.class);
        enumSet.remove((Object)FLEX);
        enumSet.remove((Object)ENTRIES);
        enumSet.remove((Object)ARRAY_DATE);
        enumSet.remove((Object)ARRAY_STRING);
        enumSet.remove((Object)ARRAY_INTEGER);
        enumSet.remove((Object)ARRAY_LONG);
        return enumSet;
    }

    public static EnumSet<DataType> getScriptDataType() {
        EnumSet<DataType> enumSet = EnumSet.allOf(DataType.class);
        enumSet.remove((Object)FLEX);
        enumSet.remove((Object)ENTRIES);
        enumSet.remove((Object)ARRAY_DATE);
        enumSet.remove((Object)ARRAY_STRING);
        enumSet.remove((Object)ARRAY_INTEGER);
        enumSet.remove((Object)ARRAY_LONG);
        return enumSet;
    }

    private static Collection<?> getList(Object value, boolean isArray) {
        if (value == null) {
            return Collections.emptyList();
        }
        List<Object> list = value instanceof Collection ? (List<Object>)value : (value instanceof Object[] ? Arrays.asList((Object[])value) : Collections.singletonList(value));
        if (CollectionUtil.isEmpty(list)) {
            return list;
        }
        Optional first = list.stream().findFirst();
        Object obj = first.orElse(null);
        if (isArray && obj instanceof Map) {
            throw new OpenApiException(ApiErrorCode.HTTP_BAD_REQUEST, ResManager.loadKDString((String)"\u53c2\u6570\u7c7b\u578b\u4e0d\u6b63\u786e\u3002", (String)"DataType_4", (String)"bos-open-common", (Object[])new Object[0]), new Object[0]);
        }
        if (!isArray && !(obj instanceof Map)) {
            throw new OpenApiException(ApiErrorCode.HTTP_BAD_REQUEST, ResManager.loadKDString((String)"\u53c2\u6570\u7c7b\u578b\u4e0d\u6b63\u786e\u3002", (String)"DataType_4", (String)"bos-open-common", (Object[])new Object[0]), new Object[0]);
        }
        return list;
    }

    public abstract String type();

    public abstract Object defaultValue();

    public String defaultStringValue() {
        Object obj = this.defaultValue();
        if ("-".equals(DataUtil.s(obj))) {
            return "-";
        }
        return JSON.toJSONString((Object)obj);
    }

    public abstract Object validator(Object var1);

    public static Object getDefaultValue(String type) {
        return DataType.getByType(type).defaultValue();
    }

    public static DataType getByType(String type) {
        if (StringUtils.isBlank((String)type)) {
            throw new OpenApiException(ApiErrorCode.HTTP_BAD_REQUEST, ResManager.loadKDString((String)"\u53c2\u6570\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DataType_5", (String)"bos-open-common", (Object[])new Object[0]), new Object[0]);
        }
        for (DataType dataType : DataType.values()) {
            if (!dataType.type().equals(type)) continue;
            return dataType;
        }
        throw new OpenApiException(ApiErrorCode.HTTP_BAD_REQUEST, ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u53c2\u6570\u7c7b\u578b %s\u3002", (String)"DataType_6", (String)"bos-open-common", (Object[])new Object[0]), type);
    }

    private static Object getRandom(Class<?> clazz) {
        if (Integer.class == clazz) {
            return RandomUtils.nextInt((int)0, (int)100);
        }
        if (Long.class == clazz) {
            return BigInteger.valueOf(RandomUtils.nextLong()).toString();
        }
        if (BigDecimal.class == clazz) {
            return BigDecimal.valueOf(RandomUtils.nextDouble((double)0.0, (double)1000.0)).setScale(2, RoundingMode.DOWN).toString();
        }
        if (Boolean.class == clazz) {
            return RandomUtils.nextBoolean();
        }
        if (LocalDate.class == clazz) {
            return LocalDate.now(ZoneId.systemDefault());
        }
        if (Date.class == clazz) {
            return LocalDateTime.now(ZoneId.systemDefault());
        }
        if (String.class == clazz) {
            return RandomStringUtils.randomAlphanumeric((int)5);
        }
        if (Object.class == clazz) {
            return new Object();
        }
        if (Map.class == clazz) {
            return Collections.emptyMap();
        }
        if (Byte.class == clazz) {
            return (byte)RandomUtils.nextInt((int)1, (int)127);
        }
        return null;
    }
}

