/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.common.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.openapi.common.graph.EndpointPair;

public class DirectedGraph<N> {
    private final boolean allowsSelfLoops;
    private final Set<N> nodes;
    private final Map<N, List<N>> successors;
    private final Set<EndpointPair<N>> edges;
    private final List<List<N>> links;
    private final Map<List<N>, N> cycles;

    private DirectedGraph(boolean allowsSelfLoops, Set<N> nodes, Map<N, List<N>> successors, Set<EndpointPair<N>> edges, List<List<N>> links, Map<List<N>, N> cycles) {
        this.allowsSelfLoops = allowsSelfLoops;
        this.nodes = nodes;
        this.successors = successors;
        this.edges = edges;
        this.links = links;
        this.cycles = cycles;
    }

    public static <N> GraphBuilder<N> builder(boolean allowsSelfLoops) {
        return new GraphBuilder(allowsSelfLoops);
    }

    public boolean isAllowsSelfLoops() {
        return this.allowsSelfLoops;
    }

    public Set<N> getNodes() {
        return this.nodes;
    }

    public Map<N, List<N>> getSuccessors() {
        return this.successors;
    }

    public Set<EndpointPair<N>> getEdges() {
        return this.edges;
    }

    public List<List<N>> getLinks() {
        return this.links;
    }

    public Map<List<N>, N> getCycles() {
        return this.cycles;
    }

    public boolean hasCycle() {
        return !this.getCycles().isEmpty();
    }

    public static class GraphBuilder<N> {
        private final boolean allowsSelfLoops;
        private final Set<N> nodes = new LinkedHashSet<N>(16);
        private final Map<N, LinkedList<N>> successors = new LinkedHashMap<N, LinkedList<N>>(16);
        private final Set<EndpointPair<N>> edges = new LinkedHashSet<EndpointPair<N>>(16);
        private List<List<N>> links = new ArrayList<List<N>>(16);

        private GraphBuilder(boolean allowsSelfLoops) {
            this.allowsSelfLoops = allowsSelfLoops;
        }

        public void putEdge(N fromNode, N toNode) {
            Objects.requireNonNull(fromNode, "graph node cannot be null");
            Objects.requireNonNull(toNode, "graph node cannot be null");
            if (!this.allowsSelfLoops && Objects.equals(fromNode, toNode)) {
                throw new UnsupportedOperationException("graph not allow self loop");
            }
            EndpointPair<N> endpointPair = new EndpointPair<N>(fromNode, toNode);
            if (this.edges.contains(endpointPair)) {
                return;
            }
            Deque adjacencyDeque = this.successors.computeIfAbsent(fromNode, k -> new LinkedList());
            adjacencyDeque.addLast(toNode);
            this.nodes.add(fromNode);
            this.nodes.add(toNode);
            this.edges.add(endpointPair);
        }

        public List<List<N>> links() {
            if (this.nodes.isEmpty()) {
                return Collections.emptyList();
            }
            ArrayList<List<N>> links = new ArrayList<List<N>>(16);
            for (N node : this.nodes) {
                boolean isAdd;
                LinkedList<N> link = new LinkedList<N>();
                link.add(node);
                Deque deque = this.successors.get(node);
                if (deque == null || deque.isEmpty() || !(isAdd = this.cycleLinks(deque, link, links))) continue;
                this.checkRepeatLinkAndAdd(link, links);
            }
            if (links.size() < 2) {
                return links;
            }
            ArrayList<List<N>> newLinks = new ArrayList<List<N>>(links.size());
            for (List list : links) {
                if (this.included(list, links)) continue;
                newLinks.add(list);
            }
            return newLinks;
        }

        private boolean cycleLinks(Deque<N> successorDeque, LinkedList<N> link, List<List<N>> links) {
            for (N successor : successorDeque) {
                if (link.contains(successor)) {
                    LinkedList<N> newLink = new LinkedList<N>(link);
                    newLink.addLast(successor);
                    this.checkRepeatLinkAndAdd(newLink, links);
                    continue;
                }
                link.addLast(successor);
                if (link.size() == 2 && this.included(link, links)) {
                    return false;
                }
                Deque successorDeque2 = this.successors.get(successor);
                if (successorDeque2 == null || successorDeque2.isEmpty()) {
                    this.checkRepeatLinkAndAdd(new LinkedList<N>(link), links);
                    link.removeLast();
                    continue;
                }
                this.cycleLinks(successorDeque2, link, links);
            }
            link.removeLast();
            return true;
        }

        private boolean included(List<N> link, List<List<N>> links) {
            for (List<N> list : links) {
                if (list.size() < 3) continue;
                for (int i = list.size() - 1; i >= 2; --i) {
                    if (!list.get(i).equals(link.get(1)) || !list.get(i - 1).equals(link.get(0))) continue;
                    return true;
                }
            }
            return false;
        }

        private void checkRepeatLinkAndAdd(LinkedList<N> link, List<List<N>> links) {
            if (link.isEmpty()) {
                return;
            }
            links.add(Collections.unmodifiableList(link));
        }

        public Map<List<N>, N> getCycles() {
            return this.links.stream().filter(it -> it.size() != new HashSet(it).size()).collect(Collectors.toMap(Collections::unmodifiableList, it -> it.get(it.size() - 1)));
        }

        public DirectedGraph<N> build() {
            this.links = this.links();
            return new DirectedGraph(this.allowsSelfLoops, Collections.unmodifiableSet(this.nodes), Collections.unmodifiableMap(this.successors.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, it -> Collections.unmodifiableList((List)it.getValue())))), Collections.unmodifiableSet(this.edges), Collections.unmodifiableList(this.links), Collections.unmodifiableMap(this.getCycles()));
        }
    }
}

