/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.common.model;

import java.util.Arrays;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;

public enum OpenApiAsyncStatusEnum {
    Accepted(202, "Accepted"),
    Ready(302, "Ready"),
    NotFound(404, "NotFound");

    private int openApiAsyncStatus;
    private String openApiAsyncDesc;

    private OpenApiAsyncStatusEnum(int status, String desc) {
        this.openApiAsyncStatus = status;
        this.openApiAsyncDesc = desc;
    }

    public static OpenApiAsyncStatusEnum getOpenApiAsync(long status) {
        return Arrays.stream(OpenApiAsyncStatusEnum.values()).filter(it -> (long)it.getStatus() == status).findFirst().orElseThrow(() -> new OpenApiException(ApiErrorCode.Data_Invalid, "OpenApiAsyncEnum status \u201c" + status + "\u201d is not supported", new Object[0]));
    }

    public int getStatus() {
        return this.openApiAsyncStatus;
    }

    public String getStatusStr() {
        return String.valueOf(this.openApiAsyncStatus);
    }

    public String getDesc() {
        return this.openApiAsyncDesc;
    }
}

