/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.common.result;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.util.DataUtil;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class OpenApiResult
implements Serializable {
    private static final long serialVersionUID = 1342323986837L;
    private boolean status = true;
    private String errorCode = "";
    private String message;
    private Object data;

    public OpenApiResult() {
    }

    public OpenApiResult(boolean status, String errorCode, String message, Object data) {
        this.status = status;
        this.errorCode = errorCode;
        this.message = message;
        this.data = data;
    }

    public void fromMap(Map<String, Object> obj) {
        this.setStatus((Boolean)obj.get("status"));
        this.setMessage(DataUtil.s(obj.get("message")));
        this.setData(obj.get("data"));
        this.setErrorCode((String)obj.get("errorCode"));
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> ret = new HashMap<String, Object>(4);
        ret.put("status", this.isStatus());
        ret.put("message", this.getMessage());
        ret.put("data", this.getData());
        ret.put("errorCode", this.getErrorCode());
        return ret;
    }

    public OpenApiResult fail(String msg) {
        return this.fail(msg, "fail");
    }

    public OpenApiResult fail(String msg, String errorCode) {
        this.setStatus(false);
        this.setMessage(msg);
        this.setErrorCode(errorCode);
        return this;
    }

    public OpenApiResult success(Object data) {
        this.setStatus(true);
        this.setData(data);
        this.setErrorCode("");
        return this;
    }

    public static OpenApiResult ok(Object data) {
        return new OpenApiResult().success(data);
    }

    public static OpenApiResult fail(ApiErrorCode errorCode, Object data) {
        return new OpenApiResult(false, errorCode.getStatusCode(), errorCode.toString(), data);
    }

    public static OpenApiResult builder() {
        return new OpenApiResult();
    }

    public boolean isStatus() {
        return this.status;
    }

    public void setStatus(boolean status) {
        this.status = status;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public String toString() {
        return "Status:" + this.status + "\nMessage:" + this.message + "\nErrorCode:" + this.errorCode + "\nData:" + (this.data == null ? "" : this.data.toString());
    }
}

