/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.common.util;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import kd.bos.openapi.common.constant.ApiDefType;
import kd.bos.openapi.common.model.OpenApiData;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.security.util.ParameterUtil;

public class ApiDataUtil {
    private static final String UNDER_CROSS = "-";

    public static String getResLimitResId(String accountId, String thirdId) {
        StringBuilder resBuilder = new StringBuilder();
        resBuilder.append("OpenApi").append(UNDER_CROSS);
        resBuilder.append("ThirdId");
        resBuilder.append(UNDER_CROSS).append(accountId).append(UNDER_CROSS).append(thirdId);
        return resBuilder.toString();
    }

    public static String getThirdResLimitResId(String accountId, String thirdIdOrAnonymous) {
        StringBuilder resBuilder = new StringBuilder();
        resBuilder.append("OpenApi").append(UNDER_CROSS);
        String resId = thirdIdOrAnonymous;
        if (StringUtil.isEmpty(thirdIdOrAnonymous)) {
            resBuilder.append("Anonymous");
            resId = "0";
        } else {
            resBuilder.append("ThirdId");
        }
        resBuilder.append(UNDER_CROSS).append(accountId).append(UNDER_CROSS).append(resId);
        return resBuilder.toString();
    }

    public static String getTenantResLimitResId(String tentantId, String accountId) {
        StringBuilder resBuilder = new StringBuilder();
        resBuilder.append("OpenApi").append(UNDER_CROSS).append(tentantId).append(UNDER_CROSS).append(accountId).append(UNDER_CROSS).append("0");
        return resBuilder.toString();
    }

    public static String getApiResLimitResId(String accountId, String apiId) {
        StringBuilder resBuilder = new StringBuilder();
        resBuilder.append("OpenApi").append(UNDER_CROSS);
        resBuilder.append("ApiId");
        resBuilder.append(UNDER_CROSS).append(accountId).append(UNDER_CROSS).append(apiId);
        return resBuilder.toString();
    }

    public static String getAnonymousThirdAppId(String accountId) {
        StringBuilder resBuilder = new StringBuilder();
        resBuilder.append("OpenApi").append(UNDER_CROSS);
        resBuilder.append("Anonymous");
        resBuilder.append(UNDER_CROSS).append(accountId).append(UNDER_CROSS).append("0");
        return resBuilder.toString();
    }

    public static boolean isOutParaIncludeStatus(OpenApiData openApiData, boolean isSoap) {
        if (openApiData != null && openApiData.isOutParaWithoutStatus()) {
            return false;
        }
        return openApiData == null || !isSoap || openApiData.getApiDefType() != ApiDefType.WSDL;
    }

    public static String getApiUrl(HttpServletRequest req) {
        String url = ApiDataUtil.getApiRequestUri(req);
        return ApiDataUtil.getApiUrl(url);
    }

    public static String getApiUrl(String fullUrl) {
        if (StringUtil.isEmpty(fullUrl)) {
            return "";
        }
        String url = fullUrl;
        int pos = fullUrl.indexOf("/$/");
        if (pos > 0) {
            url = fullUrl.substring(0, pos);
        }
        return url;
    }

    public static String getPathVarString(HttpServletRequest req) {
        String url = ApiDataUtil.getApiRequestUri(req);
        return ApiDataUtil.getPathVarString(url);
    }

    public static String getPathVarString(String fullUrl) {
        if (StringUtil.isEmpty(fullUrl)) {
            return "";
        }
        int tagLen = "/$/".length();
        int pos = fullUrl.indexOf("/$/");
        if (pos > 0 && fullUrl.length() > pos + tagLen) {
            return fullUrl.substring(pos + tagLen);
        }
        return "";
    }

    public static boolean isPathVarUrl(HttpServletRequest req) {
        String uri = req.getRequestURI();
        return uri.contains("/$/");
    }

    public static Map<String, String> getPathVarMap(String pathVar) {
        return ParameterUtil.getPathVarMap((String)pathVar);
    }

    private static String getApiRequestUri(HttpServletRequest req) {
        String contextPath = req.getContextPath() + "/kapi";
        String requestURI = req.getRequestURI();
        String url = requestURI.substring(contextPath.length());
        return url;
    }
}

