/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.common.util;

import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Date;

public class CommonDateUtil {
    public static final String COMPARE_DATE_FORMATE = "yyyy-MM-dd";

    public static String dateConvertString(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(COMPARE_DATE_FORMATE);
        return dateFormat.format(date);
    }

    public static boolean compareDateTime(Date startDate, Date endDate) {
        return CommonDateUtil.compareDateTime(startDate, endDate, COMPARE_DATE_FORMATE);
    }

    public static boolean compareDateTime(Date startDate, Date endDate, String dateFormatType) {
        LocalDate now = LocalDate.now();
        SimpleDateFormat df = new SimpleDateFormat(dateFormatType);
        LocalDate end = null;
        LocalDate start = null;
        if (startDate == null && endDate == null) {
            return true;
        }
        if (startDate != null && endDate == null) {
            start = LocalDate.parse(df.format(startDate));
            return start.compareTo(now) <= 0;
        }
        if (startDate == null && endDate != null) {
            end = LocalDate.parse(df.format(endDate));
            return now.compareTo(end) <= 0;
        }
        start = LocalDate.parse(df.format(startDate));
        end = LocalDate.parse(df.format(endDate));
        return start.compareTo(now) <= 0 && now.compareTo(end) <= 0;
    }
}

