/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.common.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;

public class DataSizeUtil {
    public static long getObjectSize(Object value) {
        if (value == null) {
            return 4L;
        }
        if (value instanceof Collection) {
            return DataSizeUtil.calcBytes((Collection)value);
        }
        if (value instanceof Map) {
            return DataSizeUtil.calcBytes((Map)value);
        }
        if (value instanceof CharSequence) {
            return ((CharSequence)value).length() * 2 + 8;
        }
        if (value instanceof byte[]) {
            return ((byte[])value).length + 8;
        }
        if (value instanceof Object[]) {
            return DataSizeUtil.calcBytes((Object[])value);
        }
        return value.getClass().isArray() ? DataSizeUtil.calcOtherArraySize(value) : 16L;
    }

    private static long calcOtherArraySize(Object array) {
        long total = 16L;
        int j = Array.getLength(array);
        for (int i = 0; i < j; ++i) {
            Object value = Array.get(array, i);
            total += DataSizeUtil.getObjectSize(value);
        }
        return total;
    }

    private static long calcBytes(Map<?, ?> m) {
        long total = 16L;
        for (Map.Entry<?, ?> e : m.entrySet()) {
            total += DataSizeUtil.getObjectSize(e.getKey());
            total += DataSizeUtil.getObjectSize(e.getValue());
        }
        return total;
    }

    private static long calcBytes(Collection<?> c) {
        long total = 16L;
        for (Object e : c) {
            total += DataSizeUtil.getObjectSize(e);
        }
        return total;
    }

    private static long calcBytes(Object[] c) {
        long total = 16L;
        Object[] var3 = c;
        int var4 = c.length;
        for (int var5 = 0; var5 < var4; ++var5) {
            Object e = var3[var5];
            total += DataSizeUtil.getObjectSize(e);
        }
        return total;
    }
}

