/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.MultiLangEnumBridge;
import kd.bos.openapi.common.exception.OpenApiException;

public class DateUtil {
    public static final String FORMAT_MONTH = "yyyy-MM";
    public static final String FORMAT_DAY = "yyyy-MM-dd";
    public static final String FORMAT_HOUR = "yyyy-MM-dd HH";
    public static final String FORMAT_MIN = "yyyy-MM-dd HH:mm";
    public static final String FORMAT_SECOND = "yyyy-MM-dd HH:mm:ss";
    public static final String ZERO_SEC = ":00";
    public static final String ZERO_HOUR_SEC = ":00:00";
    public static final String ZERO_DAY_HOUR_SEC = " 00:00:00";
    public static final String ZERO_MONTH_DAY_HOUR_SEC = "-01 00:00:00";
    public static final String FORMAT_SECOND_2 = "yyyyMMddHHmmss";

    public static String convertToStr(String format, Date date) {
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat(format);
        String dateStr = simpleDateFormat2.format(date);
        return dateStr;
    }

    public static Date convertToDate(String dateStr, String pattern) throws ParseException {
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat(pattern);
        return simpleDateFormat2.parse(dateStr);
    }

    public static Date getDateWithoutSec(Date date) throws ParseException {
        return DateUtil.convertToDate(DateUtil.convertToStr(FORMAT_MIN, date) + ZERO_SEC);
    }

    public static Date getDateWithoutMinute(Date date) throws ParseException {
        return DateUtil.convertToDate(DateUtil.convertToStr(FORMAT_HOUR, date) + ZERO_HOUR_SEC);
    }

    public static Date getDateWithoutHour(Date date) throws ParseException {
        return DateUtil.convertToDate(DateUtil.convertToStr(FORMAT_DAY, date) + ZERO_DAY_HOUR_SEC);
    }

    public static Date getDateWithFirstDay(Date date) throws ParseException {
        return DateUtil.convertToDate(DateUtil.convertToStr(FORMAT_MONTH, date) + ZERO_MONTH_DAY_HOUR_SEC);
    }

    private static Date convertToDate(String dateStr) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(FORMAT_MIN);
        return simpleDateFormat.parse(dateStr);
    }

    public static Date getTime(String datetimeString) {
        Date sDate = null;
        try {
            sDate = new Date(Long.parseLong(datetimeString));
        }
        catch (Throwable e) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, new MultiLangEnumBridge("\u53c2\u6570\u9519\u8bef:timestamp\u65f6\u95f4\u683c\u5f0f\u9519\u8bef\u3002", "DateUtil_1", "bos-open-common").loadKDString(), new Object[0]);
        }
        return sDate;
    }

    public static Date getDateAdd(Date date, int calendarField, int amount) {
        Calendar Cal = Calendar.getInstance();
        Cal.setTime(date);
        Cal.add(calendarField, amount);
        return Cal.getTime();
    }

    public static Long getTimeAt8AM(Date date) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(FORMAT_DAY);
        String format = simpleDateFormat.format(date);
        String time = format + " 08:00:00";
        SimpleDateFormat simplefm = new SimpleDateFormat(FORMAT_SECOND);
        return simplefm.parse(time).getTime();
    }

    public static Date getMinDate(Date date1, Date date2) {
        return date1.compareTo(date2) < 0 ? date1 : date2;
    }

    public static boolean isValidInDateTime(Date startDate, Date endDate, Date currentDate) {
        if (startDate == null || endDate == null) {
            return false;
        }
        if (currentDate == null) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "The currentDate is null\u3002", new Object[0]);
        }
        return startDate.compareTo(currentDate) <= 0 && endDate.compareTo(currentDate) >= 0;
    }
}

