/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.common.util;

import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kd.bos.encrypt.EncrypterFactory;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.StringUtil;
import org.apache.commons.lang3.RandomStringUtils;

public class EncryptUtil {
    public static final String HMAC_SHA_256;
    public static final String SPLIT_CHAR;
    public static final String PW_PATTERN = "^(?![A-Za-z0-9_]+$)(?![a-z0-9_\\W]+$)(?![A-Za-z_\\W]+$)(?![A-Z0-9_\\W]+$)[a-zA-Z0-9_\\W]{16,50}$";
    private static final String[] a;
    private static final String[] b;
    private static final String[] c;
    private static final String[] d;

    public static String genSign(String thirdId, String agentUserId) throws OpenApiException {
        return EncryptUtil.genSignString(thirdId, agentUserId, "open");
    }

    public static String genSignString(String thirdId, String agentUserId, String sysTag) throws OpenApiException {
        if (StringUtil.isEmpty(thirdId)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "genSign error, thirdId is null!", new Object[0]);
        }
        if (StringUtil.isEmpty(agentUserId)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "genSign error, agentUserId is null!", new Object[0]);
        }
        if (StringUtil.isEmpty(sysTag)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "genSign error, sysTag is null!", new Object[0]);
        }
        return EncryptUtil.genSign(RandomStringUtils.randomAlphabetic((int)64), thirdId, agentUserId, sysTag);
    }

    public static String genSign(String signKey, String thirdId, String agentUserId) throws OpenApiException {
        return EncryptUtil.genSign(signKey, thirdId, agentUserId, "open");
    }

    public static String genSign(String signKey, String thirdId, String agentUserId, String sysTag) throws OpenApiException {
        ArrayList<String> values = new ArrayList<String>(3);
        values.add(thirdId);
        values.add(signKey);
        values.add(agentUserId);
        values.add(sysTag);
        Collections.sort(values);
        StringBuilder returnValue = new StringBuilder();
        if (!CollectionUtil.isEmpty(values)) {
            for (int i = 0; i < values.size(); ++i) {
                if (i != 0) {
                    returnValue.append(SPLIT_CHAR);
                }
                returnValue.append((String)values.get(i));
            }
        }
        return EncryptUtil.genSHA256(returnValue.toString(), signKey);
    }

    public static String genSignWithAccountId(String sign, String accountId) {
        if (StringUtil.isEmpty(sign)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "genSignWithAccountId error, sign is null!", new Object[0]);
        }
        if (StringUtil.isEmpty(accountId)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "genSignWithAccountId error, accountId is null!", new Object[0]);
        }
        StringBuilder signNew = new StringBuilder();
        signNew.append(sign).append(":").append(accountId);
        return Base64.getUrlEncoder().encodeToString(signNew.toString().getBytes());
    }

    public static String genSHA256(String data, String key) {
        try {
            if (!StringUtil.isEmpty(data) && !StringUtil.isEmpty(key)) {
                SecretKeySpec signKey = new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), HMAC_SHA_256);
                Mac mac = Mac.getInstance(HMAC_SHA_256);
                mac.init(signKey);
                byte[] rawHmac = mac.doFinal(data.getBytes(StandardCharsets.UTF_8));
                return Base64.getUrlEncoder().encodeToString(rawHmac);
            }
            return null;
        }
        catch (Exception var6) {
            throw new OpenApiException(var6, ApiErrorCode.HTTP_INTERNAL_ERROR, "genSHA256 error:" + var6.getMessage(), new Object[0]);
        }
    }

    public static boolean isBase64(String sign) {
        char[] strChars;
        if (StringUtil.isEmpty(sign)) {
            return false;
        }
        if (sign.length() % 4 != 0) {
            return false;
        }
        for (char c : strChars = sign.toCharArray()) {
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '=' || c == '-' || c == '_') continue;
            return false;
        }
        return true;
    }

    public static String generatePwCode() {
        SecureRandom secureRandom = new SecureRandom();
        ArrayList<String> list = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        EncryptUtil.orderlyList(list, secureRandom);
        EncryptUtil.disorderList(list, secureRandom, sb);
        list.clear();
        if (sb.toString().matches(PW_PATTERN)) {
            return sb.toString();
        }
        return null;
    }

    private static void orderlyList(List<String> list, SecureRandom secureRandom) {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            String a1 = a[secureRandom.nextInt(a.length)];
            String b1 = b[secureRandom.nextInt(b.length)];
            String c1 = c[secureRandom.nextInt(c.length)];
            String d1 = d[secureRandom.nextInt(d.length)];
            list.add(i + n, a1);
            list.add(i + ++n, b1);
            list.add(i + ++n, c1);
            list.add(i + ++n, d1);
        }
    }

    private static StringBuilder disorderList(List<String> list, SecureRandom secureRandom, StringBuilder sb) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            int index = secureRandom.nextInt(list.size());
            String str = list.get(index);
            sb.append(str);
            list.remove(index);
        }
        return sb;
    }

    public static String encode(String code) {
        if (StringUtil.isNotEmpty(code) && !EncrypterFactory.getEncrypter().isEncrypted(code)) {
            return EncrypterFactory.getEncrypter().encode(code);
        }
        return code;
    }

    public static String decode(String code) {
        if (StringUtil.isNotEmpty(code) && EncrypterFactory.getEncrypter().isEncrypted(code)) {
            return EncrypterFactory.getEncrypter().decode(code);
        }
        return code;
    }

    static {
        a = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
        b = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z"};
        c = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
        d = new String[]{"~", "!", "@", "#", "$", "^", "&", "*", "+", "=", "-", ",", "?", ":"};
        HMAC_SHA_256 = "HmacSHA256";
        SPLIT_CHAR = "&";
    }
}

