/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.common.util;

import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.model.IpTypeEnum;
import kd.bos.openapi.common.util.StringUtil;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPWhiteListUtil {
    private static final Logger LOG = LoggerFactory.getLogger(IPWhiteListUtil.class);
    private static int IP_UNIT_INT_VALUE = -1;
    private static int IP_INIT_ZERO = 0;
    private static int IP_INIT_MAX = 255;
    private static char IP_SPLIT = (char)46;
    private static char IP_FIRST_NUM = (char)48;
    private static char IP_MAX_NUM = (char)57;
    private static final String FROM_IP = "fromIp";
    private static final String TO_IP = "toIp";
    private static final int ORDER_0 = 0;
    private static final int ORDER_1 = 1;
    private static final int ORDER_2 = 2;
    private static final int ORDER_3 = 3;
    private static final int NUM_8 = 8;
    private static final int NUM_16 = 16;
    private static final int NUM_24 = 24;
    private static final int NUM_256 = 256;
    private static final String COMMA = ",";
    public static String LOCAL_IP = "[0:0:0:0:0:0:0:1]";
    public static String LOCAL_IP_127 = "127.0.0.1";
    public static String DOMAIN_CHECK_REGEX = "^[a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?(\\.[a-zA-Z0-9]([a-zA-Z0-9\\-]{0,61}[a-zA-Z0-9])?)*$";

    public static boolean isValidIpAddress(String ipAddress) {
        char[] ipChars = ipAddress.toCharArray();
        int length = ipChars.length;
        int ipUnitIntValue = IP_UNIT_INT_VALUE;
        boolean isFirstUnit = true;
        int unitsCount = IP_INIT_ZERO;
        for (int i = IP_INIT_ZERO; i < length; ++i) {
            char c = ipChars[i];
            if (c == IP_SPLIT) {
                if (ipUnitIntValue < IP_INIT_ZERO || ipUnitIntValue > IP_INIT_MAX) {
                    return false;
                }
                if (isFirstUnit && ipUnitIntValue == IP_INIT_ZERO) {
                    return false;
                }
                if (isFirstUnit) {
                    isFirstUnit = false;
                }
                ipUnitIntValue = IP_UNIT_INT_VALUE;
                ++unitsCount;
                continue;
            }
            if (c < IP_FIRST_NUM || c > IP_MAX_NUM) {
                return false;
            }
            if (ipUnitIntValue == -1) {
                ipUnitIntValue = IP_INIT_ZERO;
            }
            ipUnitIntValue = ipUnitIntValue * 10 + (c - IP_FIRST_NUM);
        }
        if (ipUnitIntValue < IP_INIT_ZERO || ipUnitIntValue > IP_INIT_MAX) {
            return false;
        }
        return unitsCount == 3;
    }

    public static boolean isValidIpV6Address(String ipAddress) {
        if (StringUtil.isEmpty(ipAddress)) {
            return false;
        }
        String[] dataString = ipAddress.split(":");
        if (dataString.length != 8) {
            return false;
        }
        boolean isResult = false;
        for (String data : dataString) {
            if (StringUtil.isEmpty(data)) {
                isResult = false;
                break;
            }
            if (data.length() > 4) {
                isResult = false;
                break;
            }
            isResult = data.matches("[0-9A-Fa-f]+");
            if (!isResult) break;
        }
        return isResult;
    }

    public static boolean compareIp(String startIp, String endIp) {
        boolean result;
        if (!IPWhiteListUtil.isValidIpAddress(startIp)) {
            LOG.info("startIp:{} is invalid!!", (Object)startIp);
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "startIp is invald. " + startIp, new Object[0]);
        }
        if (!IPWhiteListUtil.isValidIpAddress(endIp)) {
            LOG.info("endIp:{} is invalid!!", (Object)endIp);
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "endIp is invald. " + endIp, new Object[0]);
        }
        try {
            long startIpL = IPWhiteListUtil.ipToLong(startIp);
            long endIpL = IPWhiteListUtil.ipToLong(endIp);
            result = startIpL <= endIpL;
        }
        catch (Exception e) {
            throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, "CheckIP exception:" + e.getMessage(), new Object[0]);
        }
        return result;
    }

    public static boolean compareIpv6(String startIp, String endIp) {
        long[] endIps;
        boolean result = false;
        long[] startIps = IPWhiteListUtil.ipv6ToLongs(startIp);
        if (startIps[0] > (endIps = IPWhiteListUtil.ipv6ToLongs(endIp))[0]) {
            result = false;
        } else if (startIps[0] == endIps[0]) {
            if (startIps[1] <= endIps[1]) {
                result = true;
            }
        } else {
            result = true;
        }
        return result;
    }

    public static boolean checkIp(String ip, List<Map<String, String>> list) {
        boolean flag = false;
        if (CollectionUtils.isEmpty(list)) {
            return false;
        }
        if (LOCAL_IP.equalsIgnoreCase(ip)) {
            return true;
        }
        if (LOCAL_IP_127.equalsIgnoreCase(ip)) {
            return true;
        }
        if (!IPWhiteListUtil.isValidIpAddress(ip)) {
            LOG.info("ip:{} is invalid!!", (Object)ip);
            return false;
        }
        try {
            for (Map<String, String> ipc : list) {
                long startIp = IPWhiteListUtil.ipToLong(ipc.get(FROM_IP));
                long endIp = IPWhiteListUtil.ipToLong(ipc.get(TO_IP));
                long ipCheck = IPWhiteListUtil.ipToLong(ip);
                if (ipCheck >= startIp && ipCheck <= endIp) {
                    flag = true;
                    break;
                }
                flag = false;
            }
        }
        catch (Exception e) {
            throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, "CheckIP exception:" + e.getMessage(), new Object[0]);
        }
        return flag;
    }

    public static boolean checkIpv6(String ip, List<Map<String, String>> list) {
        boolean flag = false;
        if (CollectionUtils.isEmpty(list)) {
            return false;
        }
        if (LOCAL_IP.equalsIgnoreCase(ip)) {
            return true;
        }
        if (!IPWhiteListUtil.isValidIpV6Address(ip)) {
            LOG.info("ip:{} is not IPv6 address, please check it.", (Object)ip);
            return false;
        }
        try {
            for (Map<String, String> ipc : list) {
                long[] startIp = IPWhiteListUtil.ipv6ToLongs(ipc.get(FROM_IP));
                long[] endIp = IPWhiteListUtil.ipv6ToLongs(ipc.get(TO_IP));
                long[] ipCheck = IPWhiteListUtil.ipv6ToLongs(ip);
                if (ipCheck[0] > startIp[0] && ipCheck[0] < endIp[0]) {
                    flag = true;
                    break;
                }
                if (ipCheck[0] < startIp[0] || ipCheck[0] > endIp[0]) {
                    flag = false;
                    continue;
                }
                if (ipCheck[1] >= startIp[1] && ipCheck[1] <= endIp[1]) {
                    flag = true;
                    break;
                }
                flag = false;
            }
        }
        catch (Exception e) {
            throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, "checkIpv6 exception:" + e.getMessage(), new Object[0]);
        }
        return flag;
    }

    public static String getFullIpv6(String ipv6String) {
        if (StringUtil.isEmpty(ipv6String)) {
            return ipv6String;
        }
        String[] ipv6Strings = ipv6String.split(":");
        if (ipv6Strings.length != 8) {
            return ipv6String;
        }
        StringBuilder ipv6NewBuilder = new StringBuilder();
        for (String ipv6Str : ipv6Strings) {
            if (ipv6Str.length() < 4) {
                ipv6Str = StringUtil.strLeftPad(ipv6Str, "0", 4 - ipv6Str.length());
            }
            ipv6NewBuilder.append(ipv6Str).append(":");
        }
        return ipv6NewBuilder.substring(0, ipv6NewBuilder.length() - 1);
    }

    public static long[] ipv6ToLongs(String ipv6String) {
        if (StringUtil.isEmpty(ipv6String)) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, "ipv6String cannot be null.", new Object[0]);
        }
        String[] ipSlices = ipv6String.split(":");
        if (ipSlices.length != 8) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, ipv6String + " is not an ipv6 address.", new Object[0]);
        }
        long[] ipv6 = new long[2];
        for (int i = 0; i < 8; ++i) {
            String slice = ipSlices[i];
            long num = Long.parseLong(slice, 16);
            long right = num << 16 * i;
            int length = i >> 2;
            ipv6[length] = ipv6[length] | right;
        }
        return ipv6;
    }

    public static String longsToIpv6(Long[] ipv6Nums) {
        if (ipv6Nums == null || ipv6Nums.length != 2) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, Arrays.toString((Object[])ipv6Nums) + " is not an IPv6 address.", new Object[0]);
        }
        StringBuilder sb = new StringBuilder();
        Long[] longArray = ipv6Nums;
        int n = longArray.length;
        for (int i = 0; i < n; ++i) {
            long numSlice = longArray[i];
            for (int j = 0; j < 4; ++j) {
                long current = numSlice & 0xFFFFL;
                sb.append(Long.toString(current, 16)).append(":");
                numSlice >>= 16;
            }
        }
        return sb.substring(0, sb.length() - 1);
    }

    public static long ipToLong(String ip) {
        if (StringUtil.isEmpty(ip)) {
            throw new OpenApiException(ApiErrorCode.HTTP_INTERNAL_ERROR, "ipToLong exception ip is null.", new Object[0]);
        }
        ip = ip.replaceAll(" ", "");
        String[] ipArray = ip.split("\\.");
        long ipLong = (Long.parseLong(ipArray[0]) << 24) + (Long.parseLong(ipArray[1]) << 16) + (Long.parseLong(ipArray[2]) << 8) + Long.parseLong(ipArray[3]);
        return ipLong;
    }

    public static String longToIP(long ip) {
        long a = ip % 256L;
        long b = (ip -= a) >> 24;
        long c = (ip -= b << 24) >> 16;
        long d = (ip -= c << 16) >> 8;
        StringBuilder sbIP = new StringBuilder();
        sbIP.append(b);
        sbIP.append(IP_SPLIT);
        sbIP.append(c);
        sbIP.append(IP_SPLIT);
        sbIP.append(d);
        sbIP.append(IP_SPLIT);
        sbIP.append(a);
        return sbIP.toString();
    }

    public static List<String> getAllIpLIst(String ip) {
        ArrayList<String> ipList = new ArrayList<String>();
        String[] ips = ip.split(COMMA);
        if (ips != null && ips.length > 0) {
            for (String ipstr : ips) {
                if (StringUtil.isEmpty(ipstr) || LOCAL_IP_127.equals(ipstr.trim())) continue;
                ipList.add(ipstr);
            }
        }
        return ipList;
    }

    public static IpTypeEnum getIpType(String ip) {
        if (IPWhiteListUtil.isValidIpAddress(ip)) {
            return IpTypeEnum.IPV4;
        }
        if (IPWhiteListUtil.isValidIpV6Address(ip)) {
            return IpTypeEnum.IPV6;
        }
        throw new OpenApiException(ApiErrorCode.Data_Invalid, "This ip:" + ip + " is not IPv4 or IPv6, please check it.", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isNetworkEnable(String url) {
        HttpURLConnection connection = null;
        try {
            URL httpUrl = new URL(url);
            connection = (HttpURLConnection)httpUrl.openConnection();
            connection.setConnectTimeout(5000);
            connection.connect();
            int responseCode = connection.getResponseCode();
            boolean bl = responseCode == 200;
            return bl;
        }
        catch (Exception e) {
            LOG.info("isNetworkEnable error:" + e.getMessage(), (Throwable)e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
        return false;
    }

    public static boolean isDomainValid(String domain) {
        return domain.matches(DOMAIN_CHECK_REGEX);
    }
}

