/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.common.util;

import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.ObjectConverter;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.StringUtil;

public class McConfigUtil {
    public static String getPropertyByCurrTenant(String key, String defaultStr) {
        String tenantId = RequestContext.get() != null ? RequestContext.get().getTenantId() : "";
        return McConfigUtil.getPropertyByTenantWithDefault(tenantId, key, defaultStr);
    }

    public static String getPropertyByTenant(String tenantId, String key) {
        String pValue = System.getProperty(tenantId + "_" + key);
        if (StringUtil.isEmpty(pValue)) {
            pValue = System.getProperty(key);
        }
        return pValue;
    }

    public static String getPropertyByCurrent(String key, String defaultStr) {
        if (RequestContext.get() == null) {
            throw new OpenApiException(ApiErrorCode.Data_NoAuth, "RequestContext cannot be null.", new Object[0]);
        }
        String tenantId = RequestContext.get().getTenantId();
        return McConfigUtil.getPropertyByTenantWithDefault(tenantId, key, defaultStr);
    }

    public static String getPropertyByTenantWithDefault(String tenantId, String key, String defaultStr) {
        String pValue = McConfigUtil.getPropertyByTenant(tenantId, key);
        if (StringUtil.isEmpty(pValue)) {
            pValue = defaultStr;
        }
        return pValue;
    }

    public static <T> T getPropertyByCurrent(String key, Class<T> cls, T defaultValue) {
        String value = McConfigUtil.getPropertyByCurrent(key, defaultValue.toString());
        return (T)ObjectConverter.convert((Object)value, cls, (boolean)false);
    }

    public static <T> T getPropertyGlobal(String key, Class<T> cls, T defaultValue) {
        String value = System.getProperty(key, defaultValue.toString());
        return (T)ObjectConverter.convert((Object)value, cls, (boolean)false);
    }

    public static boolean needWriteLogDetail() {
        return "detail2".equalsIgnoreCase(System.getProperty("api.writelog.level"));
    }

    public static boolean isSecurityLogOpen(String tenantId) {
        return "true".equalsIgnoreCase(McConfigUtil.getPropertyByTenantWithDefault(tenantId, "ApiSecurityLogOpen", "false"));
    }
}

