/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import kd.bos.openapi.common.util.JacksonUtil;
import kd.bos.openapi.common.util.JsonUtil;
import kd.bos.openapi.common.util.McConfigUtil;

public class OpenJsonUtil {
    private static final String JSON_CLASS = "openapi.jsonClass";
    private static final String JSON_FORMAT = "openapi.jsonFormat";
    private static final String JACKSON = "jackson";

    private static boolean isFormat() {
        boolean isFormat = "true".equals(McConfigUtil.getPropertyByCurrTenant(JSON_FORMAT, "true"));
        return isFormat;
    }

    private static boolean isJackson() {
        boolean isJackson = JACKSON.equals(McConfigUtil.getPropertyByCurrTenant(JSON_CLASS, "fastjson"));
        return isJackson;
    }

    public static String toJson(Object resultData) {
        String json = OpenJsonUtil.isJackson() ? (OpenJsonUtil.isFormat() ? JacksonUtil.writeValueAsPrettyString(resultData) : JacksonUtil.writeValueAsString(resultData)) : (OpenJsonUtil.isFormat() ? JsonUtil.format(resultData) : JsonUtil.toJsonString(resultData, new SerializerFeature[0]));
        return json;
    }

    public static Object fromJson(String json) {
        if (OpenJsonUtil.isJackson()) {
            return JacksonUtil.readValue(json, Object.class);
        }
        return JSON.parseObject((String)json);
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        if (OpenJsonUtil.isJackson()) {
            return JacksonUtil.readValue(json, clazz);
        }
        return (T)JSON.parseObject((String)json, clazz);
    }
}

