/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.common.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.openapi.common.util.PathVariableUtil;

public class PathVariableMatcher {
    private final Pattern pattern;
    private final Map<String, Integer> variableNameToGroupMap = new HashMap<String, Integer>(16);

    public PathVariableMatcher(String apiUri) {
        StringBuffer buffer = new StringBuffer();
        int groupIndex = 1;
        Matcher matcher = PathVariableUtil.getMatcher(apiUri);
        while (matcher.find()) {
            String variableName = matcher.group(1);
            this.variableNameToGroupMap.put(variableName, groupIndex++);
            matcher.appendReplacement(buffer, "([^/]+)");
        }
        matcher.appendTail(buffer);
        this.pattern = Pattern.compile(buffer.toString());
    }

    public boolean isMatch(String requestUri) {
        return this.pattern.matcher(requestUri).matches();
    }

    public Map<String, String> match(String requestUri) {
        Matcher matcher = this.pattern.matcher(requestUri);
        if (!matcher.matches()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> result = new HashMap<String, String>(this.variableNameToGroupMap.size());
        for (Map.Entry<String, Integer> entry : this.variableNameToGroupMap.entrySet()) {
            String variableName = entry.getKey();
            int groupIndex = entry.getValue();
            result.put(variableName, matcher.group(groupIndex));
        }
        return result;
    }
}

