/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.common.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.openapi.common.constant.ResSystemType;
import kd.bos.openapi.common.util.DataUtil;
import kd.sdk.annotation.SdkInternal;
import org.apache.commons.lang3.StringUtils;

@SdkInternal
public class StringUtil {
    public static final String separator = ",";
    public static final String STAR = "*";

    public static boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtil.isEmpty(str);
    }

    public static String replaceNull(String str) {
        return str == null ? "" : str.trim();
    }

    public static Object replaceNull(Object str) {
        return str == null ? "" : str;
    }

    public static boolean equals(String s1, String s2) {
        if (s1 == null) {
            return s2 == null;
        }
        return s1.equals(s2);
    }

    public static List<String> strToList(String str) {
        return StringUtil.isNotEmpty(str) ? Arrays.asList(str.split(separator)) : null;
    }

    public static String changeFirstCharacterCase(String str, boolean capitalize) {
        if (str != null && str.length() != 0) {
            StringBuilder buf = new StringBuilder(str.length());
            if (capitalize) {
                buf.append(Character.toUpperCase(str.charAt(0)));
            } else {
                buf.append(Character.toLowerCase(str.charAt(0)));
            }
            buf.append(str.substring(1));
            return buf.toString();
        }
        return str;
    }

    public static String substring(Object obj, int maxLength) {
        String str = DataUtil.s(obj);
        if (str == null) {
            return null;
        }
        if (str.length() <= maxLength) {
            return str;
        }
        return str.substring(0, maxLength - 3) + "...";
    }

    public static int indexOfIngnoreCase(String str, String subStr) {
        String lowerStr = str.toLowerCase();
        String lowerSubStr = subStr.toLowerCase();
        return lowerStr.indexOf(lowerSubStr);
    }

    public static String replaceInvalidString(String strSource) {
        String str;
        int i;
        if (StringUtil.isEmpty(strSource)) {
            return "";
        }
        HashMap<String, String> map = new HashMap<String, String>();
        int ch = 97;
        for (i = 0; i < 26; ++i) {
            str = String.valueOf((char)(ch + i));
            map.put(str, str);
        }
        ch = 65;
        for (i = 0; i < 26; ++i) {
            str = String.valueOf((char)(ch + i));
            map.put(str, str);
        }
        for (i = 0; i < 10; ++i) {
            str = String.valueOf(i);
            map.put(str, str);
        }
        map.put(":", ":");
        map.put("=", "=");
        map.put("/", "/");
        map.put("\\", "\\");
        map.put("_", "_");
        map.put("-", "-");
        map.put(STAR, STAR);
        StringBuilder temp = new StringBuilder();
        for (int i2 = 0; i2 < strSource.length(); ++i2) {
            if (map.get(strSource.charAt(i2) + "") == null) continue;
            temp.append((String)map.get(strSource.charAt(i2) + ""));
        }
        return temp.toString();
    }

    public static int countMatches(CharSequence str, char ch) {
        return StringUtils.countMatches((CharSequence)str, (char)ch);
    }

    public static int countMatches(CharSequence str, CharSequence sub) {
        return StringUtils.countMatches((CharSequence)str, (CharSequence)sub);
    }

    public static String captureName(String name) {
        char[] cs = name.toCharArray();
        cs[0] = (char)(cs[0] + 32);
        return String.valueOf(cs);
    }

    public static String getErrorMsg(OperationResult oprtResult) {
        String message = oprtResult.getMessage();
        ValidateResultCollection validateResult = oprtResult.getValidateResult();
        List validateErrors = validateResult == null ? null : validateResult.getValidateErrors();
        message = validateErrors == null || validateErrors.size() == 0 ? String.format(ResManager.loadKDString((String)"\u6267\u884c\u53d1\u751f\u9519\u8bef\uff01\u64cd\u4f5c\u8fd4\u56de\u5185\u5bb9\uff1a%1$s", (String)"StringUtil_0", (String)ResSystemType.COMMON.getType(), (Object[])new Object[0]), SerializationUtils.toJsonString((Object)oprtResult)) : SerializationUtils.toJsonString((Object)oprtResult);
        return message;
    }

    public static String strLeftPad(String str, String character, int leftNum) {
        if (StringUtil.isEmpty(str) || StringUtil.isEmpty(character) || leftNum <= 0) {
            return str;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < leftNum; ++i) {
            stringBuilder.append(character);
        }
        return stringBuilder.append(str).toString();
    }

    public static String getStringValue(Object StringObj) {
        String returnString = null;
        if (StringObj instanceof String) {
            returnString = (String)StringObj;
        } else if (StringObj != null) {
            returnString = String.valueOf(StringObj);
        }
        return returnString;
    }

    public static String trim(String s, int maxLength) {
        if (s == null) {
            return s;
        }
        if ((s = s.trim()).length() <= maxLength) {
            return s;
        }
        int i = (s = s.substring(0, maxLength - 3)).lastIndexOf(10);
        return i < 0 ? s + "\u2026" : s.substring(0, i).trim() + " \u2026";
    }
}

