/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.common.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Set;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.StringUtil;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class XmlJsonUtil {
    private static final String XML_ARRAY = "array";

    public static JSONObject documentToJSONObject(String xml, Set<String> reqMultiValueParams, boolean isSoapXml) {
        try {
            return XmlJsonUtil.elementToJSONObject(XmlJsonUtil.strToDocument(xml).getRootElement(), "", reqMultiValueParams, isSoapXml, 0);
        }
        catch (Exception ex) {
            throw new OpenApiException(ex, ApiErrorCode.HTTP_BAD_REQUEST, "Parse xml error:" + ex.getMessage(), new Object[0]);
        }
    }

    public static JSONObject documentToJSONObject(String xml) {
        return XmlJsonUtil.documentToJSONObject(xml, null, false);
    }

    private static Document strToDocument(String xml) throws DocumentException {
        return DocumentHelper.parseText((String)xml);
    }

    private static JSONObject elementToJSONObject(Element node, String parentNodeFullName, Set<String> reqMultiValueParams, boolean isSoapXml, int level) {
        JSONObject result = new JSONObject();
        ++level;
        List listElement = node.elements();
        if (!listElement.isEmpty()) {
            for (Element e : listElement) {
                String curNodeFullName = "";
                if (!isSoapXml || isSoapXml && level > 2) {
                    curNodeFullName = StringUtil.isEmpty(parentNodeFullName) ? e.getName() : parentNodeFullName + "." + e.getName();
                }
                XmlJsonUtil.debugOut(e.getName());
                if (e.elements().isEmpty()) {
                    if (XmlJsonUtil.isJSONArray(e, curNodeFullName, reqMultiValueParams)) {
                        String objValue;
                        if (!result.containsKey((Object)e.getName())) {
                            result.put(e.getName(), (Object)new JSONArray());
                        }
                        if (!StringUtil.isNotEmpty(objValue = e.getTextTrim())) continue;
                        ((JSONArray)result.get((Object)e.getName())).add((Object)e.getTextTrim());
                        continue;
                    }
                    result.put(e.getName(), (Object)e.getTextTrim());
                    continue;
                }
                if (XmlJsonUtil.isJSONArray(e, curNodeFullName, reqMultiValueParams)) {
                    if (!result.containsKey((Object)e.getName())) {
                        result.put(e.getName(), (Object)new JSONArray());
                    }
                    ((JSONArray)result.get((Object)e.getName())).add((Object)XmlJsonUtil.elementToJSONObject(e, curNodeFullName, reqMultiValueParams, isSoapXml, level));
                    continue;
                }
                result.put(e.getName(), (Object)XmlJsonUtil.elementToJSONObject(e, curNodeFullName, reqMultiValueParams, isSoapXml, level));
            }
        }
        return result;
    }

    private static boolean isJSONArray(Element node, String nodeFullName, Set<String> reqMultiValueParams) {
        Attribute attribute = node.attribute("type");
        if (attribute != null && XML_ARRAY.equals(attribute.getValue())) {
            return true;
        }
        return StringUtil.isNotEmpty(nodeFullName) && reqMultiValueParams != null && reqMultiValueParams.contains(nodeFullName);
    }

    private static void debugOut(String value) {
    }
}

