/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.common.wsdl;

import com.alibaba.fastjson.JSONObject;
import java.util.Iterator;
import java.util.Set;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.RestSoapType;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.Pair;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.common.util.XmlJsonUtil;
import kd.bos.openapi.common.util.XmlUtil;
import org.dom4j.Element;

public class SoapUtil {
    public static JSONObject readSoapToJson(String xmlBody) {
        return SoapUtil.readSoapToJson(xmlBody, null);
    }

    public static JSONObject readSoapToJson(String xmlBody, Set<String> multiValueModel) {
        String key;
        Object data;
        JSONObject bodyObject;
        Iterator it;
        JSONObject jsonObject = XmlJsonUtil.documentToJSONObject(xmlBody, multiValueModel, true);
        Object body = jsonObject.get((Object)"Body");
        if (body instanceof JSONObject && (it = (bodyObject = (JSONObject)body).keySet().iterator()).hasNext() && (data = bodyObject.get((Object)(key = (String)it.next()))) instanceof JSONObject) {
            return (JSONObject)data;
        }
        throw new OpenApiException(ApiErrorCode.Data_Invalid, "Parse soap/xml error(Not a valid soap data)", new Object[0]);
    }

    @Deprecated
    public static void doParse(JSONObject jsonObject, Element element) {
    }

    public static RestSoapType getRestSoapType(String xml) {
        if (xml == null) {
            return RestSoapType.REST;
        }
        String xmlStr = xml.substring(0, Math.min(200, xml.length()));
        if (xmlStr.contains("http://schemas.xmlsoap.org/soap/envelope/")) {
            return RestSoapType.SOAP1_1;
        }
        if (xmlStr.contains("http://www.w3.org/2003/05/soap-envelope")) {
            return RestSoapType.SOAP1_2;
        }
        return RestSoapType.REST;
    }

    public static Pair<String, String> getNamespace(String namespace) {
        String[] nameSpaceArray;
        String nsTag = "kapi";
        String namespaceStr = namespace;
        if (StringUtil.isEmpty(namespace)) {
            namespaceStr = "http://openapi.kingdee.com";
        } else if (namespace.contains("=") && (nameSpaceArray = namespace.split("=")).length == 2) {
            nsTag = nameSpaceArray[0];
            namespaceStr = nameSpaceArray[1];
        }
        Pair<String, String> pair = new Pair<String, String>(nsTag, namespaceStr);
        return pair;
    }

    public static String getSoapXml(Object data, RestSoapType soapType, String namespace, String dataNodeName) {
        Pair<String, String> namespacePair = SoapUtil.getNamespace(namespace);
        String nsTag = namespacePair.getKey();
        String namespaceStr = namespacePair.getValue();
        String dataXml = "";
        String namespaceTag = "";
        String xmlns = "";
        String xml = XmlUtil.objectToXml(data, true, false, false, "", 2);
        if (!StringUtil.isEmpty(dataNodeName)) {
            dataXml = "      <" + nsTag + ":" + dataNodeName + ">" + xml + "\n      </" + nsTag + ":" + dataNodeName + ">\n";
            namespaceTag = "xmlns:" + nsTag + "=\"" + namespaceStr + "\"";
        }
        xmlns = soapType == RestSoapType.SOAP1_1 ? " xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" " : " xmlns:soapenv=\"http://www.w3.org/2003/05/soap-envelope\" ";
        String soap = "<soapenv:Envelope " + xmlns + namespaceTag + ">\n   <soapenv:Header/>\n   <soapenv:Body>\n" + dataXml + "   </soapenv:Body>\n</soapenv:Envelope>";
        return soap;
    }

    public static boolean isSoapBody(String body) {
        if (StringUtil.isEmpty(body)) {
            return false;
        }
        if (body.length() > 300) {
            body = body.substring(0, 300);
        }
        return body.contains("http://schemas.xmlsoap.org/soap/envelope/");
    }
}

