/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.open;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AnchorItems;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.ext.form.control.AnchorControl;
import kd.bos.form.IPageCache;
import kd.bos.form.container.Tab;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.Control;
import kd.bos.form.control.Label;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.utils.ApiDataToJsonFormatUtils;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.openapi.form.util.ApiPluginUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;
import kd.bos.url.UrlService;

public class APIPRDPagePlugin
extends AbstractTreeListPlugin
implements TreeNodeClickListener,
ClickListener,
BeforeF7SelectListener {
    private static final String ENTITY_OPEN_API_SERVICE = "open_apiservice";
    private static final String ENTITY_OPEN_API_SERVICE_NEW = "open_apiservice_new";
    private static final String ENTITY_UNIT_FORM = "bos_devportal_unitrelform";
    private static final String SELECT_FIELD_API = "id,name,number,bizobject,appid,enable";
    private static final String PAGE_CACHE_KEY_CLOUD_APP_NODE = "cloud_app_node_cache";
    private static final String KEY_CLOUD_COMBO = "cloudcombo";
    private static final String KEY_HTTP_METHOD = "httpmethod";
    private static final String KEY_APP_TREE = "treeview";
    private static final String DATA_FIELD_NAME = "name";
    private static final String DATA_FIELD_ID = "ID";
    private static final String DATA_FIELD_NUMBER = "number";
    private static final String DATA_FIELD_OBJECT = "bizobject";
    private static final String DATA_FIELD_CLOUD = "bizcloud";
    private static final String DATA_FIELD_ENABLE = "enable";
    private static final String DATA_FIELD_APP_ID = "appid";
    private static final String DATA_FIELD_FORM = "form";
    private static final String DATA_FIELD_BIZAPP = "bizapp";
    private static final String SELECT_FIELD_FORM = "form,bizapp";
    private static final String HTTP_TYPE_POST = "POST";
    private static final String REQBODYPANEL = "reqbodypanel";
    private static final String BODYTAB = "bodytab";
    private static final String HEADERENTRYENTITY = "headerentryentity";
    private static final String URLPARAMENTRYENTITY = "urlparamentryentity";
    private static final String BODYENTRYENTITY = "bodyentryentity";
    private static final String RESPENTRYENTITY = "respentryentity";
    private static final String BOS_FORM_BUSINESS = "bos-form-business";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getView().getControl(KEY_APP_TREE);
        if (null != treeView) {
            treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        }
        BasedataEdit f7 = (BasedataEdit)this.getControl(KEY_CLOUD_COMBO);
        f7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.initAnchorControl(true);
        this.initAppTree();
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("heightLimit", Boolean.FALSE);
        this.getView().updateControlMetadata(HEADERENTRYENTITY, map);
        this.getView().updateControlMetadata(URLPARAMENTRYENTITY, map);
        this.getView().updateControlMetadata(BODYENTRYENTITY, map);
        this.getView().updateControlMetadata(RESPENTRYENTITY, map);
    }

    public void treeNodeClick(TreeNodeEvent e) {
        super.treeNodeClick(e);
        if ("8609760E-EF83-4775-A9FF-CCDEC7C0B689".equals(e.getParentNodeId())) {
            return;
        }
        this.clearAllApiInfo();
        String nodeId = e.getNodeId().toString();
        DynamicObject apiInfo = BusinessDataServiceHelper.loadSingle((Object)nodeId, (String)ENTITY_OPEN_API_SERVICE_NEW);
        if (Objects.isNull(apiInfo)) {
            return;
        }
        this.showApiBaseInfo(apiInfo);
        this.showApiRequestParamInfo(apiInfo);
        this.showApiResponseInfo(apiInfo);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if (!KEY_CLOUD_COMBO.equals(propertyName)) {
            return;
        }
        TreeView treeView = (TreeView)this.getView().getControl(KEY_APP_TREE);
        treeView.deleteAllNodes();
        TreeNode root = this.initRootTreeNode();
        treeView.addNode(root);
        treeView.setRootVisible(false);
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        String value = pageCache.get(PAGE_CACHE_KEY_CLOUD_APP_NODE);
        String cloudId = "";
        if (e.getChangeSet()[0].getNewValue() != null) {
            cloudId = (String)((DynamicObject)e.getChangeSet()[0].getNewValue()).get("id");
        }
        JSONObject json = JSON.parseObject((String)value);
        if (StringUtils.isNotBlank((CharSequence)cloudId)) {
            List treeNodes = JSONArray.parseArray((String)json.getString(cloudId), TreeNode.class);
            root.addChildren(treeNodes);
        } else {
            DynamicObject[] clouds;
            for (DynamicObject cloud : clouds = BusinessDataServiceHelper.load((String)"bos_devportal_bizcloud", (String)"id,name", null, (String)"sequence asc")) {
                String id = cloud.getString(DATA_FIELD_ID);
                List treeNodes = JSONArray.parseArray((String)json.getString(id), TreeNode.class);
                if (CollectionUtils.isEmpty((Collection)treeNodes)) continue;
                root.addChildren(treeNodes);
            }
        }
        this.clearAllApiInfo();
        this.defaultClickFirstNode(root.getChildren());
    }

    private void initAnchorControl(boolean isShowReqBodyPanel) {
        ArrayList<AnchorItems> list = new ArrayList<AnchorItems>(5);
        list.add(new AnchorItems("baseinfopanel", ResManager.loadKDString((String)"\u63a5\u53e3\u57fa\u672c\u4fe1\u606f", (String)"APIPRDPagePlugin_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), null));
        list.add(new AnchorItems("reqparampanel", ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570", (String)"APIPRDPagePlugin_1", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), null));
        if (isShowReqBodyPanel) {
            list.add(new AnchorItems(REQBODYPANEL, ResManager.loadKDString((String)"\u8bf7\u6c42\u7ed3\u6784\u793a\u4f8b", (String)"APIPRDPagePlugin_2", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), null));
        }
        list.add(new AnchorItems("restablepanel", ResManager.loadKDString((String)"\u8fd4\u56de\u53c2\u6570", (String)"APIPRDPagePlugin_3", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), null));
        list.add(new AnchorItems("resbodypanel", ResManager.loadKDString((String)"\u8fd4\u56de\u7ed3\u6784\u793a\u4f8b", (String)"APIPRDPagePlugin_4", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), null));
        AnchorControl control = (AnchorControl)this.getControl("anchorcontrolap");
        control.setHighlight(true);
        control.addItems(list);
    }

    private void initAppTree() {
        TreeView treeView = (TreeView)this.getView().getControl(KEY_APP_TREE);
        TreeNode root = this.initRootTreeNode();
        treeView.addNode(root);
        treeView.setRootVisible(false);
        Map<String, TreeNode> appNodeMap = this.createAppNode();
        Map<String, DynamicObject> notExistAppIdApis = this.createLeafNode(appNodeMap);
        this.createLeafNode(appNodeMap, notExistAppIdApis);
        ArrayList<TreeNode> childNodes = new ArrayList<TreeNode>(appNodeMap.size());
        HashMap<String, TreeNode> cacheNodeMap = new HashMap<String, TreeNode>(appNodeMap.size());
        for (Map.Entry<String, TreeNode> entry : appNodeMap.entrySet()) {
            TreeNode node = entry.getValue();
            if (CollectionUtils.isEmpty((Collection)node.getChildren())) continue;
            childNodes.add(node);
            cacheNodeMap.put(entry.getKey(), node);
        }
        root.addChildren(childNodes);
        this.defaultClickFirstNode(childNodes);
        this.putAppNodeToPageCache(cacheNodeMap);
    }

    private void defaultClickFirstNode(List<TreeNode> nodes) {
        if (CollectionUtils.isEmpty(nodes)) {
            return;
        }
        for (TreeNode node : nodes) {
            List childNodes = node.getChildren();
            if (CollectionUtils.isEmpty((Collection)childNodes)) continue;
            TreeNode showApiInfoNode = (TreeNode)childNodes.get(0);
            TreeView treeView = (TreeView)this.getView().getControl(KEY_APP_TREE);
            treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
            treeView.showNode(showApiInfoNode.getParentid());
            treeView.focusNode(showApiInfoNode);
            treeView.treeNodeClick(showApiInfoNode.getParentid(), showApiInfoNode.getId());
            return;
        }
    }

    private void clearAllApiInfo() {
        Label apiNameLabel = (Label)this.getControl("apiname");
        Label apiDesLabel = (Label)this.getControl("apides");
        Label reqTypeLabel = (Label)this.getControl("reqtype");
        Label reqUrlLabel = (Label)this.getControl("requrl");
        apiNameLabel.setText("");
        apiDesLabel.setText("");
        reqTypeLabel.setText("");
        reqUrlLabel.setText("");
        this.getView().setVisible(Boolean.TRUE, new String[]{BODYTAB});
        this.getView().setVisible(Boolean.TRUE, new String[]{REQBODYPANEL});
        this.getModel().deleteEntryData(HEADERENTRYENTITY);
        this.getModel().deleteEntryData(URLPARAMENTRYENTITY);
        this.getModel().deleteEntryData(BODYENTRYENTITY);
        this.getModel().deleteEntryData(RESPENTRYENTITY);
        CodeEdit requestEdit = (CodeEdit)this.getControl("requestedit");
        requestEdit.setText("");
        CodeEdit responseEdit = (CodeEdit)this.getControl("responseedit");
        responseEdit.setText("");
        Tab tap = (Tab)this.getControl("tabap");
        tap.activeTab("headertab");
    }

    private TreeNode initRootTreeNode() {
        TreeNode root = new TreeNode();
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8\u5e94\u7528", (String)"APIPRDPagePlugin_0", (String)"bos-open-formplugin", (Object[])new Object[0]));
        root.setId("8609760E-EF83-4775-A9FF-CCDEC7C0B689");
        root.setParentid("");
        root.setIsOpened(true);
        return root;
    }

    private Map<String, TreeNode> createAppNode() {
        DynamicObject[] apps = BusinessDataServiceHelper.load((String)"bos_devportal_bizapp", (String)"id,name,bizcloud", null);
        HashMap<String, TreeNode> nodeMap = new HashMap<String, TreeNode>(apps.length);
        for (DynamicObject app : apps) {
            String name = app.getString(DATA_FIELD_NAME);
            String id = app.getString(DATA_FIELD_ID);
            TreeNode node = new TreeNode("8609760E-EF83-4775-A9FF-CCDEC7C0B689", id, name, true);
            node.setIsOpened(false);
            node.setParentid("8609760E-EF83-4775-A9FF-CCDEC7C0B689");
            node.setLeaf(false);
            nodeMap.put(id, node);
        }
        return nodeMap;
    }

    private Map<String, DynamicObject> createLeafNode(Map<String, TreeNode> appNodeMap) {
        QFilter[] filters = new QFilter("urlformat", "not like", (Object)"/v2%").toArray();
        if (!"true".equals(ApiPluginUtil.getVisibleSysApi(this.getView()))) {
            filters = new QFilter("is_sys_api", "=", (Object)"0").and(new QFilter("urlformat", "not like", (Object)"/v2%")).toArray();
        }
        Map apiMap = BusinessDataServiceHelper.loadFromCache((String)ENTITY_OPEN_API_SERVICE, (String)SELECT_FIELD_API, (QFilter[])filters);
        HashMap<String, DynamicObject> notExistAppIdApis = new HashMap<String, DynamicObject>(16);
        for (Map.Entry entry : apiMap.entrySet()) {
            TreeNode parentNode;
            DynamicObject api = (DynamicObject)entry.getValue();
            DynamicObject app = api.getDynamicObject(DATA_FIELD_APP_ID);
            DynamicObject form = api.getDynamicObject(DATA_FIELD_OBJECT);
            if (StringUtils.isBlank((Object)app) && StringUtils.isNotBlank((Object)form)) {
                notExistAppIdApis.put(form.getString(DATA_FIELD_ID), api);
                continue;
            }
            if (StringUtils.isBlank((Object)app) || StringUtils.isBlank((CharSequence)app.getString(DATA_FIELD_ID)) || "0".equals(((DynamicObject)entry.getValue()).getString(DATA_FIELD_ENABLE)) || null == (parentNode = appNodeMap.get(app.getString(DATA_FIELD_ID)))) continue;
            TreeNode node = new TreeNode();
            node.setId(String.valueOf(entry.getKey()));
            String name = api.getString(DATA_FIELD_NAME);
            node.setText(StringUtils.isNotBlank((CharSequence)name) ? name : api.getString(DATA_FIELD_NUMBER));
            node.setLeaf(true);
            node.setParentid(parentNode.getId());
            parentNode.addChild(node);
        }
        return notExistAppIdApis;
    }

    private void createLeafNode(Map<String, TreeNode> appNodeMap, Map<String, DynamicObject> notExistAppIdApis) {
        if (CollectionUtils.isEmpty(notExistAppIdApis)) {
            return;
        }
        Map<String, String> bizAppMap = this.getBizAppByForms(notExistAppIdApis);
        for (Map.Entry<String, String> entry : bizAppMap.entrySet()) {
            String appId = entry.getValue();
            TreeNode parentNode = appNodeMap.get(appId);
            if (null == parentNode) continue;
            String formId = entry.getKey();
            DynamicObject api = notExistAppIdApis.get(formId);
            TreeNode node = new TreeNode();
            node.setId(api.getString(DATA_FIELD_ID));
            node.setLeaf(true);
            String name = api.getString(DATA_FIELD_NAME);
            node.setText(StringUtils.isNotBlank((CharSequence)name) ? name : api.getString(DATA_FIELD_NUMBER));
            node.setParentid(parentNode.getId());
            parentNode.addChild(node);
        }
    }

    private Map<String, String> getBizAppByForms(Map<String, DynamicObject> notExistAppIdApis) {
        QFilter filter = new QFilter(DATA_FIELD_FORM, "in", notExistAppIdApis.keySet());
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)ENTITY_UNIT_FORM, (String)SELECT_FIELD_FORM, (QFilter[])filter.toArray());
        if (CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> result = new HashMap<String, String>(dynamicObjects.size());
        for (DynamicObject dynamicObject : dynamicObjects) {
            String formId = dynamicObject.getString(DATA_FIELD_FORM);
            String appId = dynamicObject.getString(DATA_FIELD_BIZAPP);
            result.put(formId, appId);
        }
        return result;
    }

    private void putAppNodeToPageCache(Map<String, TreeNode> appNodeMap) {
        if (appNodeMap.isEmpty()) {
            return;
        }
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        HashMap<String, List> cache = new HashMap<String, List>(16);
        DynamicObjectCollection allBizApps = BizAppServiceHelp.getAllBizApps();
        for (DynamicObject app : allBizApps) {
            String appId = app.getString(DATA_FIELD_ID);
            String cloudId = app.getString(DATA_FIELD_CLOUD);
            List appNodes = cache.computeIfAbsent(cloudId, k -> new ArrayList(10));
            TreeNode node = appNodeMap.get(appId);
            if (null == node) continue;
            appNodes.add(node);
        }
        pageCache.put(PAGE_CACHE_KEY_CLOUD_APP_NODE, JSON.toJSONString(cache));
    }

    private void showApiBaseInfo(DynamicObject apiInfo) {
        if (null == apiInfo) {
            return;
        }
        Label apiNameLabel = (Label)this.getControl("apiname");
        Label creatorLabel = (Label)this.getControl("creator");
        Label apiDesLabel = (Label)this.getControl("apides");
        Label reqTypeLabel = (Label)this.getControl("reqtype");
        Label reqUrlLabel = (Label)this.getControl("requrl");
        String apiName = apiInfo.getString(DATA_FIELD_NAME);
        apiName = StringUtils.isBlank((CharSequence)apiName) ? apiInfo.getString(DATA_FIELD_NUMBER) : apiName;
        apiNameLabel.setText(apiName);
        DynamicObject creator = apiInfo.getDynamicObject("creator");
        creatorLabel.setText(Objects.isNull(creator) ? "" : creator.getString(DATA_FIELD_NAME));
        OrmLocaleValue discription = (OrmLocaleValue)apiInfo.get("discription");
        apiDesLabel.setText(discription.getLocaleValue());
        reqTypeLabel.setText(this.getHttpRequestType(apiInfo));
        reqUrlLabel.setText(this.getHttpUrl(apiInfo));
    }

    private String getHttpRequestType(DynamicObject apiInfo) {
        List comboItems = ((ComboProp)apiInfo.getDynamicObjectType().getProperty(KEY_HTTP_METHOD)).getComboItems();
        String type = apiInfo.getString(KEY_HTTP_METHOD);
        for (ValueMapItem item : comboItems) {
            if (!item.getValue().equals(type)) continue;
            return item.getName().toString();
        }
        return "";
    }

    private String getHttpUrl(DynamicObject apiInfo) {
        String url = apiInfo.getString("urlformat");
        String format = "%s/kapi%s";
        String cosmicUrl = UrlService.getDomainContextUrl();
        if (cosmicUrl != null && cosmicUrl.endsWith("/")) {
            format = "%skapi%s";
        }
        url = String.format(format, cosmicUrl, url);
        DynamicObjectCollection queryParams = apiInfo.getDynamicObjectCollection(URLPARAMENTRYENTITY);
        if (CollectionUtils.isEmpty((Collection)queryParams)) {
            return url;
        }
        StringBuilder urlBuilder = new StringBuilder(url).append("?");
        for (int i = 0; i < queryParams.size(); ++i) {
            DynamicObject param = (DynamicObject)queryParams.get(i);
            String name = param.getString("urlparamname");
            if (i != 0) {
                urlBuilder.append('&');
            }
            urlBuilder.append(name).append("={").append(name).append('}');
        }
        return urlBuilder.toString();
    }

    private void showApiRequestParamInfo(DynamicObject apiInfo) {
        DynamicObjectCollection urlParams;
        DynamicObjectCollection headers = apiInfo.getDynamicObjectCollection(HEADERENTRYENTITY);
        if (!CollectionUtils.isEmpty((Collection)headers)) {
            for (Object header : headers) {
                this.getModel().createNewEntryRow(HEADERENTRYENTITY, (DynamicObject)header);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(urlParams = apiInfo.getDynamicObjectCollection(URLPARAMENTRYENTITY)))) {
            for (Object param : urlParams) {
                String urlparammust = param.getString("urlparammust");
                int rowIndex = this.getModel().createNewEntryRow(URLPARAMENTRYENTITY, (DynamicObject)param);
                this.getModel().setValue("urlparammust", (Object)urlparammust, rowIndex);
            }
        }
        this.getView().setVisible(Boolean.FALSE, new String[]{BODYTAB});
        this.getView().setVisible(Boolean.FALSE, new String[]{REQBODYPANEL});
        this.initAnchorControl(false);
        if (HTTP_TYPE_POST.equalsIgnoreCase(this.getHttpRequestType(apiInfo))) {
            this.getView().setVisible(Boolean.TRUE, new String[]{BODYTAB});
            this.getView().setVisible(Boolean.TRUE, new String[]{REQBODYPANEL});
            this.initAnchorControl(true);
            DynamicObjectCollection requestBodies = apiInfo.getDynamicObjectCollection(BODYENTRYENTITY);
            if (!CollectionUtils.isEmpty((Collection)requestBodies)) {
                for (DynamicObject body : requestBodies) {
                    this.getModel().createNewEntryRow(BODYENTRYENTITY, body);
                }
                ((TreeEntryGrid)this.getView().getControl(BODYENTRYENTITY)).setCollapse(false);
                String pretty = ApiDataToJsonFormatUtils.getJsonFormatData(requestBodies, "paramtype", "paramname", "example");
                CodeEdit codeEdit = (CodeEdit)this.getControl("requestedit");
                codeEdit.setText(pretty);
            }
        }
    }

    private void showApiResponseInfo(DynamicObject apiInfo) {
        DynamicObjectCollection responses = apiInfo.getDynamicObjectCollection(RESPENTRYENTITY);
        if (CollectionUtils.isEmpty((Collection)responses)) {
            return;
        }
        Iterator iterator = responses.iterator();
        while (iterator.hasNext()) {
            DynamicObject response;
            response.set("respparammust", (Object)("1".equals((response = (DynamicObject)iterator.next()).get("respparammust")) ? ResManager.loadKDString((String)"\u662f", (String)"APIPRDPagePlugin_1", (String)"bos-open-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"APIPRDPagePlugin_2", (String)"bos-open-formplugin", (Object[])new Object[0])));
            this.getModel().createNewEntryRow(RESPENTRYENTITY, response);
        }
        ((TreeEntryGrid)this.getView().getControl(RESPENTRYENTITY)).setCollapse(false);
        String pretty = ApiDataToJsonFormatUtils.getJsonFormatData(responses, "respparamtype", "respparamname", "respexample");
        CodeEdit codeEdit = (CodeEdit)this.getControl("responseedit");
        codeEdit.setText(pretty);
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        if (!KEY_CLOUD_COMBO.equals(((Control)arg0.getSource()).getKey())) {
            return;
        }
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        String noteTreeJson = pageCache.get(PAGE_CACHE_KEY_CLOUD_APP_NODE);
        JSONObject json = JSON.parseObject((String)noteTreeJson);
        DynamicObjectCollection clouds = BizCloudServiceHelp.getAllBizClouds();
        ArrayList<String> items = new ArrayList<String>(clouds.size());
        for (DynamicObject cloud : clouds) {
            List treeNodes = JSONArray.parseArray((String)json.getString(cloud.getString(DATA_FIELD_ID)), TreeNode.class);
            if (CollectionUtils.isEmpty((Collection)treeNodes)) continue;
            items.add(cloud.getString(DATA_FIELD_ID));
        }
        arg0.addCustomQFilter(new QFilter("id", "in", items));
    }
}

