/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.open;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.OperationTypeCache;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.form.plugin.open.entity.FilterEntity;
import kd.bos.form.plugin.open.utils.RedisCacheUtils;
import kd.bos.form.plugin.utils.ApiDataToJsonFormatUtils;
import kd.bos.lang.Lang;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.Plugin;
import kd.bos.mvc.base.BaseModel;
import kd.bos.mvc.bill.BillModel;
import kd.bos.openapi.base.util.LocalCacheUtil;
import kd.bos.openapi.base.util.LocalCacheUtils;
import kd.bos.openapi.common.model.OpenApiData;
import kd.bos.openapi.form.util.ApiPluginUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.session.SystemPropertyUtils;

public class APIServicePlugin
extends AbstractBillPlugIn
implements CellClickListener {
    private static String[] SIMPLECOMPARE = new String[]{"=", "STARTS_WITH", "CONTAINS", "ENDS_WITH", ">", ">=", "<", "<=", "<>", "NOT_STARTS_WITH", "NOT_CONTAINS", "NOT_ENDS_WITH", "IS_NULL", "IS_NOT_NULL"};
    private static String[] INCOMPARE = new String[]{"in", "not in"};
    private static final String RESPPREVIEW = "resppreview";
    private static final String ADDRESPFROMOBJ = "addrespfromobj";
    private static final String QUERYPARAM = "queryparam";
    private static final String BODYTAB = "bodytab";
    private static final String QUERY_FILTER_TAB = "queryfiltertab";
    private static final Log log = LogFactory.getLog(APIServicePlugin.class);
    private static final String KEY_URLFORMAT = "urlformat";
    private static final String KEY_PLUGIN = "plugin";
    private static final String FORM_ID_OPEN_APISERIVCE_GUIDE = "open_apiserivce_guide_new";
    private static final String FORM_ID_API_CHOOSE_FIELD_PAGE = "api_choosefieldpage";
    private static final String KEY_NAME = "name";
    private static final String KEY_OPERATION = "operation";
    private static final String KEY_BIZOBJECT = "bizobject";
    private static final String KEY_ALLOWGUEST = "allowguest";
    private static final String KEY_CUSTOMMETHOD = "custommethod";
    private static final String KEY_NUMBER = "number";
    private static final String KEY_APISERVICETYPE = "apiservicetype";
    private static final String KEY_APPID = "appid";
    private static final String FORMID_API_SERVICE = "open_apiservice";
    private static final String KEY_HEADER_CONTENT_TYPE = "contenttype";
    private static final String KEY_HEADER_ENTRY = "headerentryentity";
    private static final String KEY_BODY_ENTRY = "bodyentryentity";
    private static final String KEY_URL_ENTRY = "urlparamentryentity";
    private static final String KEY_FILTER_ENTRY = "filter_entity";
    private static final String KEY_RESPONSE_ENTRY = "respentryentity";
    private static final String NUMBER = "number";
    private static final String API_NUMBER = "api_number";
    private static final String API_USERS = "api_users";
    private static final String OPEN_APIAUTHORIZE = "open_apiauthorize";
    private static final String BOS_FORM_BUSINESS = "bos-form-business";
    private static final String BOS_OPEN_FORMPLUGIN = "bos-open-formplugin";
    private static final String QUERY = "query";
    private static final String FILTER = "filter";
    private static final String HEADERNAME = "headername";
    private static final String RESPPARAMNAME = "respparamname";
    private static final String URLPARAMNAME = "urlparamname";
    private static final String PARAMNAME = "paramname";
    private static final String IS_ENABLE = "1";
    private static final String HIDE_INPUT_SELECT_PARAM = "selectparam";
    private static final String HIDE_INPUT_FILTER_PARAM = "filterparam";
    private static final String HIDE_INPUT_MUST_PARAM = "mustparam";
    private static final String KSQL_FILTER = "ksqlfilter";
    private static final String QUEYR_KSQL = "query_ksql";
    private static final String HTTPMETHOD = "httpmethod";
    private static final String DELETE_OPERATION = "delete";
    private static final String LOAD_OPERATION = "load";
    private static final String SAVE = "save";
    private static final String KEY_IS_ONLY_THIRDAPP_AUTH = "isonlythirdappauth";
    private static Map<Lang, List<ComboItem>> EMBED_OPEATION = new HashMap<Lang, List<ComboItem>>();

    private List<ComboItem> getCommonOpItem() {
        ArrayList<ComboItem> items = new ArrayList<ComboItem>();
        items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u52a0\u8f7d", (String)"APIServicePlugin_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0])), LOAD_OPERATION));
        items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u67e5\u8be2", (String)"APIServicePlugin_1", (String)BOS_FORM_BUSINESS, (Object[])new Object[0])), QUERY));
        items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5220\u9664", (String)"APIServicePlugin_2", (String)BOS_FORM_BUSINESS, (Object[])new Object[0])), DELETE_OPERATION));
        items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"APIServicePlugin_3", (String)BOS_FORM_BUSINESS, (Object[])new Object[0])), SAVE));
        items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6279\u91cf\u4fdd\u5b58", (String)"APIServicePlugin_4", (String)BOS_FORM_BUSINESS, (Object[])new Object[0])), "batchsave"));
        items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u8ffd\u52a0\u5206\u5f55", (String)"APIServicePlugin_13", (String)BOS_FORM_BUSINESS, (Object[])new Object[0])), "appendentryrows"));
        items.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5220\u9664\u5206\u5f55", (String)"APIServicePlugin_39", (String)BOS_FORM_BUSINESS, (Object[])new Object[0])), "deleteentryrows"));
        return items;
    }

    public void initialize() {
        super.initialize();
        String login_api_support_anonymous = SystemPropertyUtils.getProptyByTenant((String)"login_api_support_anonymous", (String)RequestContext.get().getTenantId());
        if (login_api_support_anonymous != null && "true".equals(login_api_support_anonymous)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_ALLOWGUEST});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_ALLOWGUEST});
        }
        String api_AllowKVQuery = System.getProperty("api.AllowKVQuery");
        if ("true".equals(api_AllowKVQuery)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{QUERY_FILTER_TAB});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{QUERY_FILTER_TAB});
        }
        Tab tab = (Tab)this.getControl("tabap");
        tab.addItemClickListener((ItemClickListener)this);
        tab.addTabSelectListener(new TabSelectListener(){

            public void tabSelected(TabSelectEvent event) {
                if (APIServicePlugin.QUERY_FILTER_TAB.equals(event.getTabKey())) {
                    APIServicePlugin.this.setFilterValueCombo();
                }
            }
        });
    }

    private void setFilterValueCombo() {
        DynamicObjectCollection inputList = this.getModel().getDataEntity(true).getDynamicObjectCollection(KEY_URL_ENTRY);
        ComboEdit comboFilterValue = (ComboEdit)this.getView().getControl("filter_value");
        ArrayList<String> inputFieldList = new ArrayList<String>(inputList.size());
        if (!CollectionUtils.isEmpty((Collection)inputList)) {
            ArrayList<ComboItem> items = new ArrayList<ComboItem>(16);
            for (DynamicObject filter : inputList) {
                String inputField = filter.getString(URLPARAMNAME);
                ComboItem item = new ComboItem();
                item.setCaption(new LocaleString(inputField));
                item.setValue(inputField);
                items.add(item);
                inputFieldList.add(inputField);
            }
            comboFilterValue.setComboItems(items);
        }
        int rows = this.getModel().getEntryRowCount(KEY_FILTER_ENTRY);
        for (int i = 0; i < rows; ++i) {
            String filter_value = (String)this.getModel().getValue("filter_value", i);
            if (inputFieldList.contains(filter_value)) continue;
            this.getModel().setValue("filter_value", null, i);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid filterEntries = (EntryGrid)this.getView().getControl(KEY_FILTER_ENTRY);
        this.addClickListeners(new String[]{KEY_PLUGIN, "filter_column"});
        this.addItemClickListeners(new String[]{"tbmain"});
        if (filterEntries == null) {
            return;
        }
        filterEntries.addCellClickListener((CellClickListener)this);
    }

    public void itemClick(ItemClickEvent evt) {
        boolean isAddParamFromBizObj;
        String itemKey = evt.getItemKey();
        if ("bar_save".equals(evt.getItemKey())) {
            Object apiType = this.getView().getFormShowParameter().getCustomParam(KEY_APISERVICETYPE);
            if (apiType == null) {
                apiType = this.getModel().getValue(KEY_APISERVICETYPE);
            }
            if ("0".equals(apiType) || "2".equals(apiType)) {
                DynamicObjectCollection apiUser = (DynamicObjectCollection)this.getModel().getValue(API_USERS);
                Object[] objects = new DynamicObject[1];
                Object[] pks = new Object[1];
                MainEntityType type = EntityMetadataCache.getDataEntityType((String)OPEN_APIAUTHORIZE);
                String apiNumber = (String)this.getModel().getValue("number");
                QFilter[] filters = new QFilter[]{new QFilter(API_NUMBER, "=", (Object)apiNumber)};
                DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((String)OPEN_APIAUTHORIZE, (QFilter[])filters);
                if (object != null) {
                    pks[0] = object.getPkValue();
                }
                object = new DynamicObject((DynamicObjectType)type);
                object.set(API_NUMBER, (Object)apiNumber);
                object.set(API_USERS, (Object)apiUser);
                objects[0] = object;
                BusinessDataWriter.delete((IDataEntityType)type, (Object[])pks);
                BusinessDataWriter.save((IDataEntityType)type, (Object[])objects);
            }
        }
        String operationKey = evt.getOperationKey();
        boolean isAddBodyFromBizObj = BODYTAB.equals(itemKey) && "api_addformobj".equals(operationKey);
        boolean bl = isAddParamFromBizObj = QUERYPARAM.equals(itemKey) && "addqueryfromobj".equals(operationKey);
        if (isAddParamFromBizObj || isAddBodyFromBizObj) {
            this.showChooseFieldForm(null);
        }
    }

    private String getMustHideParam() {
        DynamicObjectCollection urlparamentryentity = this.getModel().getEntryEntity(KEY_URL_ENTRY);
        if (!urlparamentryentity.isEmpty()) {
            ArrayList<String> mustParam = new ArrayList<String>();
            for (DynamicObject object : urlparamentryentity) {
                mustParam.add((String)object.get(URLPARAMNAME));
            }
            if (!mustParam.isEmpty()) {
                return String.join((CharSequence)",", mustParam.toArray(new String[mustParam.size()]));
            }
        }
        return "";
    }

    private String getFilterHideParam() {
        DynamicObjectCollection filterEntity = this.getModel().getEntryEntity(KEY_FILTER_ENTRY);
        if (filterEntity.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < filterEntity.size(); ++i) {
            DynamicObjectCollection urlEntity;
            Map paramTypeMap;
            boolean lastFlag = i == filterEntity.size() - 1;
            DynamicObject dynamicObject = (DynamicObject)filterEntity.get(i);
            String filterColumn = (String)dynamicObject.get("filter_column");
            if (StringUtils.isEmpty((CharSequence)filterColumn)) continue;
            String compare = (String)dynamicObject.get("filter_compare");
            String filter_link = (String)dynamicObject.get("filter_link");
            if (!lastFlag && StringUtils.isEmpty((CharSequence)filter_link)) {
                throw new KDException(ResManager.loadKDString((String)"\u5fc5\u987b\u5305\u542b\u903b\u8f91\u8fde\u63a5\u7b26 AND\u6216\u8005OR\u3002", (String)"APIServicePlugin_37", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            }
            String filterValueName = dynamicObject.getString("filter_value");
            if (!compare.equals("IS_NULL") && !compare.equals("IS_NOT_NULL") && StringUtils.isEmpty((CharSequence)filterValueName)) {
                throw new KDException(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6bd4\u8f83\u53d8\u91cf\u3002", (String)"APIServicePlugin_38", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            }
            if (compare.equals("=") && (paramTypeMap = this.dealUrlEntity(urlEntity = this.getModel().getEntryEntity(KEY_URL_ENTRY))).get(filterValueName).equals("Date")) {
                sb.append('(').append(filterColumn).append(">=").append('[').append(filterValueName).append(']').append(" AND ").append(filterColumn).append("<").append('[').append(filterValueName).append(']').append(')').append(' ');
                if (lastFlag) continue;
                sb.append(filter_link).append(' ');
                continue;
            }
            sb = APIServicePlugin.doSwitchCompare(dynamicObject, filterValueName, compare, filterColumn, lastFlag, sb);
        }
        return sb.toString();
    }

    private Map dealUrlEntity(DynamicObjectCollection getEntity) {
        HashMap<String, String> typeMap = new HashMap<String, String>();
        if (!getEntity.isEmpty()) {
            for (int i = 0; i < getEntity.size(); ++i) {
                DynamicObject object = (DynamicObject)getEntity.get(i);
                String paramType = (String)object.get("urlparamtype");
                String paramName = (String)object.get(URLPARAMNAME);
                typeMap.put(paramName, paramType);
            }
        }
        return typeMap;
    }

    private static StringBuilder doSwitchCompare(DynamicObject entity, String value, String compare, String filter_column, boolean lastFlag, StringBuilder sb) {
        String filter_left_bracket = (String)entity.get("filter_left_bracket");
        String filter_right_bracket = (String)entity.get("filter_right_bracket");
        String filter_link = (String)entity.get("filter_link");
        if (Arrays.asList(SIMPLECOMPARE).contains(compare) || Arrays.asList(INCOMPARE).contains(compare)) {
            boolean isaddEnd = false;
            boolean isaddStart = false;
            boolean isaddStartAndEnd = false;
            boolean isAppendValue = true;
            if ("STARTS_WITH".equals(compare)) {
                compare = " like ";
                isaddEnd = true;
            } else if ("CONTAINS".equals(compare)) {
                compare = " like ";
                isaddStartAndEnd = true;
            } else if ("ENDS_WITH".equals(compare)) {
                compare = " like ";
                isaddStart = true;
            } else if ("NOT_STARTS_WITH".equals(compare)) {
                compare = " not like ";
                isaddEnd = true;
            } else if ("NOT_CONTAINS".equals(compare)) {
                compare = " not like ";
                isaddStartAndEnd = true;
            } else if ("NOT_ENDS_WITH".equals(compare)) {
                compare = " not like ";
                isaddStart = true;
            } else if ("IS_NULL".equals(compare)) {
                isAppendValue = false;
                compare = " is null ";
            } else if ("IS_NOT_NULL".equals(compare)) {
                isAppendValue = false;
                compare = " is not null ";
            }
            if (!StringUtils.isEmpty((CharSequence)filter_left_bracket)) {
                sb.append(filter_left_bracket);
            }
            if (!StringUtils.isEmpty((CharSequence)filter_column)) {
                sb.append(filter_column);
            }
            if (!StringUtils.isEmpty((CharSequence)compare)) {
                sb.append(' ');
                sb.append(compare);
                sb.append(' ');
            }
            if (" is null ".equals(compare) || " is not null ".equals(compare)) {
                sb.append(" AND ").append(filter_column).append(" !=''");
            }
            if ("in".equals(compare) || "not in".equals(compare)) {
                sb.append('(');
            }
            if (!StringUtils.isEmpty((CharSequence)value) && isAppendValue) {
                sb.append('[');
                if (isaddStart || isaddStartAndEnd) {
                    sb.append('%');
                }
                sb.append(value);
                if (isaddEnd || isaddStartAndEnd) {
                    sb.append('%');
                }
                sb.append(']');
            }
            if ("in".equals(compare) || "not in".equals(compare)) {
                sb.append(')');
            }
            if (!StringUtils.isEmpty((CharSequence)filter_right_bracket)) {
                sb.append(filter_right_bracket);
            }
            if (lastFlag && !StringUtils.isEmpty((CharSequence)filter_link)) {
                filter_link = "";
            }
            sb.append(' ').append(StringUtils.isEmpty((CharSequence)filter_link) ? "" : filter_link).append(' ');
        }
        return sb;
    }

    private String getSelectHideParam() {
        DynamicObjectCollection responseEntity = this.getModel().getEntryEntity(KEY_RESPONSE_ENTRY);
        if (responseEntity.isEmpty()) {
            return "";
        }
        ArrayList<String> paramSet = new ArrayList<String>(responseEntity.size());
        for (int i = 0; i < responseEntity.size(); ++i) {
            DynamicObject object = (DynamicObject)responseEntity.get(i);
            paramSet.add((String)object.get(RESPPARAMNAME));
        }
        if (!paramSet.isEmpty()) {
            return String.join((CharSequence)",", paramSet.toArray(new String[paramSet.size()]));
        }
        return "";
    }

    private void showChooseFieldForm(String billLocation) {
        Object app = this.getModel().getValue(KEY_APPID);
        Object apiType = this.getView().getFormShowParameter().getCustomParam(KEY_APISERVICETYPE);
        if (apiType == null) {
            apiType = this.getModel().getValue(KEY_APISERVICETYPE);
        }
        ListShowParameter fsp = this.getListShowParameter(billLocation);
        if ("0".equals(apiType)) {
            Object bizObj = this.getModel().getValue(KEY_BIZOBJECT);
            if (Objects.isNull(bizObj) || Objects.isNull(app)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u4e1a\u52a1\u5bf9\u8c61\u201d\u5b57\u6bb5\u4fe1\u606f\u6216\u8005\u201c\u6240\u5c5e\u5e94\u7528\u201d\u4e3a\u7a7a\uff0c\u8bf7\u5148\u5f55\u5165\u3002", (String)"APIServicePlugin_26", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                return;
            }
            fsp.setCustomParam("apiType", (Object)"0");
            fsp.setCustomParam("entityId", ((DynamicObject)bizObj).getPkValue());
            this.getView().showForm((FormShowParameter)fsp);
            return;
        }
        if ("2".equals(apiType)) {
            if (Objects.isNull(app)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u201c\u6240\u5c5e\u5e94\u7528\u201d\u5b57\u6bb5\u4fe1\u606f\u3002", (String)"APIServicePlugin_27", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                return;
            }
            fsp.setFormId("bos_treelistf7");
            fsp.setCustomParam("apiType", (Object)"2");
            fsp.setCustomParam("appId", ((DynamicObject)app).getPkValue());
            this.getView().showForm((FormShowParameter)fsp);
        }
    }

    private ListShowParameter getListShowParameter(String billPosition) {
        ListShowParameter fsp = ShowFormHelper.createShowListForm((String)FORM_ID_API_CHOOSE_FIELD_PAGE, (boolean)true, (int)0, (boolean)true);
        fsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, FORM_ID_API_CHOOSE_FIELD_PAGE));
        fsp.getOpenStyle().setShowType(ShowType.Modal);
        fsp.setCustomParam("billPosition", (Object)billPosition);
        fsp.setHasRight(true);
        return fsp;
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String appId = (String)formShowParameter.getCustomParam(KEY_APPID);
        if (StringUtils.isNotBlank((CharSequence)appId)) {
            this.getModel().setValue(KEY_APPID, (Object)appId);
        }
        Object apiServiceType = formShowParameter.getCustomParam(KEY_APISERVICETYPE);
        this.getView().setVisible(Boolean.FALSE, new String[]{"bar_apiauthorize"});
        if (StringUtils.isNotBlank((Object)apiServiceType)) {
            this.getModel().setValue(KEY_APISERVICETYPE, apiServiceType);
            String urlformat = "";
            if (IS_ENABLE.equals(apiServiceType)) {
                this.getModel().setValue(HTTPMETHOD, (Object)1);
                urlformat = "/ai/do";
            } else if ("0".equals(apiServiceType)) {
                urlformat = "/sys/{formId}/{operationId}";
            } else if ("2".equals(apiServiceType)) {
                urlformat = "/app/{appId}/{servicename}";
            }
            this.getModel().setValue(KEY_URLFORMAT, (Object)urlformat);
        }
    }

    public void afterBindData(EventObject e) {
        TreeEntryGrid respGrid;
        FieldEdit fieldEdit;
        String apiServiceType = (String)this.getModel().getValue(KEY_APISERVICETYPE);
        if ("0".equals(apiServiceType)) {
            fieldEdit = (FieldEdit)this.getControl(KEY_BIZOBJECT);
            fieldEdit.setMustInput(true);
            fieldEdit = (FieldEdit)this.getControl(KEY_OPERATION);
            fieldEdit.setMustInput(true);
        } else {
            fieldEdit = (FieldEdit)this.getControl(KEY_APPID);
            fieldEdit.setMustInput(true);
        }
        this.showUrl();
        String apiSupportAnonymous = SystemPropertyUtils.getProptyByTenant((String)"login_api_support_anonymous", (String)RequestContext.get().getTenantId());
        this.getView().setVisible(Boolean.valueOf(apiSupportAnonymous), new String[]{KEY_ALLOWGUEST});
        TreeEntryGrid bodyGrid = (TreeEntryGrid)this.getView().getControl(KEY_BODY_ENTRY);
        if (null != bodyGrid) {
            bodyGrid.setCollapse(false);
        }
        if (null != (respGrid = (TreeEntryGrid)this.getView().getControl(KEY_RESPONSE_ENTRY))) {
            respGrid.setCollapse(false);
        }
        if ("0".equals(apiServiceType) || "2".equals(apiServiceType)) {
            this.setApiUsers();
        }
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("heightLimit", Boolean.FALSE);
        this.getView().updateControlMetadata(KEY_HEADER_ENTRY, map);
        this.getView().updateControlMetadata(KEY_URL_ENTRY, map);
        this.getView().updateControlMetadata(KEY_BODY_ENTRY, map);
        this.getView().updateControlMetadata(KEY_RESPONSE_ENTRY, map);
        this.updateContentTypeToHeaderEntry(null, apiServiceType);
        if (!IS_ENABLE.equals(apiServiceType)) {
            this.initJsonBody();
        }
    }

    private void setApiUsers() {
        String apiNumber = (String)this.getModel().getValue("number");
        if (StringUtils.isBlank((CharSequence)apiNumber)) {
            return;
        }
        QFilter[] filters = new QFilter[]{new QFilter(API_NUMBER, "=", (Object)apiNumber)};
        DynamicObject object = BusinessDataServiceHelper.loadSingleFromCache((String)OPEN_APIAUTHORIZE, (QFilter[])filters);
        if (object != null) {
            DynamicObjectCollection users = object.getDynamicObjectCollection(API_USERS);
            DynamicObjectCollection value = new DynamicObjectCollection();
            if (users != null) {
                for (DynamicObject user : users) {
                    if (user.get("fbasedataid") == null || user.getLong("fbasedataid_id") == 0L) continue;
                    value.add((Object)user);
                }
            }
            if (value != null && value.size() > 0) {
                this.getModel().setValue(API_USERS, (Object)users);
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        this.getModel().setDataChanged(false);
    }

    public void afterLoadData(EventObject e) {
        DynamicObject bizObject;
        String apiServiceType = (String)this.getModel().getValue(KEY_APISERVICETYPE);
        if ("0".equals(apiServiceType) && (bizObject = (DynamicObject)this.getModel().getValue(KEY_BIZOBJECT)) != null) {
            String entityNumber = bizObject.getPkValue().toString();
            ComboEdit opCombo = (ComboEdit)this.getControl(KEY_OPERATION);
            opCombo.setComboItems(this.getEntityOpComboItem(entityNumber));
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{"number"});
        ApiPluginUtil.visitButtonControl(this.getModel(), this.getView());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        String apiServiceType = (String)this.getModel().getValue(KEY_APISERVICETYPE);
        String urlFormat = (String)this.getModel().getValue(KEY_URLFORMAT);
        this.urlFormChange(apiServiceType, propName, urlFormat);
        if (KEY_BIZOBJECT.equals(propName)) {
            this.updateBizObject(apiServiceType);
            this.initJsonBody();
            return;
        } else if (KEY_IS_ONLY_THIRDAPP_AUTH.equalsIgnoreCase(propName)) {
            this.clearGustApiCache();
            ApiPluginUtil.visitButtonControl(this.getModel(), this.getView());
            return;
        } else if (KEY_ALLOWGUEST.equals(propName)) {
            this.clearGustApiCache();
            ApiPluginUtil.allowguestControl(this.getModel(), this.getView());
            return;
        } else if (KEY_HEADER_CONTENT_TYPE.equals(propName)) {
            String contentTypeValue = this.getContentTypeValue(e);
            this.updateContentTypeToHeaderEntry(contentTypeValue, apiServiceType);
            return;
        } else {
            if (KEY_OPERATION.equals(propName)) {
                String newValue = (String)e.getChangeSet()[0].getNewValue();
                this.getModel().deleteEntryData(KEY_HEADER_ENTRY);
                IDataModel model = (IDataModel)this.getView().getService(IDataModel.class);
                this.setHeader(model);
                String httpmethod_value = (String)this.getView().getModel().getValue(HTTPMETHOD);
                DynamicObject bizObject = (DynamicObject)this.getModel().getValue(KEY_BIZOBJECT);
                if (!DELETE_OPERATION.equals(newValue) && !LOAD_OPERATION.equals(newValue) && !QUERY.equals(newValue) && !SAVE.equals(newValue)) return;
            }
            if (HTTPMETHOD.equals(propName)) {
                this.initJsonBody();
                return;
            } else {
                if (!"isksql".equals(propName)) return;
                Boolean isksql = (Boolean)this.getModel().getValue("isksql");
                FieldEdit fieldEdit = (FieldEdit)this.getView().getControl("isksql");
                if (isksql.booleanValue()) {
                    fieldEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"KSQL\u6a21\u5f0f", (String)"APIServicePlugin_0", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0])));
                    this.getView().setVisible(Boolean.FALSE, new String[]{"addqueryfilter", "deletequeryfilter", "insertqueryfilter"});
                    return;
                } else {
                    fieldEdit.setCaption(new LocaleString(ResManager.loadKDString((String)"\u666e\u901a\u6a21\u5f0f", (String)"APIServicePlugin_1", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0])));
                    this.getView().setVisible(Boolean.TRUE, new String[]{"addqueryfilter", "deletequeryfilter", "insertqueryfilter"});
                }
            }
        }
    }

    private void clearGustApiCache() {
        CacheConfigInfo localConfig = new CacheConfigInfo();
        localConfig.setMaxItemSize(5000);
        localConfig.setTimeout(600);
        LocalCacheUtils.remove((String)RequestContext.get().getAccountId());
        LocalMemoryCache localMemoryCache1OpenAPI = CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache("OpenAPI".concat(RequestContext.get().getAccountId()), "AllowGuestApi", localConfig);
        localMemoryCache1OpenAPI.clear();
    }

    private IDataModel setHeader(IDataModel model) {
        int contentTypeRow = model.createNewEntryRow(KEY_HEADER_ENTRY);
        model.setValue(HEADERNAME, (Object)"Content-Type", contentTypeRow);
        String key_header_content_type = (String)this.getView().getModel().getValue(KEY_HEADER_CONTENT_TYPE);
        if (StringUtils.isEmpty((CharSequence)key_header_content_type)) {
            this.getView().getModel().setValue(KEY_HEADER_CONTENT_TYPE, (Object)"0");
            model.setValue("headervalue", (Object)"application/json", contentTypeRow);
        } else {
            model.setValue("headervalue", (Object)("0".equals(key_header_content_type) ? "application/json" : "text/json"), contentTypeRow);
        }
        model.setValue("headerdes", (Object)ResManager.loadKDString((String)"\u5185\u5bb9\u683c\u5f0f", (String)"APIServicePlugin_22", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), contentTypeRow);
        int accesstokenRow = model.createNewEntryRow(KEY_HEADER_ENTRY);
        model.setValue(HEADERNAME, (Object)"accesstoken", accesstokenRow);
        model.setValue("headervalue", (Object)ResManager.loadKDString((String)"\u83b7\u53d6\u7684accesstoken\u503c", (String)"APIServicePlugin_21", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), accesstokenRow);
        model.setValue("headerdes", (Object)ResManager.loadKDString((String)"\u8bf7\u6c42\u4ee4\u724c", (String)"APIServicePlugin_23", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), accesstokenRow);
        return model;
    }

    private void initJsonBody() {
        String apiServiceType = (String)this.getModel().getValue(KEY_APISERVICETYPE);
        if (IS_ENABLE.equals(apiServiceType)) {
            return;
        }
        DynamicObject bizObject = (DynamicObject)this.getModel().getValue(KEY_BIZOBJECT);
        String key_operation_value = (String)this.getView().getModel().getValue(KEY_OPERATION);
        this.getModel().deleteEntryData(KEY_HEADER_ENTRY);
        IDataModel model = (IDataModel)this.getView().getService(IDataModel.class);
        this.setHeader(model);
        String httpmethod_value = (String)this.getView().getModel().getValue(HTTPMETHOD);
        if (bizObject != null && StringUtils.isNotBlank((CharSequence)key_operation_value) && DELETE_OPERATION.equals(key_operation_value) || bizObject != null && StringUtils.isNotBlank((CharSequence)key_operation_value) && LOAD_OPERATION.equals(key_operation_value) || bizObject != null && StringUtils.isNotBlank((CharSequence)key_operation_value) && QUERY.equals(key_operation_value) || bizObject == null || !StringUtils.isNotBlank((CharSequence)key_operation_value) || SAVE.equals(key_operation_value)) {
            // empty if block
        }
    }

    private void updateBizObject(String apiServiceType) {
        DynamicObject bizObject = (DynamicObject)this.getModel().getValue(KEY_BIZOBJECT);
        if (bizObject == null) {
            return;
        }
        String formNumber = bizObject.getString("number");
        QFilter[] filters = new QFilter[]{new QFilter("bizobj.number", "=", (Object)formNumber)};
        DynamicObject[] apps = BusinessDataServiceHelper.load((String)"perm_bizobjapp", (String)"bizapp", (QFilter[])filters);
        if (apps != null && apps.length > 0 && apps[0].get("bizapp.id") != null) {
            this.getModel().setValue(KEY_APPID, apps[0].get("bizapp.id"));
        } else {
            DynamicObject app = (DynamicObject)bizObject.get("bizappid");
            this.getModel().setValue(KEY_APPID, (Object)app);
        }
        if ("0".equals(apiServiceType)) {
            String entityNumber = bizObject.getPkValue().toString();
            ComboEdit opCombo = (ComboEdit)this.getControl(KEY_OPERATION);
            opCombo.setComboItems(this.getEntityOpComboItem(entityNumber));
        }
    }

    private void updateContentTypeToHeaderEntry(String contentTypeValue, String apiServiceType) {
        if (IS_ENABLE.equals(apiServiceType)) {
            return;
        }
        boolean isInsertHeader = true;
        int rowIndex = 0;
        DynamicObjectCollection entries = this.getModel().getEntryEntity(KEY_HEADER_ENTRY);
        for (DynamicObject entry : entries) {
            String name = entry.getString(HEADERNAME);
            String value = entry.getString("headervalue");
            if ("Content-Type".equalsIgnoreCase(name)) {
                this.getModel().setValue("headervalue", (Object)(contentTypeValue == null ? value : contentTypeValue), rowIndex);
                isInsertHeader = false;
                break;
            }
            ++rowIndex;
        }
        if (isInsertHeader) {
            IDataModel model = (IDataModel)this.getView().getService(IDataModel.class);
            int row = model.createNewEntryRow(KEY_HEADER_ENTRY);
            model.setValue(HEADERNAME, (Object)"Content-Type", row);
            model.setValue("headervalue", (Object)(contentTypeValue == null ? "application/json" : contentTypeValue), row);
        }
    }

    private String getContentTypeValue(PropertyChangedArgs e) {
        Object newValue = e.getChangeSet()[0].getNewValue();
        List comboItems = ((ComboProp)this.getModel().getProperty(KEY_HEADER_CONTENT_TYPE)).getComboItems();
        for (ValueMapItem comboItem : comboItems) {
            String itemValue = comboItem.getValue();
            if (!itemValue.equals(newValue)) continue;
            return comboItem.getName().getLocaleValue();
        }
        return null;
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        if (KEY_PLUGIN.equals(control.getKey())) {
            String bizAppId;
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("ide_plugins");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "pluginRegister"));
            String plugins = (String)this.getModel().getValue(KEY_PLUGIN);
            DynamicObject app = (DynamicObject)this.getModel().getValue(KEY_APPID);
            if (StringUtils.isNotBlank((Object)app) && StringUtils.isNotBlank((CharSequence)(bizAppId = app.getString("id")))) {
                formShowParameter.setCustomParam("bizappid", (Object)bizAppId);
                formShowParameter.setCustomParam("scriptfiltertype", (Object)"webapi");
            }
            if (this.isUseNewVersionPlugin() && StringUtils.isNotBlank((CharSequence)plugins)) {
                formShowParameter.setCustomParam("value", SerializationUtils.fromJsonString((String)plugins, List.class));
            }
            this.getView().showForm(formShowParameter);
        } else if ("filter_column".equals(control.getKey())) {
            this.showChooseFieldForm(null);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if ("pluginRegister".equals(actionId)) {
            Map pluginInfos = (Map)closedCallBackEvent.getReturnData();
            if (pluginInfos != null && !pluginInfos.isEmpty()) {
                List pluginList = (List)pluginInfos.get("value");
                this.getModel().setValue(KEY_PLUGIN, (Object)SerializationUtils.toJsonString((Object)pluginList));
            }
        } else if (FORM_ID_API_CHOOSE_FIELD_PAGE.equals(actionId)) {
            this.fillParamFromEntity(closedCallBackEvent);
        }
    }

    private void fillParamFromEntity(ClosedCallBackEvent e) {
        Object retData = e.getReturnData();
        if (retData instanceof HashMap) {
            HashMap param = (HashMap)retData;
            ListSelectedRowCollection selectRows = (ListSelectedRowCollection)param.get("selectRow");
            DynamicObjectCollection entries = this.getModel().getEntryEntity(KEY_RESPONSE_ENTRY);
            HashSet<String> existParams = new HashSet<String>(entries.size());
            Long pid = this.analysisExistParams(entries, existParams, KEY_RESPONSE_ENTRY, RESPPARAMNAME);
            for (ListSelectedRow row : selectRows) {
                String number = row.getNumber();
                if (existParams.contains(number)) continue;
                DynamicObject entry = this.getEntryDynamicObject(KEY_RESPONSE_ENTRY, row, number, "response", pid, null);
                this.getModel().createNewEntryRow(KEY_RESPONSE_ENTRY, entry);
            }
        } else if (retData instanceof ListSelectedRowCollection) {
            ListSelectedRowCollection returnData = (ListSelectedRowCollection)retData;
            Tab tab = (Tab)this.getControl("tabap");
            String currentTab = tab.getCurrentTab();
            if (QUERYPARAM.equals(currentTab)) {
                this.fillQueryFormEntity(returnData);
            } else if (BODYTAB.equals(currentTab)) {
                this.fillBodyFormEntity(returnData);
            } else if (QUERY_FILTER_TAB.equals(currentTab)) {
                this.fillFilterFormEntity(returnData);
            }
        }
    }

    private void fillFilterFormEntity(ListSelectedRowCollection returnData) {
        DynamicObjectCollection entries = this.getModel().getEntryEntity(KEY_FILTER_ENTRY);
        int row = this.getModel().getEntryCurrentRowIndex(KEY_FILTER_ENTRY);
        LinkedList<FilterEntity> filterEntityList = new LinkedList<FilterEntity>();
        for (Object entry : entries) {
            if (StringUtils.isEmpty((CharSequence)entry.getString("filter_column"))) continue;
            filterEntityList.add(new FilterEntity(entry.getString("filter_left_bracket"), entry.getString("filter_column"), entry.getString("filter_label"), entry.getString("filter_compare"), entry.getString("filter_value"), entry.getString("filter_right_bracket"), entry.getString("filter_link")));
        }
        int rowcount = row;
        for (ListSelectedRow selectedRow : returnData) {
            String number = selectedRow.getNumber();
            filterEntityList.add(rowcount, new FilterEntity("", number, "", "", "", "", ""));
            ++rowcount;
        }
        IDataModel model = (IDataModel)this.getView().getService(IDataModel.class);
        model.deleteEntryData(KEY_FILTER_ENTRY);
        for (int i = 0; i < filterEntityList.size(); ++i) {
            this.createEntry(KEY_FILTER_ENTRY, (FilterEntity)filterEntityList.get(i), i);
        }
    }

    private void createEntry(String entryKey, FilterEntity entity, int rowIndex) {
        IDataModel model = (IDataModel)this.getView().getService(IDataModel.class);
        if (model != null) {
            model.createNewEntryRow(entryKey);
            if (StringUtils.isNotEmpty((CharSequence)entity.getFilterLeftBracket())) {
                model.setValue("filter_left_bracket", (Object)entity.getFilterLeftBracket(), rowIndex);
            }
            if (StringUtils.isNotEmpty((CharSequence)entity.getFilterColumn())) {
                model.setValue("filter_column", (Object)entity.getFilterColumn(), rowIndex);
            }
            if (StringUtils.isNotEmpty((CharSequence)entity.getFilterLabel())) {
                model.setValue("filter_label", (Object)entity.getFilterLabel(), rowIndex);
            }
            if (StringUtils.isNotEmpty((CharSequence)entity.getFilterCompare())) {
                model.setValue("filter_compare", (Object)entity.getFilterCompare(), rowIndex);
            }
            if (StringUtils.isNotEmpty((CharSequence)entity.getFilterValue())) {
                model.setValue("filter_value", (Object)entity.getFilterValue(), rowIndex);
            }
            if (StringUtils.isNotEmpty((CharSequence)entity.getFilterRightBracket())) {
                model.setValue("filter_right_bracket", (Object)entity.getFilterRightBracket(), rowIndex);
            }
            if (StringUtils.isNotEmpty((CharSequence)entity.getFilterLink())) {
                model.setValue("filter_link", (Object)entity.getFilterLink(), rowIndex);
            }
        }
    }

    private Long analysisExistParams(DynamicObjectCollection entries, Set<String> existParams, String entryName, String paramName) {
        Long pid = 0L;
        DynamicObject currentRow = ((BaseModel)this.getModel()).getEntryCurrentRow(entryName);
        if (null != currentRow) {
            pid = currentRow.getLong("pid");
        }
        for (DynamicObject entry : entries) {
            Long parentId = entry.getLong("pid");
            if (!pid.equals(parentId)) continue;
            existParams.add(entry.getString(paramName));
        }
        return pid;
    }

    private void fillQueryFormEntity(ListSelectedRowCollection returnData) {
        DynamicObjectCollection entries = this.getModel().getEntryEntity(KEY_URL_ENTRY);
        HashSet<String> existParams = new HashSet<String>(entries.size());
        for (DynamicObject entry : entries) {
            existParams.add(entry.getString(URLPARAMNAME));
        }
        for (ListSelectedRow selectedRow : returnData) {
            String number = selectedRow.getNumber();
            if (existParams.contains(number)) continue;
            this.getEntryDynamicObject(KEY_URL_ENTRY, selectedRow, number, QUERY, null, null);
        }
    }

    private DynamicObject getEntryDynamicObject(String entryKey, ListSelectedRow selectedRow, String number, String entryBill, Long pid, Integer rowIndex) {
        IDataModel model = null;
        int row = 0;
        String name = selectedRow.getName();
        String fieldInfo = selectedRow.getPrimaryKeyValue().toString();
        DynamicObject entry = new DynamicObject(this.getModel().getEntryEntity(entryKey).getDynamicObjectType());
        String type = fieldInfo.split("/")[2];
        if (QUERY.equals(entryBill)) {
            model = (IDataModel)this.getView().getService(IDataModel.class);
            row = model.createNewEntryRow(entryKey);
            if (model != null) {
                model.setValue(URLPARAMNAME, (Object)number, row);
                model.setValue("urlparamtype", (Object)type, row);
                model.setValue("urlparamdes", (Object)name, row);
                model.setValue("urlparammust", (Object)1, row);
            }
        } else if ("body".equals(entryBill)) {
            entry.set(PARAMNAME, (Object)number);
            entry.set("paramtype", (Object)type);
            entry.set("bodyparamdes", (Object)name);
            entry.set("pid", (Object)pid);
            entry.set("must", (Object)1);
        } else if ("response".equals(entryBill)) {
            entry.set("respdes", (Object)name);
            entry.set(RESPPARAMNAME, (Object)number);
            entry.set("respparamtype", (Object)type);
            entry.set("respparammust", (Object)1);
        } else if (FILTER.equals(entryBill) && (model = (IDataModel)this.getView().getService(IDataModel.class)) != null) {
            model.createNewEntryRow(entryKey);
            model.setValue("filter_column", (Object)number, rowIndex.intValue());
        }
        return entry;
    }

    private void fillBodyFormEntity(ListSelectedRowCollection returnData) {
        DynamicObjectCollection entries = this.getModel().getEntryEntity(KEY_BODY_ENTRY);
        HashSet<String> existParams = new HashSet<String>(entries.size());
        Long pid = this.analysisExistParams(entries, existParams, KEY_BODY_ENTRY, PARAMNAME);
        for (ListSelectedRow selectedRow : returnData) {
            String number = selectedRow.getNumber();
            if (existParams.contains(number)) continue;
            DynamicObject entry = this.getEntryDynamicObject(KEY_BODY_ENTRY, selectedRow, number, "body", pid, null);
            this.getModel().createNewEntryRow(KEY_BODY_ENTRY, entry);
        }
    }

    private List<ComboItem> getEntityOpComboItem(String formId) {
        Lang lang = RequestContext.get().getLang();
        if (EMBED_OPEATION.get(lang) == null) {
            EMBED_OPEATION.put(lang, this.getCommonOpItem());
        }
        Predicate<Map> predicate = operationMeta -> {
            String operationKey = (String)operationMeta.get("key");
            String operationType = (String)operationMeta.get("type");
            boolean isEntityOperation = OperationTypeCache.isEntityOperation((String)operationType);
            return isEntityOperation && !EMBED_OPEATION.get(lang).stream().anyMatch(opItem -> Objects.equals(operationKey, opItem.getValue()));
        };
        Function<Map, ComboItem> mapper = operationMeta -> {
            ComboItem comboItem = new ComboItem();
            comboItem.setCaption(LocaleString.fromMap((Map)((Map)operationMeta.get(KEY_NAME))));
            comboItem.setValue((String)operationMeta.get("key"));
            return comboItem;
        };
        List dataEntityOperate = EntityMetadataCache.getDataEntityOperate((String)formId);
        ArrayList<ComboItem> tempList = new ArrayList<ComboItem>(10);
        List opList = dataEntityOperate.stream().filter(predicate).map(mapper).collect(Collectors.toList());
        tempList.addAll((Collection)EMBED_OPEATION.get(lang));
        tempList.addAll(opList);
        return tempList;
    }

    private void dealHideParam() throws KDException {
        String operation = (String)this.getView().getModel().getValue(KEY_OPERATION);
        if (StringUtils.isNotEmpty((CharSequence)operation) && QUERY.equals(operation)) {
            String selectHideParam = this.getSelectHideParam();
            if (StringUtils.isEmpty((CharSequence)selectHideParam)) {
                throw new KDException(ResManager.loadKDString((String)"\u8fd4\u56de\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"APIServicePlugin_36", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            }
            this.getModel().setValue(HIDE_INPUT_SELECT_PARAM, (Object)selectHideParam);
            Boolean isksql = (Boolean)this.getModel().getValue("isksql");
            if (isksql == null) {
                isksql = Boolean.FALSE;
            }
            CodeEdit codeEdit = (CodeEdit)this.getView().getControl(KSQL_FILTER);
            String content = codeEdit.getText();
            String filterHideParam = this.getFilterHideParam();
            if (!isksql.booleanValue()) {
                if (!StringUtils.isEmpty((CharSequence)filterHideParam)) {
                    this.getModel().setValue(HIDE_INPUT_FILTER_PARAM, (Object)filterHideParam);
                    codeEdit.setText(filterHideParam);
                } else {
                    this.getModel().setValue(HIDE_INPUT_FILTER_PARAM, (Object)"");
                    codeEdit.setText("");
                }
            } else {
                this.getModel().setValue(HIDE_INPUT_FILTER_PARAM, (Object)(StringUtils.isEmpty((CharSequence)content) ? "" : content));
            }
            String mustHideParam = this.getMustHideParam();
            if (!StringUtils.isEmpty((CharSequence)mustHideParam)) {
                this.getModel().setValue(HIDE_INPUT_MUST_PARAM, (Object)mustHideParam);
            } else {
                this.getModel().setValue(HIDE_INPUT_MUST_PARAM, (Object)"");
            }
            String apiId = ((BillModel)this.getModel()).getPKValue().toString();
            RedisCacheUtils.remove(apiId, QUEYR_KSQL);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        Object apiservicetype = this.getModel().getValue(KEY_APISERVICETYPE);
        AbstractOperate operate = (AbstractOperate)evt.getSource();
        String operateKey = operate.getOperateKey();
        try {
            if (SAVE.equals(operateKey)) {
                this.checkRepeatItem();
                String api_AllowKVQuery = System.getProperty("api.AllowKVQuery");
                if ("true".equals(api_AllowKVQuery)) {
                    this.dealHideParam();
                }
                this.saveApiOperation(evt, apiservicetype);
            } else if ("new".equals(operateKey)) {
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId(FORM_ID_OPEN_APISERIVCE_GUIDE);
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm(formShowParameter);
                evt.setCancel(true);
            } else if ("close".equals(operateKey)) {
                this.getModel().setDataChanged(false);
            } else if (ADDRESPFROMOBJ.equals(operateKey)) {
                this.showChooseFieldForm("responseBill");
            } else if ("bodypreview".equals(operateKey)) {
                DynamicObjectCollection bodyCollection = this.getModel().getEntryEntity(KEY_BODY_ENTRY);
                if (CollectionUtils.isEmpty((Collection)bodyCollection)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6c42\u4f53\u6682\u65e0\u6570\u636e\uff0c\u8bf7\u5f55\u5165\u3002", (String)"APIServicePlugin_25", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                    return;
                }
                String jsonData = ApiDataToJsonFormatUtils.getJsonFormatData(bodyCollection, "paramtype", PARAMNAME, "example");
                this.showDataPreview(jsonData);
            } else if (RESPPREVIEW.equals(operateKey)) {
                DynamicObjectCollection responses = this.getModel().getEntryEntity(KEY_RESPONSE_ENTRY);
                if (CollectionUtils.isEmpty((Collection)responses)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8fd4\u56de\u5185\u5bb9\u65e0\u6570\u636e\uff0c\u8bf7\u5f55\u5165\u3002", (String)"APIServicePlugin_28", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                    return;
                }
                String jsonData = ApiDataToJsonFormatUtils.getJsonFormatData(responses, "respparamtype", RESPPARAMNAME, "respexample");
                this.showDataPreview(jsonData);
            }
        }
        catch (KDException kde) {
            this.getView().showErrorNotification(kde.getMessage());
            evt.setCancel(true);
        }
        catch (Exception e) {
            log.info("\u9875\u9762\u64cd\u4f5c\u5f02\u5e38", (Object)e);
            evt.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs != null && afterDoOperationEventArgs.getOperationResult() != null && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            try {
                Object url = this.getModel().getValue(KEY_URLFORMAT);
                String urlformat = url == null ? "openapi" : url.toString();
                TypesContainer.getOrRegister((String)"kd.bos.openapi.base.acl.ApilAclManager").getMethod("removeApiAclModel", String.class).invoke(null, urlformat);
            }
            catch (Exception e) {
                log.info("webapi_log_new kd.bos.openapi.base.acl.ApilAclManager removeApiAclModel");
            }
            String operateKey = afterDoOperationEventArgs.getOperateKey();
            if (operateKey.equals(SAVE)) {
                LocalCacheUtil.clear(OpenApiData.class);
                LocalCacheUtil.clear((String)"apiserviceId");
            }
        }
    }

    private void checkRepeatItem() {
        String operation = (String)this.getView().getModel().getValue(KEY_OPERATION);
        if (StringUtils.isNotEmpty((CharSequence)operation)) {
            DynamicObject bizObject = (DynamicObject)this.getModel().getValue(KEY_BIZOBJECT);
            if (bizObject == null) {
                return;
            }
            String formNumber = bizObject.getString("number");
            QFilter[] filters = new QFilter[]{new QFilter(KEY_BIZOBJECT, "=", (Object)formNumber), new QFilter(KEY_OPERATION, "=", (Object)operation), new QFilter("enable", "=", (Object)IS_ENABLE), new QFilter("id", "!=", this.getModel().getValue("id")), new QFilter("version", "!=", (Object)"2")};
            DynamicObject[] apps = BusinessDataServiceHelper.load((String)"open_apiservice_new", (String)"id", (QFilter[])filters);
            if (apps.length > 0) {
                throw new KDException(ResManager.loadKDString((String)"API\u63a5\u53e3\u5df2\u5b58\u5728\uff0c\u8bf7\u7981\u7528\u540e\u518d\u6dfb\u52a0\u3002", (String)"APIServicePlugin_40", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            }
        }
    }

    private void showDataPreview(String previewData) {
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setFormId("api_param_priview");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setCustomParam("previewData", (Object)previewData);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void saveApiOperation(BeforeDoOperationEventArgs evt, Object apiservicetype) {
        boolean isAiOrCustomApi;
        if ("0".equals(apiservicetype) || "2".equals(apiservicetype)) {
            DynamicObjectCollection headerentryentity = this.getModel().getEntryEntity(KEY_HEADER_ENTRY);
            this.deleteSameEntryRow(headerentryentity, KEY_HEADER_ENTRY, HEADERNAME);
            DynamicObjectCollection urlparamentryentity = this.getModel().getEntryEntity(KEY_URL_ENTRY);
            this.deleteSameEntryRow(urlparamentryentity, KEY_URL_ENTRY, URLPARAMNAME);
            DynamicObjectCollection bodyentity = this.getModel().getEntryEntity(KEY_BODY_ENTRY);
            this.checkArrayEntryRow(evt, bodyentity, "paramtype", PARAMNAME);
            DynamicObjectCollection responseentity = this.getModel().getEntryEntity(KEY_RESPONSE_ENTRY);
            this.checkArrayEntryRow(evt, responseentity, "respparamtype", RESPPARAMNAME);
        }
        boolean bl = isAiOrCustomApi = IS_ENABLE.equals(apiservicetype) || "2".equals(apiservicetype);
        if (isAiOrCustomApi && !this.isUseNewVersionPlugin()) {
            evt.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u63d2\u4ef6\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u63d2\u4ef6\u3002", (String)"APIServicePlugin_5", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
        }
        String number = (String)this.getModel().getValue("number");
        String urlFormat = (String)this.getModel().getValue(KEY_URLFORMAT);
        if (number != null && number.contains("/")) {
            evt.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u5305\u542b\u975e\u6cd5\u5b57\u7b26/\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"APIServicePlugin_29", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
        } else if (this.isChinese(number)) {
            evt.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"API\u7f16\u53f7\u4e0d\u80fd\u5305\u542b\u4e2d\u6587\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"APIServicePlugin_30", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
        } else if (this.isChinese(urlFormat)) {
            evt.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u6c42\u5730\u5740\u4e0d\u80fd\u5305\u542b\u4e2d\u6587\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"APIServicePlugin_31", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
        }
        if (IS_ENABLE.equals(apiservicetype)) {
            int aiCmds = this.getModel().getEntryRowCount("aicommand");
            HashSet<String> cmds = new HashSet<String>(16);
            for (int i = 0; i < aiCmds; ++i) {
                String aiCmd = (String)this.getModel().getValue("ainumber", i);
                cmds.add(aiCmd);
                if (!this.checkAICmdExisted(aiCmd)) continue;
                evt.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"AI\u547d\u4ee4\u91cd\u590d\u3002", (String)"APIServicePlugin_32", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            }
            if (cmds.size() != aiCmds) {
                evt.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"AI\u547d\u4ee4\u91cd\u590d\u3002", (String)"APIServicePlugin_32", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            }
            if (this.getModel().getValue(KEY_APPID) == null) {
                evt.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u5c5e\u5e94\u7528\u672a\u586b\u5199\u3002", (String)"APIServicePlugin_33", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            }
        } else if ("0".equals(apiservicetype)) {
            DynamicObject object = (DynamicObject)this.getModel().getValue(KEY_BIZOBJECT);
            String operation = (String)this.getModel().getValue(KEY_OPERATION);
            if (object == null || operation == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u6216\u64cd\u4f5c\u7c7b\u578b\u672a\u586b\u5199\u3002", (String)"APIServicePlugin_34", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                evt.setCancel(true);
            }
        } else {
            List plugins;
            String pluginInfos = (String)this.getModel().getValue(KEY_PLUGIN);
            if (StringUtils.isNotBlank((CharSequence)pluginInfos) && (plugins = JSON.parseArray((String)pluginInfos, Plugin.class)).size() > 1) {
                evt.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u670d\u52a1\u6700\u591a\u53ea\u80fd\u6709\u4e00\u4e2a\u63d2\u4ef6\u3002", (String)"APIServicePlugin_35", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            }
        }
    }

    private void deleteSameEntryRow(DynamicObjectCollection entryentityCollection, String entryKey, String paramName) {
        ArrayList<String> paramsList = new ArrayList<String>();
        ArrayList<Integer> deleteRowIndexList = new ArrayList<Integer>();
        int rowIndex = 0;
        for (DynamicObject dynamicObject : entryentityCollection) {
            String headername = dynamicObject.getString(paramName);
            if (paramsList.contains(headername)) {
                deleteRowIndexList.add(rowIndex);
            } else {
                paramsList.add(headername);
            }
            ++rowIndex;
        }
        if (deleteRowIndexList.size() > 0) {
            int[] deletes = new int[deleteRowIndexList.size()];
            for (int i = 0; i < deletes.length; ++i) {
                deletes[i] = (Integer)deleteRowIndexList.get(i);
            }
            this.getModel().deleteEntryRows(entryKey, deletes);
        }
    }

    private void checkArrayEntryRow(BeforeDoOperationEventArgs evt, DynamicObjectCollection entryentityCollection, String paramType, String paramName) {
        HashMap<String, String> idNameMap = new HashMap<String, String>();
        ArrayList<String> pidList = new ArrayList<String>();
        for (DynamicObject dynamicObject : entryentityCollection) {
            String headername = dynamicObject.getString(paramType);
            String paramname = dynamicObject.getString(paramName);
            String pid = dynamicObject.getString("pid");
            pidList.add(pid);
            String id = dynamicObject.getString("id");
            if (!"Array".equals(headername)) continue;
            idNameMap.put(id, paramname);
        }
        for (Map.Entry it : idNameMap.entrySet()) {
            if (pidList.contains(it.getKey())) continue;
            evt.setCancel(true);
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u4e3aArray\u7c7b\u578b%s\u6dfb\u52a0\u5b50\u884c\u3002", (String)"APIServicePlugin_2", (String)BOS_OPEN_FORMPLUGIN, (Object[])new Object[0]), it.getValue()));
        }
    }

    private boolean isChinese(char c) {
        return c >= '\u4e00' && c <= '\u9fa5';
    }

    private boolean isChinese(String str) {
        if (str == null) {
            return false;
        }
        for (char c : str.toCharArray()) {
            if (!this.isChinese(c)) continue;
            return true;
        }
        return false;
    }

    private boolean isUseNewVersionPlugin() {
        String pluginInfoStr = (String)this.getModel().getValue(KEY_PLUGIN);
        return StringUtils.isBlank((CharSequence)pluginInfoStr) || pluginInfoStr.matches("\\[.+\\]");
    }

    public boolean checkAICmdExisted(String cmd) {
        QFilter filter = QFilter.of((String)"aicommand.ainumber=?", (Object[])new Object[]{cmd});
        DynamicObjectCollection items = QueryServiceHelper.query((String)FORMID_API_SERVICE, (String)"id,plugin,bizobject", (QFilter[])new QFilter[]{filter});
        Object pkValue = this.getModel().getDataEntity().getPkValue();
        return !items.isEmpty() && items.stream().anyMatch(dynObj -> !Objects.equals(dynObj.get("id"), pkValue));
    }

    private void showUrl() {
        String apiServiceType;
        String urlFormat = "";
        switch (apiServiceType = (String)this.getModel().getValue(KEY_APISERVICETYPE)) {
            case "2": {
                String number;
                DynamicObject bizApp = (DynamicObject)this.getModel().getValue(KEY_APPID);
                String appId = "{appId}";
                String serviceName = "{serviceName}";
                if (bizApp != null) {
                    appId = bizApp.getString("number");
                }
                if (StringUtils.isNotEmpty((CharSequence)(number = (String)this.getModel().getValue("number")))) {
                    serviceName = number;
                }
                urlFormat = "/app/" + appId + "/" + serviceName;
                break;
            }
            case "0": {
                String operation;
                DynamicObject bizObject = (DynamicObject)this.getModel().getValue(KEY_BIZOBJECT);
                String formId = "{formId}";
                String operationId = "{operationId}";
                if (bizObject != null) {
                    formId = bizObject.getPkValue().toString();
                }
                if (StringUtils.isNotEmpty((CharSequence)(operation = (String)this.getModel().getValue(KEY_OPERATION)))) {
                    operationId = operation;
                }
                urlFormat = "/sys/" + formId + "/" + operationId;
                break;
            }
            case "1": {
                urlFormat = "/ai/do";
                break;
            }
        }
        this.getModel().setValue(KEY_URLFORMAT, (Object)urlFormat);
    }

    private void urlFormChange(String apiServiceType, String propName, String urlFormat) {
        if ("2".equals(apiServiceType)) {
            if (KEY_APPID.equals(propName)) {
                DynamicObject bizApp = (DynamicObject)this.getModel().getValue(KEY_APPID);
                if (bizApp != null) {
                    String appId = bizApp.getString("number");
                    urlFormat = this.replaceUrl(urlFormat, 2, appId);
                    this.getModel().setValue(KEY_URLFORMAT, (Object)urlFormat);
                }
            } else if ("number".equals(propName)) {
                String serviceName = (String)this.getModel().getValue("number");
                urlFormat = this.replaceUrl(urlFormat, 3, serviceName);
                this.getModel().setValue(KEY_URLFORMAT, (Object)urlFormat);
            }
        } else if ("0".equals(apiServiceType)) {
            if (KEY_BIZOBJECT.equals(propName)) {
                DynamicObject bizObject = (DynamicObject)this.getModel().getValue(KEY_BIZOBJECT);
                if (bizObject != null) {
                    String formId = bizObject.getPkValue().toString();
                    urlFormat = this.replaceUrl(urlFormat, 2, formId);
                    this.getModel().setValue(KEY_URLFORMAT, (Object)urlFormat);
                }
            } else if (KEY_OPERATION.equals(propName)) {
                String operationId = (String)this.getModel().getValue(KEY_OPERATION);
                urlFormat = this.replaceUrl(urlFormat, 3, operationId);
                this.getModel().setValue(KEY_URLFORMAT, (Object)urlFormat);
            }
        }
    }

    private String replaceUrl(String url, int index, String replacement) {
        String[] strs = url.split("/");
        if (StringUtils.isEmpty((CharSequence)replacement) || index >= strs.length) {
            return url;
        }
        strs[index] = replacement;
        StringBuilder sb = new StringBuilder();
        for (int i = 1; i < strs.length; ++i) {
            sb.append('/').append(strs[i]);
        }
        return sb.toString();
    }

    public void cellClick(CellClickEvent cellClickEvent) {
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
        String fieldKey = cellClickEvent.getFieldKey();
        if ("filter_column".equals(fieldKey)) {
            this.showChooseFieldForm(null);
        }
    }
}

