/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.open.enums;

import java.util.ArrayList;
import java.util.HashMap;
import kd.sdk.annotation.SdkInternal;

@SdkInternal
public enum ParamTypeEnum {
    INT("int", Integer.class, false),
    DOUBLE("Double", Double.class, false),
    LONG("Long", Long.class, false),
    FLOAT("Float", Float.class, false),
    BOOLEAN("Boolean", Boolean.class, false),
    STRING("String", String.class, false),
    OBJECT("Object", HashMap.class, true),
    ARRAY("Array", ArrayList.class, true),
    OTHER("", null, false);

    private String type;
    private Class clazz;
    private boolean needNewInstance;

    private ParamTypeEnum(String type, Class clazz, boolean needNewInstance) {
        this.type = type;
        this.clazz = clazz;
        this.needNewInstance = needNewInstance;
    }

    public Class getClazz() {
        return this.clazz;
    }

    public String getType() {
        return this.type;
    }

    public static ParamTypeEnum getParamTypeByInputFlag(String type) {
        ParamTypeEnum[] values;
        for (ParamTypeEnum value : values = ParamTypeEnum.values()) {
            if (!value.type.equalsIgnoreCase(type)) continue;
            return value;
        }
        return OTHER;
    }

    public Object getFinalValue(ParamTypeEnum type, String value) {
        Object result;
        try {
            switch (type) {
                case INT: {
                    result = Integer.valueOf(value);
                    break;
                }
                case DOUBLE: {
                    result = Double.valueOf(value);
                    break;
                }
                case LONG: {
                    result = Long.valueOf(value);
                    break;
                }
                case FLOAT: {
                    result = Float.valueOf(value);
                    break;
                }
                case BOOLEAN: {
                    result = Boolean.valueOf(value);
                    break;
                }
                default: {
                    result = value;
                    break;
                }
            }
        }
        catch (Exception e) {
            result = value;
        }
        return result;
    }

    public static ParamTypeEnum getParamTypeByPropertyType(Class clazz) {
        ParamTypeEnum[] values;
        if (null == clazz) {
            return STRING;
        }
        for (ParamTypeEnum value : values = ParamTypeEnum.values()) {
            if (!clazz.equals(value.clazz) && !clazz.getSimpleName().equalsIgnoreCase(value.type)) continue;
            return value;
        }
        return STRING;
    }
}

