/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.form.plugin.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.plugin.open.enums.ParamTypeEnum;
import kd.bos.util.StringUtils;

public class ApiDataToJsonFormatUtils {
    public static String getJsonFormatData(DynamicObjectCollection collection, String typeKey, String nameKey, String valueKey) {
        Iterator iterator = collection.iterator();
        ArrayList<DynamicObject> tops = new ArrayList<DynamicObject>(10);
        while (iterator.hasNext()) {
            DynamicObject dynamicObject = (DynamicObject)iterator.next();
            if (0L != dynamicObject.getLong("pid")) continue;
            tops.add(dynamicObject);
            iterator.remove();
        }
        Map<String, Object> resultMap = ApiDataToJsonFormatUtils.packageJsonFormat(collection, tops, typeKey, nameKey, valueKey);
        return JSON.toJSONString(resultMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteDateUseDateFormat});
    }

    private static Map<String, Object> packageJsonFormat(DynamicObjectCollection dynamicObjects, List<DynamicObject> tops, String typeKey, String nameKey, String valueKey) {
        LinkedHashMap<String, Object> responseMap = new LinkedHashMap<String, Object>(16);
        for (DynamicObject top : tops) {
            String key = top.getString(nameKey);
            String type = top.getString(typeKey);
            ParamTypeEnum typeEnum = ParamTypeEnum.getParamTypeByInputFlag(type);
            if (typeEnum != ParamTypeEnum.ARRAY && typeEnum != ParamTypeEnum.OBJECT) {
                String value = top.getString(valueKey);
                responseMap.put(key, typeEnum.getFinalValue(typeEnum, value));
                continue;
            }
            if (typeEnum == ParamTypeEnum.ARRAY) {
                responseMap.put(key, ApiDataToJsonFormatUtils.getArrayFormatData(dynamicObjects, typeKey, nameKey, valueKey, top));
                continue;
            }
            responseMap.put(key, ApiDataToJsonFormatUtils.packageJsonFormat(dynamicObjects, top, typeKey, nameKey, valueKey));
        }
        return responseMap;
    }

    private static List<Object> getArrayFormatData(DynamicObjectCollection dynamicObjects, String typeKey, String nameKey, String valueKey, DynamicObject parent) {
        ArrayList<Object> list = new ArrayList<Object>(1);
        int filedCount = 0;
        int subFiledCount = 0;
        for (DynamicObject response : dynamicObjects) {
            String type = response.getString(typeKey);
            String key = response.getString(nameKey);
            String value = response.getString(valueKey);
            ParamTypeEnum typeEnum = ParamTypeEnum.getParamTypeByInputFlag(type);
            if (!parent.getPkValue().toString().equals(response.getString("pid"))) continue;
            ++subFiledCount;
            if (!StringUtils.isBlank((String)key)) continue;
            ++filedCount;
            if (typeEnum != ParamTypeEnum.ARRAY && typeEnum != ParamTypeEnum.OBJECT) {
                list.add(typeEnum.getFinalValue(typeEnum, value));
                continue;
            }
            if (typeEnum == ParamTypeEnum.OBJECT) {
                LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>(16);
                data.putAll(ApiDataToJsonFormatUtils.packageJsonFormat(dynamicObjects, response, typeKey, nameKey, valueKey));
                list.add(data);
                continue;
            }
            list.add(ApiDataToJsonFormatUtils.getArrayFormatData(dynamicObjects, typeKey, nameKey, valueKey, response));
        }
        if (filedCount == subFiledCount) {
            return list;
        }
        list.clear();
        list.add(ApiDataToJsonFormatUtils.packageJsonFormat(dynamicObjects, parent, typeKey, nameKey, valueKey));
        return list;
    }

    private static Map<String, Object> packageJsonFormat(DynamicObjectCollection dynamicObjects, DynamicObject object, String typeKey, String nameKey, String valueKey) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(16);
        for (DynamicObject response : dynamicObjects) {
            String type = response.getString(typeKey);
            String key = response.getString(nameKey);
            String value = response.getString(valueKey);
            ParamTypeEnum typeEnum = ParamTypeEnum.getParamTypeByInputFlag(type);
            if (!object.getPkValue().toString().equals(response.getString("pid"))) continue;
            if (typeEnum != ParamTypeEnum.ARRAY && typeEnum != ParamTypeEnum.OBJECT) {
                result.put(key, typeEnum.getFinalValue(typeEnum, value));
                continue;
            }
            if (typeEnum == ParamTypeEnum.OBJECT) {
                LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>(16);
                data.putAll(ApiDataToJsonFormatUtils.packageJsonFormat(dynamicObjects, response, typeKey, nameKey, valueKey));
                result.put(key, data);
                continue;
            }
            result.put(key, ApiDataToJsonFormatUtils.getArrayFormatData(dynamicObjects, typeKey, nameKey, valueKey, response));
        }
        return result;
    }
}

