/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.form.plugin.callback.CallBackInfo;
import kd.bos.openapi.form.plugin.callback.CallBackUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;

public class OpenApiCallbackListPlugin
extends AbstractFormPlugin {
    private static final Log log = LogFactory.getLog(OpenApiCallbackListPlugin.class);
    private static final String KEY_BTN_OK = "btnok";
    private static final String KEY_BTN_CANCEL = "btncancel";
    private static final String BTN_DELETE = "delete";
    public static final String OPENAPI_CALLBACK = "openapi_callback";
    public static final String ENTRYENTITY = "entryentity";
    public static final String APIID = "apiid";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_BTN_OK, KEY_BTN_CANCEL, ENTRYENTITY});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.buildEntity();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof AbstractOperate) {
            AbstractOperate operate = (AbstractOperate)args.getSource();
            String operateKey = operate.getOperateKey();
            if ("new".equals(operateKey)) {
                BillShowParameter param = new BillShowParameter();
                param.setFormId(OPENAPI_CALLBACK);
                param.getOpenStyle().setShowType(ShowType.Modal);
                param.setStatus(OperationStatus.ADDNEW);
                param.setCustomParam(APIID, this.getApiid());
                param.setCaption(ResManager.loadKDString((String)"\u65b0\u589e\u56de\u8c03\u5730\u5740", (String)"OpenApiCallbackListPlugin_2", (String)"bos-open-formplugin", (Object[])new Object[0]));
                param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "add"));
                this.getView().showForm((FormShowParameter)param);
            } else if (BTN_DELETE.equals(operateKey)) {
                DynamicObjectCollection entryentity = this.getModel().getEntryEntity(ENTRYENTITY);
                EntryGrid entryGrid = (EntryGrid)this.getControl(ENTRYENTITY);
                ArrayList<Integer> selectRows = new ArrayList<Integer>(1);
                for (int num : entryGrid.getSelectRows()) {
                    selectRows.add(num + 1);
                }
                ArrayList<Long> ids = new ArrayList<Long>();
                for (DynamicObject object : entryentity) {
                    int seq = object.getInt("seq");
                    long id = object.getLong("id");
                    if (id <= 0L || !selectRows.contains(seq)) continue;
                    ids.add(id);
                }
                if (CollectionUtil.isNotEmpty(ids)) {
                    DeleteServiceHelper.delete((String)OPENAPI_CALLBACK, (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
                    this.buildEntity();
                }
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        if (StringUtils.equals((CharSequence)evt.getActionId(), (CharSequence)"add")) {
            this.buildEntity();
        }
    }

    private Object getApiid() {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object apiid = formShowParameter.getCustomParam(APIID);
        return apiid;
    }

    private void buildEntity() {
        this.getModel().deleteEntryData(ENTRYENTITY);
        Long apiId = (Long)this.getApiid();
        try {
            List<CallBackInfo> callbackUrlInfos = CallBackUtil.findCallbackUrl(apiId);
            Map<Long, CallBackInfo> callBackMap = callbackUrlInfos.stream().collect(Collectors.toMap(CallBackInfo::getFid, call -> call));
            QFilter[] filters = new QFilter[]{new QFilter(APIID, "=", (Object)apiId)};
            DynamicObject[] callbacks = BusinessDataServiceHelper.load((String)OPENAPI_CALLBACK, (String)"apiid.id,id,thirdid.name,thirdid.id,agentuserid.name,agentuserid.id,enable", (QFilter[])filters);
            if (callbacks.length > 0) {
                for (DynamicObject obj : callbacks) {
                    CallBackInfo callBackInfo = callBackMap.get(obj.getLong("id"));
                    int index = this.getModel().createNewEntryRow(ENTRYENTITY);
                    this.getModel().setValue("id", (Object)obj.getLong("id"), index);
                    this.getModel().setValue("commurl", (Object)this.outInfo(callBackInfo, "commurl"), index);
                    this.getModel().setValue("pathVarUrl", (Object)this.outInfo(callBackInfo, "pathVarUrl"), index);
                    this.getModel().setValue("thirdname", (Object)obj.getString("thirdid.name"), index);
                    this.getModel().setValue("agentusername", (Object)obj.getString("agentuserid.name"), index);
                    this.getModel().setValue("status", (Object)("1".equalsIgnoreCase(this.outInfo(callBackInfo, "status")) ? ResManager.loadKDString((String)"\u53ef\u7528", (String)"OpenApiCallbackListPlugin_0", (String)"bos-open-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4e0d\u53ef\u7528", (String)"OpenApiCallbackListPlugin_1", (String)"bos-open-formplugin", (Object[])new Object[0])), index);
                }
            }
        }
        catch (OpenApiException e) {
            String msg = ResManager.loadKDString((String)"\u65e0\u6cd5\u627e\u5230\u57fa\u672c\u8ba4\u8bc1\u79d8\u94a5\uff0c\u8bf7\u68c0\u67e5\u7b2c\u4e09\u65b9\u5e94\u7528\u914d\u7f6e\u3002", (String)"OpenApiCallbackListPlugin_3", (String)"bos-open-formplugin", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
        }
    }

    private String outInfo(CallBackInfo callBackInfo, String field) {
        if (callBackInfo == null) {
            return "";
        }
        if ("commurl".equalsIgnoreCase(field)) {
            return callBackInfo.getCommUrl();
        }
        if ("pathVarUrl".equalsIgnoreCase(field)) {
            return callBackInfo.getPathVarUrl();
        }
        if ("status".equalsIgnoreCase(field)) {
            return callBackInfo.getStatus();
        }
        return "";
    }
}

