/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin;

import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.spi.OpenApiDataServiceFactory;
import kd.bos.openapi.common.util.DateUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class OpenApiCostDataListPlugin
extends AbstractListPlugin
implements HyperLinkClickListener {
    private static final String KEY_BILLLIST = "billlistap";
    private static final String OPENAPI_LOG_DATA = "openapi_log_data";
    private static final Log log = LogFactory.getLog(OpenApiCostDataListPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList billList = (BillList)this.getControl(KEY_BILLLIST);
        billList.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        super.billListHyperLinkClick(args);
        BillListHyperLinkClickEvent event = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        ListSelectedRow currentRow = event.getCurrentRow();
        long primaryKeyValue = (Long)currentRow.getPrimaryKeyValue();
        DynamicObjectCollection query = QueryServiceHelper.query((String)"openapi_costdata", (String)"apiid,createtime", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)primaryKeyValue)});
        if (query != null && query.size() > 0) {
            try {
                Date createtime = ((DynamicObject)query.get(0)).getDate("createtime");
                Date startDate = DateUtil.getDateWithoutHour((Date)DateUtil.getDateAdd((Date)createtime, (int)10, (int)-24));
                Date endDate = DateUtil.getDateWithoutHour((Date)createtime);
                String threshold = OpenApiDataServiceFactory.getOpenApiDataService().getSysParameter("costdata_threshold", "10000");
                QFilter filter = new QFilter("apiid", "=", (Object)((DynamicObject)query.get(0)).getString("apiid")).and(new QFilter("opdate", ">=", (Object)startDate)).and(new QFilter("opdate", "<", (Object)endDate)).and(new QFilter("timecost", ">", (Object)Integer.valueOf(threshold)));
                OpenApiCostDataListPlugin.openBillList((AbstractFormPlugin)this, Collections.singletonList(filter));
            }
            catch (ParseException e) {
                log.info("\u65e5\u671f\u8f6c\u6362\u9519\u8bef\uff01", (Object)e);
            }
        }
        args.setCancel(true);
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
    }

    private static void openBillList(AbstractFormPlugin form, List<QFilter> filters) {
        ListShowParameter param = new ListShowParameter();
        param.setBillFormId(OPENAPI_LOG_DATA);
        param.setFormId("BOS_LIST");
        param.getListFilterParameter().setQFilters(filters);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setCustomParam("costData", (Object)"true");
        param.setCaption(ResManager.loadKDString((String)"API\u8c03\u7528\u65e5\u5fd7", (String)"OpenApiListPlugin_8", (String)"bos-open-formplugin", (Object[])new Object[0]));
        form.getView().showForm((FormShowParameter)param);
    }
}

