/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin;

import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.BindingContext;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.HistogramChart;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.base.util.QFilterUtil;
import kd.bos.openapi.common.util.DateUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class OpenApiCountHistogramCardPlugin
extends AbstractFormPlugin {
    private static final String KEY_HISTOGRAMCHARTAP = "histogramchartap";
    private static final String KEY_APPCLOUD = "appcloud";
    private static final String REFRESH = "refresh";
    private static final String FORM_ID = "openapi_statdata";
    private static DynamicObjectCollection datas = null;
    private static final Log log = LogFactory.getLog(OpenApiCountHistogramCardPlugin.class);

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{KEY_HISTOGRAMCHARTAP});
        this.addClickListeners(new String[]{REFRESH});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        try {
            this.getDataFromDB();
            Map<String, Double> mapForChart = this.dealData(datas);
            this.rebuildchart(mapForChart);
        }
        catch (ParseException ex) {
            log.error("parse error:", (Object)e);
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (control.getKey().equals(REFRESH)) {
            try {
                this.getDataFromDB();
            }
            catch (ParseException e) {
                log.error("parse error:", (Throwable)e);
            }
            Map<String, Double> mapForChart = this.dealData(datas);
            this.rebuildchart(mapForChart);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (name.equals(KEY_APPCLOUD)) {
            // empty if block
        }
    }

    private void getDataFromDB() throws ParseException {
        Date timeBefore24 = DateUtil.getDateWithoutMinute((Date)DateUtil.getDateAdd((Date)new Date(), (int)10, (int)-24));
        QFilter[] qFilters = QFilterUtil.builder().put("type", "=", (Object)1).put("time", ">=", (Object)timeBefore24.getTime()).build();
        datas = QueryServiceHelper.query((String)FORM_ID, (String)"time,apiid,apiid.name,cnt,type", (QFilter[])qFilters, (String)"cnt");
    }

    private Map<String, Double> dealData(DynamicObjectCollection datas) {
        Map<String, List<DynamicObject>> logMap = datas.stream().collect(Collectors.groupingBy(it -> it.getString("apiid")));
        Set<Map.Entry<String, List<DynamicObject>>> apis = logMap.entrySet();
        HashMap map = new HashMap(apis.size());
        apis.stream().forEach(stringListEntry -> map.put(((DynamicObject)((List)stringListEntry.getValue()).get(0)).getString("apiid.name"), ((List)stringListEntry.getValue()).stream().map(data -> data.getBigDecimal("cnt")).reduce(BigDecimal.ZERO, BigDecimal::add).doubleValue()));
        Map mapForChart = map.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).limit(8L).sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (c1, c2) -> c1, LinkedHashMap::new));
        return mapForChart;
    }

    private void rebuildchart(Map<String, Double> map) {
        HistogramChart customchart = (HistogramChart)this.getControl(KEY_HISTOGRAMCHARTAP);
        customchart.clearData();
        this.setHandlechartXaxisTick(customchart, map);
        this.setHandleChartData(customchart, map);
        customchart.setMargin(Position.right, "30px");
        customchart.setMargin(Position.top, "30px");
        customchart.setLegendPropValue("itemWidth", (Object)10);
        customchart.setLegendPropValue("itemHeight", (Object)10);
    }

    private Axis setHandlechartXaxisTick(HistogramChart customchart, Map<String, Double> logMap) {
        Axis xAxis = customchart.createYAxis("(API)", AxisType.category);
        ArrayList<String> xDimensions = new ArrayList<String>();
        Set<String> apiNames = logMap.keySet();
        xDimensions.addAll(apiNames);
        xAxis.setCategorys(xDimensions);
        xAxis.setPosition(Position.bottom);
        HashMap<String, Constable> axisTick = new HashMap<String, Constable>();
        axisTick.put("interval", Integer.valueOf(0));
        axisTick.put("show", Boolean.FALSE);
        xAxis.setPropValue("axisTick", axisTick);
        this.setLineColor(xAxis, "#999999");
        return xAxis;
    }

    private void setHandleChartData(HistogramChart customchart, Map<String, Double> logMap) {
        Axis yAxis = customchart.createXAxis(ResManager.loadKDString((String)"(\u6b21)", (String)"OpenApiCountHistogramCardPlugin_1", (String)"bos-open-formplugin", (Object[])new Object[0]), AxisType.value);
        yAxis.setPropValue("nameGap", (Object)"5");
        HashMap<String, Object> map = new HashMap<String, Object>();
        int[] padding = new int[]{0, 0, 5, 5};
        map.put("padding", padding);
        yAxis.setPropValue("nameTextStyle", map);
        BarSeries expireSeries = customchart.createBarSeries(ResManager.loadKDString((String)"\u8c03\u7528\u6b21\u6570(\u6700\u8fd124\u5c0f\u65f6)", (String)"OpenApiCountHistogramCardPlugin_0", (String)"bos-open-formplugin", (Object[])new Object[0]));
        expireSeries.setBarWidth("20px");
        expireSeries.setAnimationDuration(5);
        expireSeries.setData((Number[])logMap.values().toArray(new Double[logMap.size()]));
        map = new HashMap();
        HashMap<String, HashMap<String, Object>> normap = new HashMap<String, HashMap<String, Object>>();
        map.put("color", "new echarts.graphic.LinearGradient(0, 0, 0, 1, [{\"offset\": 0,\"color\": '#02A7F0'}, {\"offset\": 1, \"color\": '#02A7F0'}])");
        normap.put("normal", map);
        expireSeries.setPropValue("itemStyle", normap);
        ArrayList<String> list = new ArrayList<String>();
        list.add("itemStyle");
        list.add("normal");
        list.add("color");
        expireSeries.addFuncPath(list);
        expireSeries.setLabel(null);
        HashMap<String, Boolean> axisTick = new HashMap<String, Boolean>();
        axisTick.put("show", Boolean.FALSE);
        yAxis.setPropValue("axisTick", axisTick);
        HashMap splitLine = new HashMap();
        HashMap<String, String> lineStyle = new HashMap<String, String>();
        lineStyle.put("type", "dotted");
        lineStyle.put("color", "#E2E2E2");
        splitLine.put("lineStyle", lineStyle);
        yAxis.setPropValue("splitLine", splitLine);
        this.setLineColor(yAxis, "#999999");
        customchart.setShowLegend(true);
        customchart.setLegendAlign(XAlign.right, YAlign.top);
        customchart.setShowTooltip(true);
        customchart.bindData((BindingContext)null);
    }

    private void setLineColor(Axis axix, String color) {
        HashMap axisLineMap = new HashMap();
        HashMap<String, String> lineStyleMap = new HashMap<String, String>();
        lineStyleMap.put("color", color);
        axisLineMap.put("lineStyle", lineStyleMap);
        axix.setPropValue("axisLine", axisLineMap);
    }
}

