/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AnchorItems;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDException;
import kd.bos.ext.form.control.AnchorControl;
import kd.bos.ext.form.control.Markdown;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.control.Control;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.openapi.api.result.ApiServiceResult;
import kd.bos.openapi.api.util.ApiService;
import kd.bos.openapi.base.custom.CustomApiUtil;
import kd.bos.openapi.base.dataservice.OpenApiDataUtil;
import kd.bos.openapi.base.model.ApiModel;
import kd.bos.openapi.base.util.QFilterUtil;
import kd.bos.openapi.common.constant.ApiOperationType;
import kd.bos.openapi.common.constant.ApiServiceType;
import kd.bos.openapi.common.constant.HttpMethod;
import kd.bos.openapi.common.constant.RestSoapType;
import kd.bos.openapi.common.constant.Version;
import kd.bos.openapi.common.result.OpenApiResult;
import kd.bos.openapi.common.util.JsonUtil;
import kd.bos.openapi.common.util.OpenJsonUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.common.util.XmlUtil;
import kd.bos.openapi.common.wsdl.SoapUtil;
import kd.bos.openapi.form.util.ApiDocJsonToMd;
import kd.bos.openapi.form.util.ApiPluginUtil;
import kd.bos.openapi.form.util.FormOpener;
import kd.bos.openapi.form.util.OpenApiDataPreviewUtil;
import kd.bos.openapi.form.util.OpenApiDataToJsonFormatUtils;
import kd.bos.openapi.form.util.OpenApiDocToMapUtils;
import kd.bos.openapi.form.util.enums.ParamTypeEnum;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.url.UrlService;
import kd.bos.xdb.util.Pair;

public class OpenApiDocPlugin
extends StandardTreeListPlugin
implements TreeNodeClickListener,
ClickListener,
AfterF7SelectListener,
BeforeF7SelectListener {
    private static final String ENTITY_OPEN_API_SERVICE_LIST = "openapi_apilist";
    private static final String KEY_CLOUD_COMBO = "cloudcombo";
    private static final String KEY_HTTP_METHOD = "httpmethod";
    private static final String KEY_OPERATION = "operation";
    private static final String KEY_APP_TREE = "treeview";
    private static final String DATA_FIELD_NAME = "name";
    private static final String DATA_FIELD_ID = "Id";
    private static final String DATA_FIELD_NUMBER = "number";
    private static final String DATA_FIELD_COSMICVER = "cosmicver";
    private static final String DATA_FIELD_APISERVICETYPE = "apiservicetype";
    private static final String DATA_FIELD_ENABLE = "enable";
    private static final String HEADERENTRYENTITY = "headerentryentity";
    private static final String URLPARAMENTRYENTITY = "urlparamentryentity";
    private static final String BODYENTRYENTITY = "bodyentryentity";
    private static final String ERRORCODEENTITY = "errorcodeentity";
    private static final String RESPENTRYENTITY = "respentryentity";
    private static final String NAMESPACE = "namespace";
    private static final String BTN_NEW = "btnnew";
    private static final String BTN_EDIT = "btnedit";
    private static final String BTN_DEL = "btndel";
    private static final String BTN_GETURL = "geturl";
    private static final String CREATOR = "creator";
    private static final String VERSION = "version";
    private static final String HEADERNAME = "headername";
    private static final String HEADERVALUE = "headervalue";
    private static final String HEADERDES = "headerdes";
    private static final String PARAMNAME = "paramname";
    private static final String ERRORCODE = "errorCode";
    public static final String INPUTPARAM = "wsinputparam";
    private static final String NODE_APP = "app_";
    private static final String NODE_BIZ = "biz_";
    private static final String NODE_CUS = "cus_";
    private static final String NODE_AI = "ai_";
    private static final String PAGE_CACHE_KEY_CLOUD = "cloud_cache";

    public void initTreeToolbar(EventObject e) {
        super.initTreeToolbar(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{BTN_NEW, BTN_EDIT, BTN_DEL});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        TreeView treeView = (TreeView)this.getView().getControl(KEY_APP_TREE);
        if (null != treeView) {
            treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
        }
        this.addClickListeners(new String[]{BTN_GETURL});
        BasedataEdit f7 = (BasedataEdit)this.getControl(KEY_CLOUD_COMBO);
        f7.addAfterF7SelectListener((AfterF7SelectListener)this);
        f7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        String userId;
        super.afterCreateNewData(e);
        if (StringUtils.isNotEmpty((CharSequence)this.getCacheCloud())) {
            this.getModel().setValue(KEY_CLOUD_COMBO, (Object)this.getCacheCloud());
        }
        if ((userId = RequestContext.get().getUserId()).equals("-1")) {
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_CLOUD_COMBO, BTN_GETURL});
            this.buildTree();
        } else {
            this.buildTreeByCloud();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        if (control.getKey().equals(BTN_GETURL)) {
            String cosmicURL = UrlService.getDomainContextUrl();
            String url = cosmicURL + "?userId=Guest&accountId=" + RequestContext.get().getAccountId() + "&formId=openapi_apidoc&billFormId=openapi_apilist&type=list";
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5f53\u524d\u9875\u9762URL", (String)"OpenApiDocPlugin_0", (String)"bos-open-formplugin", (Object[])new Object[0]), url, MessageBoxOptions.OK, ConfirmTypes.Default, null);
        }
    }

    public void treeNodeClick(TreeNodeEvent e) {
        String nodeId = e.getNodeId().toString();
        try {
            if ("8609760E-EF83-4775-A9FF-CCDEC7C0B689".equals(e.getParentNodeId()) || e.getParentNodeId().equals("") || nodeId.contains(NODE_APP) || nodeId.contains(NODE_BIZ) || nodeId.contains(NODE_CUS) || nodeId.contains(NODE_AI)) {
                return;
            }
            this.getView().setVisible(Boolean.TRUE, new String[]{"flex_pal"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flex_re"});
            DynamicObject apiInfo = BusinessDataServiceHelper.loadSingle((Object)nodeId, (String)ENTITY_OPEN_API_SERVICE_LIST);
            if (Objects.isNull(apiInfo)) {
                return;
            }
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
            data.put(DATA_FIELD_ID, apiInfo.get(DATA_FIELD_ID));
            data.put(DATA_FIELD_NUMBER, apiInfo.get(DATA_FIELD_NUMBER));
            data.put(DATA_FIELD_NAME, apiInfo.get(DATA_FIELD_NAME));
            data.put(DATA_FIELD_APISERVICETYPE, apiInfo.get(DATA_FIELD_APISERVICETYPE));
            HashMap<String, Object> baseinfo = new HashMap<String, Object>();
            baseinfo.put("discription", apiInfo.getString("discription"));
            String httpmethod = apiInfo.getString(KEY_HTTP_METHOD);
            HttpMethod method = HttpMethod.fromCode((String)httpmethod);
            baseinfo.put(KEY_HTTP_METHOD, method != null ? method.getName() : "");
            this.buildAnchorCtl(apiInfo.getString(KEY_HTTP_METHOD).equals("0"));
            String url = this.getHttpUrl(apiInfo);
            baseinfo.put("urlformat", url);
            baseinfo.put(CREATOR, null != apiInfo.getDynamicObject(CREATOR) ? apiInfo.getDynamicObject(CREATOR).getString(DATA_FIELD_NAME) : "");
            baseinfo.put(VERSION, null != apiInfo.getString(VERSION) && apiInfo.getString(VERSION).equals("2") ? "Kapi2.0" : "Kapi1.0");
            baseinfo.put(DATA_FIELD_COSMICVER, apiInfo.get(DATA_FIELD_COSMICVER));
            data.put("baseinfo", baseinfo);
            ArrayList headerlist = new ArrayList();
            DynamicObjectCollection headercolls = apiInfo.getDynamicObjectCollection(HEADERENTRYENTITY);
            for (DynamicObject row : headercolls) {
                LinkedHashMap<String, String> header = new LinkedHashMap<String, String>();
                header.put(HEADERNAME, row.getString(HEADERNAME));
                header.put(HEADERVALUE, row.getString(HEADERVALUE));
                header.put(HEADERDES, row.getString(HEADERDES));
                headerlist.add(header);
            }
            if (headercolls.size() <= 0) {
                LinkedHashMap<String, String> contentType = new LinkedHashMap<String, String>();
                contentType.put(HEADERNAME, "Content-Type");
                contentType.put(HEADERVALUE, "application/json");
                contentType.put(HEADERDES, ResManager.loadKDString((String)"\u5185\u5bb9\u683c\u5f0f", (String)"OpenApiDocPlugin_1", (String)"bos-open-formplugin", (Object[])new Object[0]));
                headerlist.add(contentType);
                LinkedHashMap<String, String> accesstoken = new LinkedHashMap<String, String>();
                accesstoken.put(HEADERNAME, "accessToken");
                accesstoken.put(HEADERVALUE, ResManager.loadKDString((String)"\u83b7\u53d6\u7684accessToken\u503c", (String)"OpenApiDocPlugin_2", (String)"bos-open-formplugin", (Object[])new Object[0]));
                accesstoken.put(HEADERDES, ResManager.loadKDString((String)"\u8bf7\u6c42\u4ee4\u724c", (String)"OpenApiDocPlugin_3", (String)"bos-open-formplugin", (Object[])new Object[0]));
                headerlist.add(accesstoken);
                LinkedHashMap<String, String> idempotencyKey = new LinkedHashMap<String, String>();
                idempotencyKey.put(HEADERNAME, "Idempotency-Key");
                idempotencyKey.put(HEADERVALUE, ResManager.loadKDString((String)"\u552f\u4e00\u7684requestId", (String)"OpenApiDocPlugin_17", (String)"bos-open-formplugin", (Object[])new Object[0]));
                idempotencyKey.put(HEADERDES, ResManager.loadKDString((String)"\u975e\u5fc5\u4f20\u53c2\u6570\uff0c\u9632\u6b62\u63a5\u53e3\u88ab\u91cd\u590d\u8c03\u7528", (String)"OpenApiDocPlugin_21", (String)"bos-open-formplugin", (Object[])new Object[0]));
                headerlist.add(idempotencyKey);
            }
            data.put("headerData", headerlist);
            ArrayList<Map<String, Object>> bodylist = new ArrayList<Map<String, Object>>();
            ArrayList<Map<String, Object>> resplist = new ArrayList<Map<String, Object>>();
            DynamicObjectCollection body = apiInfo.getDynamicObjectCollection(BODYENTRYENTITY);
            DynamicObjectCollection bodyEx = (DynamicObjectCollection)body.clone();
            DynamicObjectCollection resp = apiInfo.getDynamicObjectCollection(RESPENTRYENTITY);
            if (StringUtil.isNotEmpty((String)apiInfo.getString(KEY_OPERATION)) && resp.size() == 0 && !apiInfo.getString(KEY_OPERATION).equalsIgnoreCase(ApiOperationType.QUERY.getOp())) {
                resp = this.buildSaveEntryData(apiInfo.getString(KEY_OPERATION), resp);
            }
            if (StringUtil.isNotEmpty((String)apiInfo.getString(KEY_OPERATION)) && apiInfo.getString(KEY_OPERATION).equalsIgnoreCase(ApiOperationType.QUERY.getOp())) {
                resp = ApiPluginUtil.buildQueryEntryData(apiInfo.getString(KEY_OPERATION), resp);
            }
            DynamicObjectCollection respEx = (DynamicObjectCollection)resp.clone();
            String apiServiceType = apiInfo.getString(DATA_FIELD_APISERVICETYPE);
            if (this.isCustomOrScriptService(apiServiceType)) {
                bodylist.addAll(OpenApiDocToMapUtils.getListData(body, "customBody", null, null));
                resplist.addAll(OpenApiDocToMapUtils.getListData(resp, "customResp", null, null));
            } else {
                resplist.addAll(OpenApiDocToMapUtils.getListData(resp, "respparamtype", "respparamname", "respexample"));
                bodylist.addAll(OpenApiDocToMapUtils.getListData(body, "paramtype", PARAMNAME, "example"));
            }
            if (apiServiceType.equals(String.valueOf(ApiServiceType.OPERATION.ordinal())) && apiInfo.getString(KEY_OPERATION).equalsIgnoreCase(ApiOperationType.QUERY.getOp())) {
                this.addPageParams(bodylist, method != null && HttpMethod.POST.getName().equals(method.getName()));
            }
            if (apiInfo.getString(KEY_HTTP_METHOD).equals("1")) {
                data.put("bodyData", bodylist);
                this.getView().setVisible(Boolean.TRUE, new String[]{"tabap", "markdownap3"});
            } else {
                data.put("queryData", bodylist);
                this.getView().setVisible(Boolean.FALSE, new String[]{"tabap", "markdownap3"});
            }
            data.put("respData", resplist);
            this.setExampleData(apiInfo, bodyEx, data, BODYENTRYENTITY);
            this.setExampleData(apiInfo, respEx, data, RESPENTRYENTITY);
            ArrayList errorList = new ArrayList();
            HashMap<String, String> error = new HashMap<String, String>();
            error.put(ERRORCODE, "1001");
            error.put("errorMsg", ResManager.loadKDString((String)"token\u65e0\u6548\u6216\u5df2\u8fc7\u671f", (String)"OpenApiDocPlugin_4", (String)"bos-open-formplugin", (Object[])new Object[0]));
            errorList.add(error);
            HashMap<String, String> error1 = new HashMap<String, String>();
            error1.put(ERRORCODE, "1002");
            error1.put("errorMsg", ResManager.loadKDString((String)"\u79d8\u94a5\u65e0\u6548", (String)"OpenApiDocPlugin_5", (String)"bos-open-formplugin", (Object[])new Object[0]));
            errorList.add(error1);
            data.put("errorData", errorList);
            data.put("errorCodeData", this.getErrorCodeData(apiInfo));
            map.put("data", data);
            map.put("timestamp", Instant.now().toString());
            Markdown mk = (Markdown)this.getView().getControl("markdownap");
            Markdown mkheader = (Markdown)this.getView().getControl("markdown_header");
            Markdown mkbody = (Markdown)this.getView().getControl("markdown_body");
            Markdown mkresp = (Markdown)this.getView().getControl("markdown_resp");
            Markdown mk1 = (Markdown)this.getView().getControl("markdownap1");
            Markdown mk2 = (Markdown)this.getView().getControl("markdownap2");
            Markdown mk3 = (Markdown)this.getView().getControl("markdownap3");
            Markdown jsonmd = (Markdown)this.getView().getControl("jsonmd");
            Markdown xmlmd = (Markdown)this.getView().getControl("xmlmd");
            Markdown soap1md = (Markdown)this.getView().getControl("soap1md");
            Markdown soap2md = (Markdown)this.getView().getControl("soap2md");
            Markdown jsonmd1 = (Markdown)this.getView().getControl("jsonmd1");
            Markdown xmlmd1 = (Markdown)this.getView().getControl("xmlmd1");
            Markdown soap1md1 = (Markdown)this.getView().getControl("soap1md1");
            Markdown soap2md1 = (Markdown)this.getView().getControl("soap2md1");
            ApiDocJsonToMd md = new ApiDocJsonToMd();
            Map<String, String> mdStr = md.mapToMd(nodeId, map);
            mk.setText(mdStr.get("str"));
            mkheader.setText(mdStr.get("mkheader"));
            mkbody.setText(mdStr.get("mkbody"));
            mkresp.setText(mdStr.get("mkresp"));
            mk1.setText(mdStr.get("str1"));
            mk2.setText(mdStr.get("str2"));
            mk3.setText(mdStr.get("str3"));
            jsonmd.setText(mdStr.get("jsonbody"));
            xmlmd.setText(mdStr.get("xmlbody"));
            soap1md.setText(mdStr.get("soap1body"));
            soap2md.setText(mdStr.get("soap2body"));
            jsonmd1.setText(mdStr.get("jsonResp"));
            xmlmd1.setText(mdStr.get("xmlResp"));
            soap1md1.setText(mdStr.get("soap1Resp"));
            soap2md1.setText(mdStr.get("soap2Resp"));
            this.getView().setVisible(Boolean.TRUE, new String[]{"mdflex"});
            return;
        }
        catch (KDException ex) {
            e.setCancel(true);
            this.getView().showErrorNotification(ex.getMessage());
        }
        catch (Exception ex) {
            e.setCancel(true);
            FormOpener.showErrorMessage(this.getView(), ex);
        }
    }

    private boolean isCustomOrScriptService(String apiServiceType) {
        return apiServiceType.equals(String.valueOf(ApiServiceType.CUSTOM.ordinal())) || apiServiceType.equals(String.valueOf(ApiServiceType.SCRIPT.ordinal())) || apiServiceType.equals(String.valueOf(ApiServiceType.CUSTSERVLET.ordinal()));
    }

    private List<Map<String, Object>> getErrorCodeData(DynamicObject apiInfo) {
        ArrayList<Map<String, Object>> errorCodelist = new ArrayList<Map<String, Object>>();
        DynamicObjectCollection errorCodes = apiInfo.getDynamicObjectCollection(ERRORCODEENTITY);
        for (DynamicObject row : errorCodes) {
            LinkedHashMap<String, String> errorCode = new LinkedHashMap<String, String>();
            errorCode.put(ERRORCODE, row.getString("errorcode"));
            errorCode.put("errorCodeDesc", row.getString("errorcodedesc"));
            errorCodelist.add(errorCode);
        }
        return errorCodelist;
    }

    private void setExampleData(DynamicObject apiInfo, DynamicObjectCollection dyEx, Map<String, Object> resultData, String entryType) {
        String apiServiceType = apiInfo.getString(DATA_FIELD_APISERVICETYPE);
        String nameSpace = apiInfo.getString(NAMESPACE);
        String inputParam = apiInfo.getString(INPUTPARAM);
        if (apiServiceType.equals(String.valueOf(ApiServiceType.CUSTOM.ordinal()))) {
            if (entryType.equals(BODYENTRYENTITY)) {
                Map<String, Object> requestMap = OpenApiDataToJsonFormatUtils.transferToMap(dyEx, BODYENTRYENTITY);
                this.setJsonXmlToData("body", resultData, requestMap, nameSpace, inputParam);
            } else {
                Map<String, Object> responseMap = OpenApiDataToJsonFormatUtils.transferToMap(dyEx, RESPENTRYENTITY);
                this.setJsonXmlToData("resp", resultData, responseMap, nameSpace, inputParam);
            }
            return;
        }
        if (apiServiceType.equals(String.valueOf(ApiServiceType.SCRIPT.ordinal())) || apiServiceType.equals(String.valueOf(ApiServiceType.CUSTSERVLET.ordinal()))) {
            String url = apiInfo.getString("urlformat");
            ApiModel apiModel = OpenApiDataUtil.getApiModelFromCache((String)url);
            DynamicObject curApi = apiModel.getApi();
            if (entryType.equals(BODYENTRYENTITY)) {
                DynamicObjectCollection bodyentryentity = curApi.getDynamicObjectCollection(BODYENTRYENTITY);
                Object resultObj = CustomApiUtil.getCustomParams((String)BODYENTRYENTITY, (DynamicObjectCollection)bodyentryentity);
                this.setJsonXmlToData("body", resultData, resultObj, nameSpace, inputParam);
            } else {
                DynamicObjectCollection respentryentity = curApi.getDynamicObjectCollection(RESPENTRYENTITY);
                Object resultObj = CustomApiUtil.getCustomParams((String)RESPENTRYENTITY, (DynamicObjectCollection)respentryentity);
                OpenApiResult result = new OpenApiResult();
                result.setData(resultObj);
                result.setErrorCode("0");
                result.setMessage("");
                this.setJsonXmlToData("resp", resultData, result, nameSpace, inputParam);
            }
            return;
        }
        if (entryType.equals(BODYENTRYENTITY)) {
            if (apiInfo.getString(KEY_HTTP_METHOD).equals("1")) {
                HashMap<String, Object> bodyData = new HashMap<String, Object>();
                Map<String, Object> bodyExample = OpenApiDataToJsonFormatUtils.getResultData(dyEx, "paramtype", PARAMNAME, "example");
                bodyData.put("data", bodyExample);
                if (apiServiceType.equals(String.valueOf(ApiServiceType.OPERATION.ordinal())) && apiInfo.getString(KEY_OPERATION).equalsIgnoreCase(ApiOperationType.QUERY.getOp())) {
                    bodyData.put("pageSize", 10);
                    bodyData.put("pageNo", 1);
                }
                if (apiServiceType.equals(String.valueOf(ApiServiceType.OPERATION.ordinal())) && apiInfo.getString(KEY_OPERATION).equalsIgnoreCase(ApiOperationType.SAVE.getOp())) {
                    bodyData.put("data", Collections.singleton(bodyExample));
                }
                this.setJsonXmlToData("body", resultData, bodyData, nameSpace, inputParam);
            }
        } else if (Version.TWO.getVer().equals(apiInfo.getString(VERSION))) {
            String op = apiInfo.getString(KEY_OPERATION);
            if (StringUtil.isEmpty((String)op)) {
                this.setJsonXmlToData("resp", resultData, JSON.toJSON((Object)new OpenApiResult()), nameSpace, inputParam);
            } else if ("query".equals(op)) {
                Pair<Map<String, Object>, Boolean> result = OpenApiDataPreviewUtil.getDataPair("", RESPENTRYENTITY, dyEx, apiInfo.getString(KEY_OPERATION), apiInfo.getInt(KEY_HTTP_METHOD));
                this.setJsonXmlToData("resp", resultData, result.getKey(), nameSpace, inputParam);
            } else {
                ApiServiceResult data = ApiService.getTypeByOp((String)op.toUpperCase()).getResultType();
                OpenApiResult openApiResult = OpenApiResult.builder().success((Object)data);
                Object jsonObject = JSON.toJSON((Object)openApiResult);
                this.setJsonXmlToData("resp", resultData, jsonObject, nameSpace, inputParam);
            }
        }
    }

    private void setJsonXmlToData(String entryType, Map<String, Object> resultData, Object resultEx, String nameSpace, String inputParam) {
        String xml;
        String soap1_1 = "";
        String soap1_2 = "";
        try {
            xml = XmlUtil.objectToXml((Object)resultEx);
        }
        catch (Exception e) {
            xml = e.getMessage();
        }
        try {
            soap1_1 = SoapUtil.getSoapXml((Object)resultEx, (RestSoapType)RestSoapType.SOAP1_1, (String)nameSpace, (String)inputParam);
        }
        catch (Exception e) {
            soap1_1 = e.getMessage();
        }
        try {
            soap1_2 = SoapUtil.getSoapXml((Object)resultEx, (RestSoapType)RestSoapType.SOAP1_2, (String)nameSpace, (String)inputParam);
        }
        catch (Exception e) {
            soap1_2 = e.getMessage();
        }
        resultData.put(entryType + "Example", OpenJsonUtil.toJson((Object)resultEx));
        resultData.put(entryType + "ExampleXml", xml);
        resultData.put(entryType + "ExampleSoap1", soap1_1);
        resultData.put(entryType + "ExampleSoap2", soap1_2);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        if (!KEY_CLOUD_COMBO.equals(propertyName)) {
            return;
        }
        if (e.getChangeSet()[0].getNewValue() == null) {
            this.getModel().setValue(KEY_CLOUD_COMBO, e.getChangeSet()[0].getOldValue());
        }
        if ("type".equals(propertyName)) {
            // empty if block
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent arg0) {
        Object ids = new JSONArray[]{};
        if (null != this.getPageCache() && null != this.getPageCache().get(PAGE_CACHE_KEY_CLOUD)) {
            JSONArray json;
            String cloudJson = this.getPageCache().get(PAGE_CACHE_KEY_CLOUD);
            ids = json = JSONArray.parseArray((String)cloudJson);
        } else {
            DynamicObjectCollection apis = QueryServiceHelper.query((String)ENTITY_OPEN_API_SERVICE_LIST, (String)"Id,appid.bizcloud.Id", (QFilter[])QFilter.isNotNull((String)"appid.bizcloud.Id").and(new QFilter(DATA_FIELD_ENABLE, "!=", (Object)"0")).toArray());
            HashMap<String, List> typeMap = new HashMap<String, List>();
            for (DynamicObject it : apis) {
                typeMap.computeIfAbsent(it.getString("appid.bizcloud.Id"), k -> new ArrayList()).add(it);
            }
            ids = typeMap.keySet();
        }
        ListShowParameter showParameter = (ListShowParameter)arg0.getFormShowParameter();
        showParameter.getListFilterParameter().getQFilters().add(new QFilter(DATA_FIELD_ID, "in", ids));
        this.getPageCache().put(PAGE_CACHE_KEY_CLOUD, JSON.toJSONString((Object)ids));
    }

    public void afterF7Select(AfterF7SelectEvent arg0) {
        this.buildTreeByCloud();
        if (null != this.getModel().getValue(KEY_CLOUD_COMBO)) {
            this.cacheBuilder();
        }
    }

    private void defaultClickFirstNode(List<TreeNode> nodes) {
        if (CollectionUtils.isEmpty(nodes)) {
            return;
        }
        for (TreeNode node : nodes) {
            List childNodes = node.getChildren();
            if (CollectionUtils.isEmpty((Collection)childNodes)) continue;
            TreeNode showApiInfoNode = (TreeNode)((TreeNode)childNodes.get(0)).getChildren().get(0);
            TreeView treeView = (TreeView)this.getView().getControl(KEY_APP_TREE);
            treeView.addTreeNodeClickListener((TreeNodeClickListener)this);
            treeView.showNode(showApiInfoNode.getParentid());
            treeView.focusNode(showApiInfoNode);
            if (null != showApiInfoNode && null != showApiInfoNode.getParentid() && null != showApiInfoNode.getId()) {
                treeView.treeNodeClick(showApiInfoNode.getParentid(), showApiInfoNode.getId());
            }
            return;
        }
    }

    private String getHttpUrl(DynamicObject apiInfo) {
        DynamicObjectCollection queryParams;
        String url = apiInfo.getString("urlformat");
        String cosmicURL = UrlService.getDomainContextUrl();
        String format = "";
        boolean urlwith = cosmicURL != null && cosmicURL.endsWith("/");
        boolean iskapi2 = null != apiInfo.getString(VERSION) && "2".equals(apiInfo.getString(VERSION));
        format = urlwith ? "%skapi%s" : "%s/kapi%s";
        url = String.format(format, cosmicURL, url);
        if (apiInfo.getString(KEY_HTTP_METHOD).equals("1")) {
            return url;
        }
        DynamicObjectCollection dynamicObjectCollection = queryParams = iskapi2 ? apiInfo.getDynamicObjectCollection(BODYENTRYENTITY) : apiInfo.getDynamicObjectCollection(URLPARAMENTRYENTITY);
        if (CollectionUtils.isEmpty((Collection)queryParams)) {
            return url;
        }
        StringBuilder urlBuilder = new StringBuilder();
        for (DynamicObject param : queryParams) {
            if (urlBuilder.length() > 0) {
                urlBuilder.append("&");
            }
            String name = param.getString(iskapi2 ? PARAMNAME : "urlparamname");
            String pathvariable = "{" + name + "}";
            if (url.contains(pathvariable)) continue;
            urlBuilder.append(name).append("={").append(name).append('}');
        }
        if (StringUtil.isNotEmpty((String)urlBuilder.toString())) {
            urlBuilder.insert(0, "?");
        }
        StringBuilder finalUrl = new StringBuilder(url).append((CharSequence)urlBuilder);
        return finalUrl.toString();
    }

    private void buildTreeByCloud() {
        TreeView tv1 = (TreeView)this.getView().getControl(KEY_APP_TREE);
        tv1.deleteAllNodes();
        String cloudID = "";
        if (null == (DynamicObject)this.getModel().getValue(KEY_CLOUD_COMBO)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e91", (String)"OpenApiDocPlugin_6", (String)"bos-open-formplugin", (Object[])new Object[0]));
            return;
        }
        TreeNode root = new TreeNode();
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"OpenApiDocPlugin_7", (String)"bos-open-formplugin", (Object[])new Object[0]));
        root.setParentid("");
        root.setIsOpened(true);
        cloudID = ((DynamicObject)this.getModel().getValue(KEY_CLOUD_COMBO)).getString(DATA_FIELD_ID);
        QFilter[] qFilters = !"true".equals(ApiPluginUtil.getVisibleSysApi(this.getView())) ? new QFilter("appid.bizcloud.Id", "=", (Object)cloudID).and(new QFilter(DATA_FIELD_ENABLE, "!=", (Object)"0")).and(new QFilter(VERSION, "=", (Object)"2")).and(new QFilter("is_sys_api", "=", (Object)"0")).toArray() : new QFilter("appid.bizcloud.Id", "=", (Object)cloudID).and(new QFilter(DATA_FIELD_ENABLE, "!=", (Object)"0")).and(new QFilter(VERSION, "=", (Object)"2")).toArray();
        DynamicObject[] apis = BusinessDataServiceHelper.load((String)ENTITY_OPEN_API_SERVICE_LIST, (String)"Id,name,apiservicetype,bizobject.Id,bizobject.name,appid.Id,appid.name,appid.type,customsort.Id,customsort.name", (QFilter[])qFilters);
        if (apis.length <= 0) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap_no", "flexpanelap_noapi"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap", "flexpanel_treebtn", "flex_pal"});
            return;
        }
        this.getView().setVisible(Boolean.valueOf(true), new String[]{"flexpanelap", "flexpanel_treebtn", "flex_pal"});
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap_no", "flexpanelap_noapi"});
        TreeNode appNode = null;
        Map<String, List<DynamicObject>> appMap = Arrays.stream(apis).collect(Collectors.groupingBy(it -> it.getString("appid.Id")));
        for (Map.Entry<String, List<DynamicObject>> entry : appMap.entrySet()) {
            String appId = entry.getKey();
            String appName = entry.getValue().get(0).getString("appid.name");
            StringBuilder builder = new StringBuilder(appName);
            if ("2".equals(entry.getValue().get(0).getString("appid.type"))) {
                builder.append(ResManager.loadKDString((String)"\u3010\u6269\u5c55\u3011", (String)"OpenApiDocPlugin_20", (String)"bos-open-formplugin", (Object[])new Object[0]));
            }
            appNode = new TreeNode(null, appId, builder.toString());
            appNode.addChildren(this.buildNodeByApp(appId, entry.getValue()));
            root.addChild(appNode);
            tv1.addNode(appNode);
        }
        this.getTreeModel().setRoot(root);
        this.getTreeModel().setCurrentNodeId((Object)root.getId());
        this.getView().updateView(KEY_APP_TREE);
        this.defaultClickFirstNode(root.getChildren());
    }

    private void buildTree() {
        TreeView tv1 = (TreeView)this.getView().getControl(KEY_APP_TREE);
        tv1.deleteAllNodes();
        TreeNode root = new TreeNode();
        root.setText(ResManager.loadKDString((String)"\u5168\u90e8", (String)"OpenApiDocPlugin_7", (String)"bos-open-formplugin", (Object[])new Object[0]));
        root.setParentid("");
        root.setIsOpened(true);
        QFilter[] qFilters = !"true".equals(ApiPluginUtil.getVisibleSysApi(this.getView())) ? QFilterUtil.builder().put(new QFilter[]{new QFilter(DATA_FIELD_ENABLE, "!=", (Object)"0"), new QFilter(VERSION, "=", (Object)"2"), new QFilter("is_sys_api", "=", (Object)"0")}).build() : QFilterUtil.builder().put(new QFilter[]{new QFilter(DATA_FIELD_ENABLE, "!=", (Object)"0"), new QFilter(VERSION, "=", (Object)"2")}).build();
        DynamicObjectCollection apis = QueryServiceHelper.query((String)ENTITY_OPEN_API_SERVICE_LIST, (String)"Id,name,apiservicetype,bizobject.Id,bizobject.name,appid.Id,appid.name,appid.type,customsort.Id,customsort.name", (QFilter[])qFilters);
        TreeNode appNode = null;
        Map<String, List<DynamicObject>> appMap = apis.stream().filter(x -> x.getString("appid.Id") != null).collect(Collectors.groupingBy(it -> it.getString("appid.Id")));
        for (Map.Entry<String, List<DynamicObject>> entry : appMap.entrySet()) {
            String appId = entry.getKey();
            String appName = entry.getValue().get(0).getString("appid.name");
            StringBuilder builder = new StringBuilder(appName);
            if ("2".equals(entry.getValue().get(0).getString("appid.type"))) {
                builder.append(ResManager.loadKDString((String)"\u3010\u6269\u5c55\u3011", (String)"OpenApiDocPlugin_20", (String)"bos-open-formplugin", (Object[])new Object[0]));
            }
            appNode = new TreeNode(null, appId, builder.toString());
            appNode.addChildren(this.buildNodeByApp(appId, entry.getValue()));
            root.addChild(appNode);
            tv1.addNode(appNode);
        }
        this.getTreeModel().setRoot(root);
        this.getTreeModel().setCurrentNodeId((Object)root.getId());
        this.getView().updateView(KEY_APP_TREE);
        this.defaultClickFirstNode(root.getChildren());
    }

    private List<TreeNode> buildNodeByApp(String appId, List<DynamicObject> apiList) {
        ArrayList<TreeNode> appChildren = new ArrayList<TreeNode>();
        Map<String, List<DynamicObject>> typeMap = apiList.stream().collect(Collectors.groupingBy(it -> it.getString(DATA_FIELD_APISERVICETYPE)));
        List<DynamicObject> opApiList = typeMap.get(String.valueOf(ApiServiceType.OPERATION.ordinal()));
        List<DynamicObject> aiApiList = typeMap.get(String.valueOf(ApiServiceType.AI.ordinal()));
        List<DynamicObject> cusApiList = typeMap.get(String.valueOf(ApiServiceType.CUSTOM.ordinal()));
        List<DynamicObject> scriptApiList = typeMap.get(String.valueOf(ApiServiceType.SCRIPT.ordinal()));
        List<DynamicObject> servletApiList = typeMap.get(String.valueOf(ApiServiceType.CUSTSERVLET.ordinal()));
        ArrayList<DynamicObject> cusAndScriptApiList = new ArrayList<DynamicObject>();
        cusAndScriptApiList.addAll(cusApiList == null ? Collections.EMPTY_LIST : cusApiList);
        cusAndScriptApiList.addAll(scriptApiList == null ? Collections.EMPTY_LIST : scriptApiList);
        cusAndScriptApiList.addAll(servletApiList == null ? Collections.EMPTY_LIST : servletApiList);
        TreeNode bizNode = null;
        TreeNode aiNode = null;
        TreeNode cusNode = null;
        if (!CollectionUtils.isEmpty(opApiList)) {
            Map<String, List<DynamicObject>> bizMap = opApiList.stream().collect(Collectors.groupingBy(it -> null == it.getString("bizobject.Id") ? "null_biz" + it.getString("appid.Id") : it.getString("bizobject.Id")));
            for (Map.Entry<String, List<DynamicObject>> entry : bizMap.entrySet()) {
                String bizId = entry.getKey();
                String bizName = entry.getValue().get(0).getString("bizobject.name");
                bizNode = new TreeNode(appId, NODE_BIZ + bizId, bizName);
                bizNode.addChildren(this.buildOpApiNode(bizId, entry.getValue()));
                appChildren.add(bizNode);
            }
        }
        if (!CollectionUtils.isEmpty(aiApiList)) {
            aiNode = new TreeNode(appId, NODE_AI + appId, ResManager.loadKDString((String)"AI\u670d\u52a1", (String)"OpenApiDocPlugin_8", (String)"bos-open-formplugin", (Object[])new Object[0]));
            aiNode.addChildren(this.buildAIApiNode(NODE_AI + appId, aiApiList));
            appChildren.add(aiNode);
        }
        if (!CollectionUtils.isEmpty(cusAndScriptApiList)) {
            Map<String, List<DynamicObject>> cusMap = cusAndScriptApiList.stream().collect(Collectors.groupingBy(it -> it.getString("customsort.Id") == null ? "0" + it.getString("appid.Id") : it.getString("customsort.Id")));
            for (Map.Entry<String, List<DynamicObject>> entry : cusMap.entrySet()) {
                String cusId = entry.getKey();
                String cusName = "";
                String nodeId = "";
                cusName = entry.getValue().get(0).getString("customsort.name");
                nodeId = appId + "_" + NODE_CUS + cusId;
                cusNode = new TreeNode(appId, nodeId, cusName);
                cusNode.addChildren(this.buildCusApiNode(nodeId, entry.getValue()));
                appChildren.add(cusNode);
            }
        }
        return appChildren;
    }

    private List<TreeNode> buildOpApiNode(String bizId, List<DynamicObject> bizApiList) {
        ArrayList<TreeNode> bizChildren = new ArrayList<TreeNode>(bizApiList.size());
        TreeNode apiNode = null;
        for (DynamicObject bizApi : bizApiList) {
            apiNode = new TreeNode(NODE_BIZ + bizId, bizApi.getString(DATA_FIELD_ID), bizApi.getString(DATA_FIELD_NAME));
            bizChildren.add(apiNode);
        }
        return bizChildren;
    }

    private List<TreeNode> buildAIApiNode(String aiId, List<DynamicObject> aiApiList) {
        ArrayList<TreeNode> aiChildren = new ArrayList<TreeNode>(aiApiList.size());
        TreeNode apiNode = null;
        for (DynamicObject aiApi : aiApiList) {
            apiNode = new TreeNode(aiId, aiApi.getString(DATA_FIELD_ID), aiApi.getString(DATA_FIELD_NAME));
            aiChildren.add(apiNode);
        }
        return aiChildren;
    }

    private List<TreeNode> buildCusApiNode(String nodeId, List<DynamicObject> cusApiList) {
        ArrayList<TreeNode> cusChildren = new ArrayList<TreeNode>(cusApiList.size());
        TreeNode apiNode = null;
        for (DynamicObject cusApi : cusApiList) {
            apiNode = new TreeNode(nodeId, cusApi.getString(DATA_FIELD_ID), cusApi.getString(DATA_FIELD_NAME));
            cusChildren.add(apiNode);
        }
        return cusChildren;
    }

    private void cacheBuilder() {
        String chCloudId = ((DynamicObject)this.getModel().getValue(KEY_CLOUD_COMBO)).getString(DATA_FIELD_ID);
        String tenantCode = RequestContext.get().getTenantCode();
        IAppCache cache = AppCache.get((String)(tenantCode + ((Object)((Object)this)).getClass().getName()));
        cache.put("openapi_cloudId", (Object)chCloudId);
    }

    private String getCacheCloud() {
        String tenantCode = RequestContext.get().getTenantCode();
        IAppCache cache = AppCache.get((String)(tenantCode + ((Object)((Object)this)).getClass().getName()));
        return (String)cache.get("openapi_cloudId", String.class);
    }

    private DynamicObjectCollection buildSaveEntryData(String op, DynamicObjectCollection saveRes) {
        saveRes.clear();
        ApiServiceResult data = ApiService.getTypeByOp((String)op.toUpperCase()).getResultType();
        Map data1 = (Map)JsonUtil.toJSON((Object)OpenApiResult.builder().success((Object)data));
        for (Map.Entry entryMap : data1.entrySet()) {
            DynamicObject row = new DynamicObject(saveRes.getDynamicObjectType());
            if (((String)entryMap.getKey()).equals("data")) {
                row.set(DATA_FIELD_ID, (Object)1L);
                row.set("pid", (Object)0L);
                row.set("respparamname", entryMap.getKey());
                row.set("respparamtype", (Object)ParamTypeEnum.ARRAY.getType());
                row.set("respdes", (Object)ResManager.loadKDString((String)"\u7ed3\u679c\u6570\u636e", (String)"OpenApiFormPlugin_63", (String)"bos-open-formplugin", (Object[])new Object[0]));
                row.set("resp_level", (Object)"1");
                row.set("respexample", (Object)"{}");
                saveRes.add((Object)row);
                Map dataChild = (Map)entryMap.getValue();
                for (Map.Entry entryMap1 : dataChild.entrySet()) {
                    DynamicObject child = new DynamicObject(saveRes.getDynamicObjectType());
                    child.set("pid", row.get(DATA_FIELD_ID));
                    child.set("respparamname", entryMap1.getKey());
                    if (((String)entryMap1.getKey()).equals("result")) {
                        child.set(DATA_FIELD_ID, (Object)9L);
                        child.set("respparamtype", (Object)"Array<Map>");
                        child.set("respdes", (Object)ResManager.loadKDString((String)"\u8fd4\u56de\u7ed3\u679c\u8be6\u7ec6\u4fe1\u606f", (String)"OpenApiFormPlugin_64", (String)"bos-open-formplugin", (Object[])new Object[0]));
                        child.set("respexample", (Object)("\"" + entryMap1.getValue() + "\""));
                    } else if (((String)entryMap1.getKey()).equals("failCount")) {
                        child.set(DATA_FIELD_ID, (Object)10L);
                        child.set("respparamtype", (Object)"String");
                        child.set("respdes", (Object)ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\u6570\u91cf", (String)"OpenApiFormPlugin_65", (String)"bos-open-formplugin", (Object[])new Object[0]));
                        child.set("respexample", (Object)"\"2\"");
                    } else if (((String)entryMap1.getKey()).equals("filter")) {
                        child.set(DATA_FIELD_ID, (Object)11L);
                        child.set("respparamtype", (Object)"String");
                        child.set("respdes", (Object)ResManager.loadKDString((String)"\u8fc7\u6ee4\u6761\u4ef6", (String)"OpenApiFormPlugin_66", (String)"bos-open-formplugin", (Object[])new Object[0]));
                        child.set("respexample", (Object)ResManager.loadKDString((String)"\u64cd\u4f5c\u6267\u884c\u7684\u8fc7\u6ee4\u6761\u4ef6\uff0c\u5982\uff1abillno in ('CGSQ-220228-000258','CGSQ-220228-000259')", (String)"OpenApiFormPlugin_67", (String)"bos-open-formplugin", (Object[])new Object[0]));
                    } else if (((String)entryMap1.getKey()).equals("successCount")) {
                        child.set(DATA_FIELD_ID, (Object)12L);
                        child.set("respparamtype", (Object)"String");
                        child.set("respdes", (Object)ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u6570\u91cf", (String)"OpenApiFormPlugin_68", (String)"bos-open-formplugin", (Object[])new Object[0]));
                        child.set("respexample", (Object)"\"1\"");
                    } else if (((String)entryMap1.getKey()).equals("totalCount")) {
                        child.set(DATA_FIELD_ID, (Object)13L);
                        child.set("respparamtype", (Object)"String");
                        child.set("respdes", (Object)ResManager.loadKDString((String)"\u603b\u6570", (String)"OpenApiFormPlugin_69", (String)"bos-open-formplugin", (Object[])new Object[0]));
                        child.set("respexample", (Object)"\"3\"");
                    }
                    child.set("resp_level", (Object)"2");
                    saveRes.add((Object)child);
                }
                continue;
            }
            row.set("respparamname", entryMap.getKey());
            if (((String)entryMap.getKey()).equals(ERRORCODE)) {
                row.set(DATA_FIELD_ID, (Object)2L);
                row.set("respparamtype", (Object)"String");
                row.set("respdes", (Object)ResManager.loadKDString((String)"\u9519\u8bef\u7801", (String)"OpenApiFormPlugin_70", (String)"bos-open-formplugin", (Object[])new Object[0]));
                row.set("resp_level", (Object)"1");
                row.set("respexample", (Object)ResManager.loadKDString((String)"\u6210\u529f\u65f6\u4e3a0\uff0c\u5931\u8d25\u65f6\u4f1a\u8fd4\u56de\u9519\u8bef\u7801\u5982400", (String)"OpenApiFormPlugin_71", (String)"bos-open-formplugin", (Object[])new Object[0]));
            } else if (((String)entryMap.getKey()).equals("message")) {
                row.set(DATA_FIELD_ID, (Object)3L);
                row.set("respparamtype", (Object)"String");
                row.set("respdes", (Object)ResManager.loadKDString((String)"\u63a5\u53e3\u8c03\u7528\u9519\u8bef\u4fe1\u606f", (String)"OpenApiFormPlugin_72", (String)"bos-open-formplugin", (Object[])new Object[0]));
                row.set("resp_level", (Object)"1");
                row.set("respexample", (Object)ResManager.loadKDString((String)"\u6210\u529f\u65f6\u4e3a\u7a7a\uff0c\u5931\u8d25\u65f6\u4f1a\u8fd4\u56de\u9519\u8bef\u4fe1\u606f\u5982\u201c\u64cd\u4f5c\u5931\u8d25\u201d", (String)"OpenApiFormPlugin_73", (String)"bos-open-formplugin", (Object[])new Object[0]));
            } else if (((String)entryMap.getKey()).equals("status")) {
                row.set(DATA_FIELD_ID, (Object)4L);
                row.set("respparamtype", (Object)"Boolean");
                row.set("respdes", (Object)ResManager.loadKDString((String)"\u63a5\u53e3\u8bbf\u95ee\u662f\u5426\u6210\u529f", (String)"OpenApiFormPlugin_74", (String)"bos-open-formplugin", (Object[])new Object[0]));
                row.set("resp_level", (Object)"1");
                row.set("respexample", (Object)"true/false");
            }
            saveRes.add((Object)row);
        }
        return saveRes;
    }

    private void buildAnchorCtl(boolean isGet) {
        AnchorControl anchorCtl = (AnchorControl)this.getView().getControl("anchorcontrolap");
        ArrayList<AnchorItems> items = new ArrayList<AnchorItems>();
        items.add(new AnchorItems("markdownap", ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f", (String)"OpenApiDocPlugin_9", (String)"bos-open-formplugin", (Object[])new Object[0]), null));
        items.add(new AnchorItems("markdown_header", ResManager.loadKDString((String)"\u8bf7\u6c42\u5934\u53c2\u6570", (String)"OpenApiDocPlugin_10", (String)"bos-open-formplugin", (Object[])new Object[0]), null));
        items.add(new AnchorItems("markdown_body", isGet ? ResManager.loadKDString((String)"Query\u53c2\u6570", (String)"OpenApiDocPlugin_11", (String)"bos-open-formplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8bf7\u6c42\u4f53\u53c2\u6570", (String)"OpenApiDocPlugin_12", (String)"bos-open-formplugin", (Object[])new Object[0]), null));
        items.add(new AnchorItems("markdown_resp", ResManager.loadKDString((String)"\u8fd4\u56de\u53c2\u6570", (String)"OpenApiDocPlugin_13", (String)"bos-open-formplugin", (Object[])new Object[0]), null));
        items.add(new AnchorItems("markdownap3", ResManager.loadKDString((String)"\u8bf7\u6c42\u7ed3\u6784\u793a\u4f8b", (String)"OpenApiDocPlugin_14", (String)"bos-open-formplugin", (Object[])new Object[0]), null));
        items.add(new AnchorItems("markdownap2", ResManager.loadKDString((String)"\u8fd4\u56de\u7ed3\u6784\u793a\u4f8b", (String)"OpenApiDocPlugin_15", (String)"bos-open-formplugin", (Object[])new Object[0]), null));
        items.add(new AnchorItems("markdownap1", ResManager.loadKDString((String)"\u9519\u8bef\u7801", (String)"OpenApiDocPlugin_16", (String)"bos-open-formplugin", (Object[])new Object[0]), null));
        anchorCtl.addItems(items);
    }

    private void addPageParams(List<Map<String, Object>> bodylist, boolean isPost) {
        HashMap<String, Object> pageSize = new HashMap<String, Object>();
        HashMap<String, Object> pageNo = new HashMap<String, Object>();
        pageSize.put(PARAMNAME, "pageSize");
        pageSize.put("bodyparamdes", ResManager.loadKDString((String)"\u5206\u9875\u53c2\u6570\uff0c\u5206\u9875\u6570\u91cf", (String)"OpenApiDocPlugin_19", (String)"bos-open-formplugin", (Object[])new Object[0]));
        pageSize.put("example", 10);
        pageSize.put("paramtype", "Integer");
        pageSize.put("body_level", isPost ? "0" : "1");
        pageSize.put("must", "Y");
        pageNo.put(PARAMNAME, "pageNo");
        pageNo.put("bodyparamdes", ResManager.loadKDString((String)"\u5206\u9875\u53c2\u6570\uff0c\u67e5\u8be2\u9875\u7801", (String)"OpenApiDocPlugin_18", (String)"bos-open-formplugin", (Object[])new Object[0]));
        pageNo.put("example", 1);
        pageNo.put("paramtype", "Integer");
        pageNo.put("body_level", isPost ? "0" : "1");
        pageNo.put("must", "");
        bodylist.add(pageSize);
        bodylist.add(pageNo);
    }
}

