/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.base.util.QFilterUtil;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.ApiServiceType;
import kd.bos.openapi.common.constant.ResSystemType;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.Pair;
import kd.bos.openapi.form.util.ApiDataSetOperater;
import kd.bos.openapi.form.util.ExportUtil;
import kd.bos.openapi.form.util.FormOpener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class OpenApiExportSqlListPlugin
extends AbstractFormPlugin
implements ItemClickListener {
    private static final String EXPORT_SQL = "exportsql";
    private static final Log log = LogFactory.getLog(OpenApiExportSqlListPlugin.class);

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if (EXPORT_SQL.equals(operate.getOperateKey())) {
            ListSelectedRowCollection selectedRows = args.getListSelectedData();
            if (selectedRows.size() > 100) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7100\u6761\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"OpenApiExportSqlListPlugin_2", (String)"bos-open-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
            } else {
                this.exportSql(selectedRows);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
    }

    private void exportSql(ListSelectedRowCollection selectedRows) {
        try {
            Object[] load = BusinessDataServiceHelper.load((String)"openapi_apilist", (String)"id, number, name, apiservicetype", (QFilter[])QFilterUtil.builder().put("id", "in", (Object)selectedRows.getPrimaryKeyValues()).build());
            if (CollectionUtil.isEmpty((Object[])load)) {
                throw new OpenApiException(ApiErrorCode.Data_NotFound, ResManager.loadKDString((String)"\u672a\u627e\u5230\u8981\u5bfc\u51fa\u7684\u6570\u636e\u3002", (String)"OpenApiExportSqlListPlugin_0", (String)ResSystemType.FORM_PLUGIN.getType(), (Object[])new Object[0]), new Object[0]);
            }
            Map<Pair, String> stringMap = Arrays.stream(load).collect(Collectors.toMap(it -> new Pair((Object)it.getString("id"), (Object)it.getString("number")), it -> it.getDataEntityType().getDisplayName().getLocaleValue() + "_" + it.getString("id") + "_" + it.getString("name") + "(" + it.getString("number") + ")"));
            Map apiMap = Arrays.stream(load).collect(Collectors.groupingBy(it -> it.getInt("apiservicetype"), Collectors.mapping(it -> it.get("id"), Collectors.toSet())));
            ArrayList<String> urls = new ArrayList<String>(selectedRows.size());
            for (Map.Entry entry : apiMap.entrySet()) {
                ApiDataSetOperater operater = new ApiDataSetOperater(ApiServiceType.get((int)entry.getKey()).getEntityName());
                List<Map<String, Object>> sqlList = operater.getExpDataSetSqlWithIds(entry.getValue().stream().map(Object::toString).collect(Collectors.toList()));
                for (Map<String, Object> map : sqlList) {
                    String sql = (String)map.get("sql");
                    String number = (String)map.get("number");
                    String fileName = System.currentTimeMillis() + ".sql";
                    for (Map.Entry<Pair, String> stringEntry : stringMap.entrySet()) {
                        if (!((String)stringEntry.getKey().getValue()).equals(number) || !sql.contains((CharSequence)stringEntry.getKey().getKey())) continue;
                        fileName = ExportUtil.removeIllegalChar(stringEntry.getValue()) + ".sql";
                        break;
                    }
                    String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, sql.getBytes(StandardCharsets.UTF_8), 300);
                    urls.add(url);
                }
            }
            String zipName = ExportUtil.generateFileName(Arrays.stream(load).collect(Collectors.toList())) + ".zip";
            String zipUrl = CacheFactory.getCommonCacheFactory().getTempFileCache().compress(zipName, urls.toArray(new String[0]), 300);
            String oneTimeUrl = ExportUtil.genCustomAttachUrl(zipUrl, true);
            this.getView().openUrl(oneTimeUrl);
        }
        catch (Exception e) {
            FormOpener.showErrorMessage(this.getView(), ResManager.loadKDString((String)"\u5bfc\u51faSQL\u5931\u8d25\u3002", (String)"OpenApiExportSqlListPlugin_1", (String)ResSystemType.FORM_PLUGIN.getType(), (Object[])new Object[0]), e);
        }
    }
}

