/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin;

import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.Delete;
import kd.bos.eye.api.armor.vo.FlowRuleVo;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.isc.util.dt.D;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.api.rule.FlowRule;
import kd.bos.openapi.base.limit.LimitFlowRuleConfigUtil;
import kd.bos.openapi.base.util.QFilterUtil;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.JacksonUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPools;

public class OpenApiLimitStrategyListPlugin
extends AbstractListPlugin {
    private static final Log log = LogFactory.getLog(OpenApiLimitStrategyListPlugin.class);
    public static final String DEFAULT = "default";
    public static final String RESOURCE = "resource";
    public static final String DELETE = "delete";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"tbldel", "btndelete"});
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        QFilter[] filters = QFilterUtil.builder().put(new QFilter[]{new QFilter("type", "=", (Object)11)}).put(new QFilter[]{new QFilter("common_key", "=", (Object)"limit")}).build();
        boolean exists = QueryServiceHelper.exists((String)"openapi_common_config", (QFilter[])filters);
        if (!exists) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("openapi_limit_tips");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "closeCallback");
            formShowParameter.setCloseCallBack(closeCallBack);
            this.getView().showForm(formShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getActionId().equals("closeCallback")) {
            Map returnData = (Map)closedCallBackEvent.getReturnData();
            if (CollectionUtil.isEmpty((Map)returnData)) {
                return;
            }
            String syncStatus = (String)returnData.get("syncStatus");
            if ("true".equals(syncStatus)) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u9650\u6d41\u7b56\u7565\u540c\u6b65\u6210\u529f\u3002", (String)"OpenApiLimitStrategyPlugin_7", (String)"bos-open-formplugin", (Object[])new Object[0]));
            } else if ("false".equals(syncStatus)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9650\u6d41\u7b56\u7565\u540c\u6b65\u5f02\u5e38\u3002", (String)"OpenApiLimitStrategyPlugin_6", (String)"bos-open-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof AbstractOperate) {
            AbstractOperate operate = (AbstractOperate)args.getSource();
            String operateKey = operate.getOperateKey();
            ListSelectedRowCollection listSelectedRows = args.getListSelectedData();
            if (operateKey.equals(DELETE) && listSelectedRows.size() > 0) {
                ArrayList idList = new ArrayList(listSelectedRows.size());
                listSelectedRows.forEach(item -> idList.add(D.l((Object)item.getPrimaryKeyValue())));
                DynamicObject[] limitStrategys = BusinessDataServiceHelper.load((String)"openapi_limit_strategy", (String)"number,count,resourcetype,limitentryentity.resource", (QFilter[])QFilterUtil.builder().put("id", "in", idList).build());
                if (limitStrategys != null && limitStrategys.length > 0) {
                    ArrayList flowRuleList = new ArrayList();
                    for (DynamicObject limitStrategy : limitStrategys) {
                        DynamicObjectCollection resourceList = limitStrategy.getDynamicObjectCollection("limitentryentity");
                        if (resourceList == null || resourceList.size() <= 0) continue;
                        resourceList.forEach(resource -> {
                            String resourceString = resource.getString(RESOURCE);
                            FlowRule flowRule = new FlowRule();
                            flowRule.setCount(Integer.valueOf(0));
                            flowRule.setResource(resourceString);
                            flowRuleList.add(flowRule);
                        });
                    }
                    if (CollectionUtil.isNotEmpty(flowRuleList)) {
                        this.getPageCache().put("deleteLimitStrategy", JacksonUtil.writeValueAsString(flowRuleList));
                    }
                }
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        if (evt.getOperationKey().equals("sync")) {
            try {
                DynamicObjectCollection list = QueryServiceHelper.query((String)"openapi_limit_strategy", (String)"id", (QFilter[])new QFilter[0]);
                if (CollectionUtil.isEmpty((Collection)list) || list.size() <= 0) {
                    return;
                }
                LimitFlowRuleConfigUtil.syncFlowRuleVo();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u9650\u6d41\u7b56\u7565\u540c\u6b65\u6210\u529f\u3002", (String)"OpenApiLimitStrategyPlugin_7", (String)"bos-open-formplugin", (Object[])new Object[0]));
            }
            catch (Exception e) {
                log.error("sync deleteLimitStrategy error:", (Throwable)e);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u9650\u6d41\u7b56\u7565\u540c\u6b65\u5f02\u5e38\u3002", (String)"OpenApiLimitStrategyPlugin_6", (String)"bos-open-formplugin", (Object[])new Object[0]));
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        try {
            if (args.getSource() instanceof Delete && args.getOperationResult().isSuccess()) {
                String jsonString = this.getPageCache().get("deleteLimitStrategy");
                if (StringUtil.isEmpty((String)jsonString)) {
                    return;
                }
                List list = (List)JacksonUtil.readValue((String)jsonString, (TypeReference)new TypeReference<List<FlowRuleVo>>(){});
                if (CollectionUtil.isNotEmpty((Collection)list)) {
                    Runnable runnable = () -> LimitFlowRuleConfigUtil.batchUpdateFlowRuleNew((List)list);
                    ThreadPools.executeOnceIncludeRequestContext((String)"UpdateFlowRule", (Runnable)runnable);
                }
            }
        }
        catch (Exception e) {
            log.error("delete deleteLimitStrategy error:", (Throwable)e);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6d41\u63a7\u7b56\u7565\u5220\u9664\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"OpenApiLimitStrategyPlugin_3", (String)"bos-open-formplugin", (Object[])new Object[0]));
        }
    }
}

