/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin;

import com.google.common.base.Joiner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.govern.GovernConfigs;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.base.limit.LimitFlowRuleConfigUtil;
import kd.bos.openapi.common.util.ApiDataUtil;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.DataUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPools;

public class OpenApiLimitStrategyPlugin
extends AbstractBasePlugIn {
    private static final Log log = LogFactory.getLog(OpenApiLimitStrategyPlugin.class);
    public static final String LIMITTYPE = "resourcetype";
    public static final String LIMITENTRYENTITY = "limitentryentity";
    public static final String KEY_THIRD = "third";
    public static final String KEY_THIRDNAME = "thirdname";
    public static final String KEY_API = "api";
    public static final String KEY_APINAME = "apiname";
    public static final String KEY_APIURL = "apiurl";
    public static final String LIMIT_DETAIL = "advconap";
    public static final String SAVE = "save";
    public static final String DEFAULT = "default";
    public static final String RESOURCE = "resource";
    public static final String APP_NAME = "appname";
    public static final String LIMIT_APP = "limitapp";
    public static final String KEY_ID = "Id";
    public static final String KEY_SEQ = "seq";
    public static final String STATINERVAL = "statinterval";
    public static final String RULE_DETAIL_SAVE_BEFORE = "RULE_DETAIL_SAVE_BEFORE";
    public static final String OPENAPI_LIMIT_STRATEGY = "openapi_limit_strategy";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit control = (BasedataEdit)this.getControl(KEY_API);
        control.addBeforeF7SelectListener(o -> {
            ListShowParameter parameter = (ListShowParameter)o.getFormShowParameter();
            ArrayList<Object> apiPks = new ArrayList<Object>(16);
            DynamicObjectCollection entryentity = this.getView().getModel().getEntryEntity(LIMITENTRYENTITY);
            for (DynamicObject object : entryentity) {
                DynamicObject apiservice = object.getDynamicObject(KEY_API);
                if (apiservice == null) continue;
                apiPks.add(apiservice.getPkValue());
            }
            parameter.getListFilterParameter().setFilter(new QFilter("id", "not in", (Object)apiPks.toArray()).and(new QFilter("enable", "!=", (Object)"0")));
        });
        ArrayList thirdPks = new ArrayList(16);
        BasedataEdit thirdControl = (BasedataEdit)this.getControl(KEY_THIRD);
        thirdControl.addBeforeF7SelectListener(o -> {
            ListShowParameter parameter = (ListShowParameter)o.getFormShowParameter();
            DynamicObjectCollection entryentity = this.getView().getModel().getEntryEntity(LIMITENTRYENTITY);
            for (DynamicObject object : entryentity) {
                DynamicObject third = object.getDynamicObject(KEY_THIRD);
                if (third == null) continue;
                thirdPks.add(third.getPkValue());
            }
            parameter.getListFilterParameter().setFilter(new QFilter("id", "not in", (Object)thirdPks.toArray()).and(new QFilter("enable", "!=", (Object)"0")));
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{KEY_API, KEY_APINAME, KEY_APIURL});
    }

    private void updateChangeBeforeData() {
        String resourceType = this.getModel().getDataEntity().getString(LIMITTYPE);
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getDataEntity().getDynamicObjectCollection(LIMITENTRYENTITY);
        if (dynamicObjectCollection != null && !dynamicObjectCollection.isEmpty()) {
            ArrayList ruleDetailIdList = new ArrayList();
            dynamicObjectCollection.forEach(dynamicObject -> {
                if ("2".equalsIgnoreCase(resourceType)) {
                    ruleDetailIdList.add("0@" + dynamicObject.getString(RESOURCE));
                } else {
                    Long ruleDetailId = dynamicObject.getLong("0".equalsIgnoreCase(resourceType) ? "third.id" : "api.id");
                    ruleDetailIdList.add(ruleDetailId + "@" + dynamicObject.getString(RESOURCE));
                }
            });
            this.getPageCache().put(RULE_DETAIL_SAVE_BEFORE, Joiner.on((String)",").join(ruleDetailIdList));
        }
    }

    public void afterLoadData(EventObject e) {
        this.getView().setEnable(Boolean.FALSE, new String[]{LIMITTYPE});
        String limitType = (String)this.getModel().getValue(LIMITTYPE);
        this.setFieldVisibleByLimitType(limitType);
        this.updateChangeBeforeData();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.getModel().setValue("flowcontrolenable", (Object)(GovernConfigs.getBreakerEnable() ? "1" : "0"));
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        e.setCheckDataChange(false);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName = e.getProperty().getName();
        ChangeData changeData = e.getChangeSet()[0];
        String newValue = DataUtil.s((Object)changeData.getNewValue());
        if (LIMITTYPE.equals(propertyName)) {
            this.getModel().deleteEntryData(LIMITENTRYENTITY);
            this.setFieldVisibleByLimitType(newValue);
        } else if (KEY_THIRD.equals(propertyName)) {
            DynamicObject third = (DynamicObject)e.getChangeSet()[0].getNewValue();
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            if (third != null) {
                this.updateModel(true, third.getString(KEY_ID), rowIndex);
            }
        } else if (KEY_API.equals(propertyName)) {
            DynamicObject api = (DynamicObject)e.getChangeSet()[0].getNewValue();
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            if (api != null) {
                this.updateModel(false, api.getString(KEY_ID), rowIndex);
            }
        }
    }

    private void updateModel(boolean isThirdApp, String thirdIdOrApiId, int seq) {
        String accountId = RequestContext.get().getAccountId();
        this.getModel().setValue(RESOURCE, (Object)(isThirdApp ? ApiDataUtil.getResLimitResId((String)accountId, (String)thirdIdOrApiId) : ApiDataUtil.getApiResLimitResId((String)accountId, (String)thirdIdOrApiId)), seq);
        this.getModel().setValue(APP_NAME, (Object)DEFAULT);
        this.getModel().setValue(LIMIT_APP, (Object)DEFAULT);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate operate;
        String operateKey;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof AbstractOperate && SAVE.equals(operateKey = (operate = (AbstractOperate)args.getSource()).getOperateKey())) {
            DynamicObjectCollection detail;
            if (!GovernConfigs.getBreakerEnable()) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"Monitor\u7684\u9650\u6d41\u529f\u80fd\u5f00\u5173\u672a\u5f00\u542f\uff0c\u8bf7\u5f00\u542f\uff08\u7cfb\u7edf\u914d\u7f6e-\u529f\u80fd\u5f00\u5173-\u9650\u6d41\u7194\u65ad\uff09\u540e\u518d\u4f7f\u7528\u3002", (String)"OpenApiLimitStrategyPlugin_4", (String)"bos-open-formplugin", (Object[])new Object[0]));
                return;
            }
            int statineval = (Integer)this.getModel().getValue(STATINERVAL);
            if (!this.isValidStatineval(statineval)) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7edf\u8ba1\u65f6\u957f\u4e0d\u80fd\u4e3a\u7a7a\u4e14\u53ea\u80fd\u4e3a1\u6216\u8005\u4e3a10\u7684\u500d\u6570\uff0c\u5355\u4f4d\u4e3a\u79d2\u3002", (String)"OpenApiLimitStrategyPlugin_5", (String)"bos-open-formplugin", (Object[])new Object[0]));
                return;
            }
            this.checkRepeatEntry(args);
            String limitType = (String)this.getModel().getValue(LIMITTYPE);
            if ("2".equalsIgnoreCase(limitType) && ((detail = this.getModel().getEntryEntity(LIMITENTRYENTITY)) == null || detail.isEmpty())) {
                int index = this.getModel().createNewEntryRow(LIMITENTRYENTITY);
                String accountId = RequestContext.get().getAccountId();
                this.getModel().setValue(RESOURCE, (Object)ApiDataUtil.getAnonymousThirdAppId((String)accountId), index);
                this.getModel().setValue(APP_NAME, (Object)DEFAULT);
                this.getModel().setValue(LIMIT_APP, (Object)DEFAULT);
            }
        }
    }

    public boolean isValidStatineval(Integer number) {
        if (number == null || number == 0) {
            return false;
        }
        return number == 1 || number % 10 == 0;
    }

    private void checkRepeatEntry(BeforeDoOperationEventArgs args) {
        DynamicObjectCollection dynamicObjects;
        DynamicObject limitObj = this.getModel().getDataEntity(true);
        if ("2".equalsIgnoreCase(limitObj.getString(LIMITTYPE)) && CollectionUtil.isNotEmpty((Collection)(dynamicObjects = QueryServiceHelper.query((String)OPENAPI_LIMIT_STRATEGY, (String)"name,number", (QFilter[])new QFilter(LIMITTYPE, "=", (Object)"2").and(new QFilter("id", "!=", this.getModel().getValue("id"))).toArray())))) {
            args.setCancel(true);
            dynamicObjects.stream().forEach(it -> this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u65e0\u6cd5\u65b0\u589e\uff0c\u533f\u540d\u9650\u6d41\u7b56\u7565\u5df2\u521b\u5efa\uff0c\u7b56\u7565\u7f16\u7801\uff1a%1$s  \u3002", (String)"OpenApiLimitStrategyPlugin_2", (String)"bos-open-formplugin", (Object[])new Object[0]), it.getString("number"))));
            return;
        }
        DynamicObjectCollection dynamicObjectCollection = limitObj.getDynamicObjectCollection(LIMITENTRYENTITY);
        if (dynamicObjectCollection.isEmpty()) {
            return;
        }
        HashSet resources = new HashSet();
        HashMap map = new HashMap();
        dynamicObjectCollection.stream().forEach(it -> {
            resources.add(it.getString(RESOURCE));
            map.put(it.getString(RESOURCE), it.getInt(KEY_SEQ));
        });
        DynamicObjectCollection dynamicObjects2 = QueryServiceHelper.query((String)OPENAPI_LIMIT_STRATEGY, (String)"name,number,limitentryentity.resource", (QFilter[])new QFilter("limitentryentity.resource", "in", resources).and(new QFilter("id", "!=", this.getModel().getValue("id"))).toArray());
        if (CollectionUtil.isNotEmpty((Collection)dynamicObjects2)) {
            args.setCancel(true);
            dynamicObjects2.stream().forEach(it -> this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u9650\u6d41\u6e05\u5355\u5e8f\u53f7 %1$s\u8be5\u8d44\u6e90\u5df2\u88ab\u7b56\u7565\u7f16\u7801\u4e3a\uff1a%2$s  \u9009\u4e2d\u3002", (String)"OpenApiLimitStrategyPlugin_0", (String)"bos-open-formplugin", (Object[])new Object[0]), map.get(it.getString("limitentryentity.resource")), it.getString("number"))));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        try {
            if (args.getOperateKey().equals(SAVE) && args.getOperationResult().getSuccessPkIds().size() > 0) {
                String limitResId = ((Long)this.getModel().getValue("id")).toString();
                String changeBefore = this.getPageCache().get(RULE_DETAIL_SAVE_BEFORE);
                Runnable runnable = () -> LimitFlowRuleConfigUtil.updateFlowRule((String)limitResId, (String)changeBefore);
                ThreadPools.executeOnceIncludeRequestContext((String)"UpdateFlowRule", (Runnable)runnable);
                this.updateChangeBeforeData();
            }
        }
        catch (Exception e) {
            log.error("update flowrule error:", (Throwable)e);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6d41\u63a7\u7b56\u7565\u4fdd\u5b58\u51fa\u9519\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"OpenApiLimitStrategyPlugin_1", (String)"bos-open-formplugin", (Object[])new Object[0]));
        }
    }

    private void setFieldVisibleByLimitType(String limitType) {
        if (limitType.equals("0")) {
            this.getView().setEnable(Boolean.TRUE, new String[]{LIMIT_DETAIL});
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_THIRD, KEY_THIRDNAME});
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_API, KEY_APINAME, KEY_APIURL});
        } else if (limitType.equals("2")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{LIMIT_DETAIL});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{LIMIT_DETAIL});
            this.getView().setVisible(Boolean.FALSE, new String[]{KEY_THIRD, KEY_THIRDNAME});
            this.getView().setVisible(Boolean.TRUE, new String[]{KEY_API, KEY_APINAME, KEY_APIURL});
        }
    }
}

