/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.EventObject;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.logorm.LogORM;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.form.util.pdf.ExportAndDownloadUtil;
import kd.bos.orm.query.QFilter;

public class OpenApiLogFormPlugin
extends AbstractBasePlugIn {
    private static final Log LOG = LogFactory.getLog(OpenApiLogFormPlugin.class);
    public static final String QUERYDETAIL = "querydetail";
    public static final String OPENAPI_LOG_DETAIL = "openapi_log_detail";
    public static final String REQPARA_TAG = "reqpara_tag";
    public static final String RESPPARA_TAG = "resppara_tag";
    String ID = "id";

    public void afterLoadData(EventObject e) {
        String req = this.getModel().getValue("request").toString();
        String resp = this.getModel().getValue("response").toString();
        this.getModel().setValue("request", (Object)(req.length() >= 2000 ? req + "..." : req));
        this.getModel().setValue("response", (Object)(resp.length() >= 2000 ? resp + "..." : resp));
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof AbstractOperate) {
            AbstractOperate operate = (AbstractOperate)args.getSource();
            String operateKey = operate.getOperateKey();
            String reqStr = null;
            String respStr = null;
            if (QUERYDETAIL.equals(operateKey)) {
                boolean exists = false;
                LogORM logORM = LogORM.create();
                QFilter qFilter = QFilter.of((String)"id = ?", (Object[])new Object[]{this.getModel().getValue(this.ID)});
                try (DataSet ds = logORM.queryDataSet(OPENAPI_LOG_DETAIL, "reqpara_tag,resppara_tag", new QFilter[]{qFilter}, 100, 0);){
                    while (ds.hasNext()) {
                        exists = true;
                        Row row = ds.next();
                        reqStr = row.getString(0);
                        respStr = row.getString(1);
                    }
                }
                if (exists) {
                    String fp = this.createTxt(reqStr, respStr);
                    String fileName = this.getModel().getValue("opname").toString() + "_" + this.getModel().getValue("traceid").toString() + ".txt";
                    try {
                        ExportAndDownloadUtil.download(this.getView(), fp, fileName);
                    }
                    catch (Exception e) {
                        LOG.error("export log error", (Throwable)e);
                    }
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u627e\u5230\u8be6\u7ec6\u65e5\u5fd7\u3002", (String)"OpenApiLogFormPlugin_1", (String)"bos-open-formplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    public String createTxt(String req, String resp) {
        String fp = "." + File.separator + System.currentTimeMillis() + ".txt";
        File file = new File(fp);
        try (FileWriter fw = new FileWriter(file);
             BufferedWriter bufferedWriter = new BufferedWriter(fw);){
            if (!file.exists() && !file.createNewFile()) {
                throw new OpenApiException(ApiErrorCode.Data_Invalid, "An error occurred while creating the file", new Object[0]);
            }
            bufferedWriter.write("request:\n");
            bufferedWriter.write(req);
            bufferedWriter.write("\n");
            bufferedWriter.write("response:\n");
            bufferedWriter.write(resp);
        }
        catch (IOException e) {
            LOG.error("export log error", (Throwable)e);
        }
        return fp;
    }
}

