/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin;

import java.util.EventObject;
import java.util.Stack;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.DataUtil;
import kd.bos.util.StringUtils;

public class OpenApiPreviewPlugin
extends AbstractFormPlugin {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object preData = this.getView().getFormShowParameter().getCustomParam("preData");
        String str = DataUtil.s((Object)preData);
        CodeEdit codeEdit = (CodeEdit)this.getView().getControl("codeeditap");
        codeEdit.setText(this.formatSql(str));
    }

    public String formatSql(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return "";
        }
        str = this.getReplaceStr(str, "( ", "(");
        str = this.getReplaceStr(str, " )", ")");
        str = this.getReplaceStr(str, "  ", " ");
        str = str.replace("and", "\r\nand");
        str = str.replace("or", "\r\nor");
        str = str.replace("AND", "\r\nAND");
        str = str.replace("OR", "\r\nOR");
        StringBuilder sql = new StringBuilder();
        Stack<Boolean> stackL = new Stack<Boolean>();
        boolean preIsL = false;
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if ('(' == ch) {
                boolean isWrap;
                preIsL = true;
                String s = sql.toString();
                if (s.endsWith("in ") || s.endsWith("IN ") || s.endsWith("trim") || s.endsWith("EMPTY_TO_TEXT")) {
                    isWrap = false;
                    sql.append(ch);
                } else if (s.endsWith("and ") || s.endsWith("or ") || s.endsWith("AND ") || s.endsWith("OR ")) {
                    isWrap = true;
                    sql.append(ch);
                } else {
                    isWrap = true;
                    if (sql.length() == 0) {
                        sql.append(ch);
                    } else {
                        this.appendPrefixSql(sql, ch, stackL.size());
                    }
                }
                stackL.push(isWrap);
                continue;
            }
            if (')' == ch) {
                if (stackL.isEmpty()) {
                    throw new OpenApiException(ApiErrorCode.Data_Invalid, ResManager.loadKDString((String)"\u62ec\u53f7\u4e0d\u5339\u914d\u3002", (String)"OpenApiPreviewPlugin_0", (String)"bos-open-formplugin", (Object[])new Object[0]), new Object[0]);
                }
                boolean b = (Boolean)stackL.pop();
                if (b) {
                    this.appendPrefixSql(sql, ch, stackL.size());
                    continue;
                }
                sql.append(ch);
                continue;
            }
            if (ch == '\n') {
                this.appendSuffixSql(sql, ch, stackL.size());
                continue;
            }
            if (preIsL && ((Boolean)stackL.peek()).booleanValue()) {
                this.appendPrefixSql(sql, ch, stackL.size());
            } else {
                sql.append(ch);
            }
            preIsL = false;
        }
        return sql.toString();
    }

    private void appendPrefixSql(StringBuilder sql, char ch, int size) {
        sql.append("\r\n");
        for (int i = 0; i < size; ++i) {
            sql.append('\t');
        }
        sql.append(ch);
    }

    private void appendSuffixSql(StringBuilder sql, char ch, int size) {
        sql.append(ch);
        for (int i = 0; i < size; ++i) {
            sql.append('\t');
        }
    }

    private String getReplaceStr(String str, String target, String replacement) {
        while (str.contains(target)) {
            str = str.replace(target, replacement);
        }
        return str;
    }
}

