/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ListboxItem;
import kd.bos.entity.filter.ControlFilter;
import kd.bos.ext.form.control.Listbox;
import kd.bos.form.chart.PointLineChart;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.ListboxClickListener;
import kd.bos.form.control.events.ListboxEvent;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.base.util.QFilterUtil;
import kd.bos.openapi.common.util.CollectionUtil;
import kd.bos.openapi.common.util.DateUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.form.util.CustomChartHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class OpenApiReportPlugin
extends AbstractListPlugin
implements ListboxClickListener {
    private static final Log log = LogFactory.getLog(OpenApiReportPlugin.class);
    private static final String CNT = "cnt";
    public static final String TYPE = "type";
    public static final String TIME = "time";
    private static final String FORM_LOG = "openapi_statdata";
    private static final String KEY_LAB_TODAY = "labtoday";
    private static final String KEY_LAB_WEEK = "labweek";
    private static final String KEY_LAB_MONTH = "labmonth";
    private static final String KEY_LAB_YEAR = "labyear";
    private static final String KEY_POINTLINECHARTAP = "pointlinechartap";
    private static final String KEY_LISTBOXAP = "listboxap";
    private static final String MONTH = "month";
    private static final String DAY = "day";
    private static final String HOUR = "hour";
    private List<DynamicObject> API_DATA_30Day = new ArrayList<DynamicObject>(1);
    private List<DynamicObject> API_DATAS_24Hour = new ArrayList<DynamicObject>(1);
    private DynamicObject API_DATAS_Year = null;
    private final String LISTBOX = "listbox";
    private final String FASTQFILTER = "fastQfilter";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Listbox box = (Listbox)this.getView().getControl(KEY_LISTBOXAP);
        box.addListboxClickListener((ListboxClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        try {
            this.get30DayAnd24HourAndYearData(null);
        }
        catch (Exception ex) {
            log.error("error:", (Throwable)ex);
        }
        int today = 0;
        int week = 0;
        int month = 0;
        int year = 0;
        try {
            today = this.getSumDayByDate(new Date());
            week = this.getSumDayByDate(DateUtil.getDateAdd((Date)new Date(), (int)6, (int)-6));
            month = this.getSumDayByDate(DateUtil.getDateAdd((Date)new Date(), (int)6, (int)-29));
        }
        catch (Exception ex) {
            log.error("error:", (Throwable)ex);
        }
        if (this.API_DATAS_Year != null) {
            year = this.API_DATAS_Year.getInt(CNT);
        }
        Label labtoday = (Label)this.getView().getControl(KEY_LAB_TODAY);
        labtoday.setText(today + "");
        Label labweek = (Label)this.getView().getControl(KEY_LAB_WEEK);
        labweek.setText(week + "");
        Label labmonth = (Label)this.getView().getControl(KEY_LAB_MONTH);
        labmonth.setText(month + "");
        Label labyear = (Label)this.getView().getControl(KEY_LAB_YEAR);
        labyear.setText(year + "");
        PointLineChart customchart = (PointLineChart)this.getControl(KEY_POINTLINECHARTAP);
        CustomChartHelper chartHelper = new CustomChartHelper();
        chartHelper.drawChart(customchart, this.API_DATAS_24Hour, 1);
        Listbox box = (Listbox)this.getView().getControl(KEY_LISTBOXAP);
        ListboxItem listboxItem2 = new ListboxItem(DAY, ResManager.loadKDString((String)"\u65e5", (String)"OpenApiReportPlugin_0", (String)"bos-open-formplugin", (Object[])new Object[0]));
        ListboxItem listboxItem3 = new ListboxItem(HOUR, ResManager.loadKDString((String)"\u65f6", (String)"OpenApiReportPlugin_1", (String)"bos-open-formplugin", (Object[])new Object[0]));
        ArrayList<ListboxItem> itemlist = new ArrayList<ListboxItem>(2);
        itemlist.add(listboxItem2);
        itemlist.add(listboxItem3);
        box.addItems(itemlist);
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        List fastQFilters = args.getFastQFilters();
        if (CollectionUtil.isNotEmpty((Collection)fastQFilters)) {
            QFilter qFilter = (QFilter)fastQFilters.get(0);
            this.getPageCache().put("fastQfilter", qFilter.getValue().toString());
        } else {
            this.getPageCache().remove("fastQfilter");
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        QFilter[] qfs = e.getQFilters().toArray(new QFilter[e.getQFilters().size()]);
        if (qfs.length > 0) {
            try {
                this.get30DayAnd24HourAndYearData(qfs);
            }
            catch (Exception ex) {
                log.error("error:", (Throwable)ex);
            }
        } else {
            try {
                this.get30DayAnd24HourAndYearData(null);
            }
            catch (Exception ex) {
                log.error("error:", (Throwable)ex);
            }
        }
        PointLineChart customchart = (PointLineChart)this.getControl(KEY_POINTLINECHARTAP);
        CustomChartHelper chartHelper = new CustomChartHelper();
        String listbox = this.getPageCache().get("listbox");
        Listbox box = (Listbox)this.getView().getControl(KEY_LISTBOXAP);
        if (StringUtil.isEmpty((String)listbox) || HOUR.equals(listbox)) {
            chartHelper.drawChart(customchart, this.API_DATAS_24Hour, 1);
            box.activeItem(HOUR);
        } else if (DAY.equals(listbox)) {
            chartHelper.drawChart(customchart, this.API_DATA_30Day, 7);
        }
    }

    public void listboxClick(ListboxEvent arg) {
        PointLineChart customchart = (PointLineChart)this.getControl(KEY_POINTLINECHARTAP);
        CustomChartHelper chartHelper = new CustomChartHelper();
        try {
            ControlFilter currentControlFilter = this.getControlFilters().getCurrentControlFilter();
            if (currentControlFilter == null) {
                this.get30DayAnd24HourAndYearData(null);
            } else {
                ArrayList<Long> thirdIds = new ArrayList<Long>(2);
                for (Object o : currentControlFilter.getValue()) {
                    String idStr;
                    if (o instanceof Long) {
                        thirdIds.add((Long)o);
                    }
                    if (!(o instanceof String) || !StringUtil.isNotEmpty((String)(idStr = o.toString()))) continue;
                    thirdIds.add(Long.parseLong(idStr));
                }
                QFilter[] qFilters = new QFilter(currentControlFilter.getFieldName(), "in", thirdIds).toArray();
                if (CollectionUtil.isEmpty(thirdIds)) {
                    this.get30DayAnd24HourAndYearData(null);
                } else {
                    this.get30DayAnd24HourAndYearData(qFilters);
                }
            }
        }
        catch (ParseException e) {
            log.error("error:", (Throwable)e);
        }
        if (arg.getItemId().equals(DAY)) {
            chartHelper.drawChart(customchart, this.API_DATA_30Day, 7);
            this.getPageCache().put("listbox", DAY);
        } else if (arg.getItemId().equals(HOUR)) {
            chartHelper.drawChart(customchart, this.API_DATAS_24Hour, 1);
            this.getPageCache().put("listbox", HOUR);
        }
        customchart.refresh();
    }

    private void get30DayAnd24HourAndYearData(QFilter[] qfs) throws ParseException {
        String fastQfilter;
        Date timeBefore24Hour = DateUtil.getDateWithoutMinute((Date)DateUtil.getDateAdd((Date)new Date(), (int)10, (int)-23));
        QFilterUtil.FilterSet qFilters = QFilterUtil.builder().put(TYPE, "=", (Object)1).put(TIME, ">=", (Object)timeBefore24Hour.getTime());
        if (qfs != null && qfs.length > 0) {
            for (QFilter qFilter : qfs) {
                qFilters.put(new QFilter[]{qFilter});
            }
        }
        if (StringUtil.isNotEmpty((String)(fastQfilter = this.getPageCache().get("fastQfilter")))) {
            qFilters.put(new QFilter[]{new QFilter("1", "ftlike", (Object)fastQfilter)});
        }
        QFilter[] qFilters24Hour = qFilters.build();
        DynamicObjectCollection datas = QueryServiceHelper.query((String)FORM_LOG, (String)"time,cnt,type,successcnt,cost", (QFilter[])qFilters24Hour, (String)"time desc");
        this.API_DATAS_24Hour = datas.stream().collect(Collectors.toList());
        Date timeBefore30Day = DateUtil.getDateWithoutHour((Date)DateUtil.getDateAdd((Date)new Date(), (int)6, (int)-29));
        QFilterUtil.FilterSet qFiltersOf30Day = QFilterUtil.builder().put(TYPE, "=", (Object)2).put(TIME, ">=", (Object)timeBefore30Day.getTime());
        if (qfs != null && qfs.length > 0) {
            for (QFilter qFilter : qfs) {
                qFiltersOf30Day.put(new QFilter[]{qFilter});
            }
        }
        if (StringUtil.isNotEmpty((String)fastQfilter)) {
            qFiltersOf30Day.put(new QFilter[]{new QFilter("1", "ftlike", (Object)fastQfilter)});
        }
        QFilter[] qFilters30Day = qFiltersOf30Day.build();
        datas = QueryServiceHelper.query((String)FORM_LOG, (String)"time,cnt,type,successcnt,cost", (QFilter[])qFilters30Day, (String)"time desc");
        this.API_DATA_30Day = datas.stream().collect(Collectors.toList());
        QFilter[] qFiltersYear = QFilterUtil.builder().put(TYPE, "=", (Object)9).put(TIME, "=", (Object)0).build();
        this.API_DATAS_Year = QueryServiceHelper.queryOne((String)FORM_LOG, (String)"time,cnt,type,successcnt,cost", (QFilter[])qFiltersYear);
    }

    private int getSumDayByDate(Date date) throws ParseException {
        Long timeAt8AM = DateUtil.getTimeAt8AM((Date)date);
        QFilterUtil.FilterSet qFilter = QFilterUtil.builder().put(TYPE, "=", (Object)7).put(TIME, ">=", (Object)timeAt8AM);
        QFilter[] qFilters = qFilter.build();
        DynamicObjectCollection datas = QueryServiceHelper.query((String)FORM_LOG, (String)"time,cnt", (QFilter[])qFilters, (String)"time desc");
        if (CollectionUtil.isNotEmpty((Collection)datas)) {
            return datas.stream().mapToInt(it -> it.getInt(CNT)).sum();
        }
        return 0;
    }
}

