/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.parser.Feature;
import java.util.EventObject;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.CodeEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.constant.RestSoapType;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.DataUtil;
import kd.bos.openapi.common.util.JsonUtil;
import kd.bos.openapi.common.util.XmlUtil;
import kd.bos.openapi.common.wsdl.SoapUtil;
import kd.bos.openapi.form.util.FormOpener;

public class OpenApiStructPreviewPlugin
extends AbstractFormPlugin {
    public static final String PRE_DATA = "preData";
    public static final String PRE_URL = "preUrl";
    public static final String IS_GET_METHOD = "isGetMethod";
    public static final String APISERVICETYPE = "apiServiceType";
    public static final String PREVIEWTYPE = "previewType";
    public static final String BODYENTRYENTITY = "bodyentryentity";
    public static final String RESPENTRYENTITY = "respentryentity";
    public static final String INPUTPARAM = "wsinputparam";
    public static final String OUTPUTPARAM = "wsoutputparam";
    public static final String NAMESPACE = "namespace";
    private static final String BOS_FORM_BUSINESS = "bos-form-business";

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        try {
            String xml;
            String json;
            FormShowParameter parameter = this.getView().getFormShowParameter();
            String preDataStr = (String)parameter.getCustomParam(PRE_DATA);
            Object preData = JSON.parseObject((String)preDataStr, LinkedHashMap.class, (Feature[])new Feature[]{Feature.OrderedField});
            boolean isGetMethod = DataUtil.x((Object)parameter.getCustomParam(IS_GET_METHOD));
            String apiServiceType = (String)parameter.getCustomParam(APISERVICETYPE);
            String previewType = (String)parameter.getCustomParam(PREVIEWTYPE);
            String inputParam = (String)parameter.getCustomParam(INPUTPARAM);
            String outputParam = (String)parameter.getCustomParam(OUTPUTPARAM);
            String nameSpace = (String)parameter.getCustomParam(NAMESPACE);
            String soap1_1 = "";
            String soap1_2 = "";
            if (isGetMethod) {
                Map<String, Object> getDataMap = this.getMethodData(preData);
                StringBuilder sb = new StringBuilder();
                for (Map.Entry<String, Object> entry : getDataMap.entrySet()) {
                    Object value;
                    if (sb.length() > 0) {
                        sb.append('&');
                    }
                    if ((value = entry.getValue()) instanceof JSONArray) {
                        JSONArray valArray = (JSONArray)value;
                        for (int i = 0; i < valArray.size(); ++i) {
                            sb.append(i == 0 ? "" : Character.valueOf('&')).append(entry.getKey()).append('=').append(valArray.get(i));
                        }
                        continue;
                    }
                    sb.append(entry.getKey()).append('=').append(value);
                }
                json = sb.toString();
                xml = XmlUtil.objectToXml(getDataMap);
            } else {
                if (preData == null) {
                    return;
                }
                json = JsonUtil.format((Object)preData);
                try {
                    xml = XmlUtil.objectToXml((Object)preData);
                }
                catch (Exception e) {
                    xml = e.getMessage();
                }
                String param = RESPENTRYENTITY.equalsIgnoreCase(previewType) ? outputParam : inputParam;
                try {
                    soap1_1 = SoapUtil.getSoapXml((Object)preData, (RestSoapType)RestSoapType.SOAP1_1, (String)nameSpace, (String)param);
                }
                catch (Exception e) {
                    soap1_1 = e.getMessage();
                }
                try {
                    soap1_2 = SoapUtil.getSoapXml((Object)preData, (RestSoapType)RestSoapType.SOAP1_2, (String)nameSpace, (String)param);
                }
                catch (Exception e) {
                    soap1_2 = e.getMessage();
                }
            }
            CodeEdit jsonCode = (CodeEdit)this.getView().getControl("jsoncode");
            jsonCode.setText(json);
            CodeEdit xmlCode = (CodeEdit)this.getView().getControl("xmlcode");
            xmlCode.setText(xml);
            CodeEdit soap1 = (CodeEdit)this.getView().getControl("soap1_1code");
            soap1.setText(soap1_1);
            CodeEdit soap2 = (CodeEdit)this.getView().getControl("soap1_2code");
            soap2.setText(soap1_2);
        }
        catch (KDException e) {
            this.getView().showErrorNotification(e.getMessage());
        }
        catch (Exception e) {
            FormOpener.showErrorMessage(this.getView(), e);
        }
    }

    private Map<String, Object> getMethodData(Object preData) {
        if (!(preData instanceof Map)) {
            throw new OpenApiException(ApiErrorCode.HTTP_BAD_REQUEST, ResManager.loadKDString((String)"\u53c2\u6570\u683c\u5f0f\u9519\u8bef\u3002", (String)"OpenApiStructPreviewPlugin_0", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), new Object[0]);
        }
        Map map = (Map)preData;
        LinkedHashMap<String, Object> getDataMap = (LinkedHashMap<String, Object>)map.get("data");
        if (getDataMap == null) {
            getDataMap = new LinkedHashMap<String, Object>(map.size());
        }
        for (Map.Entry entry : map.entrySet()) {
            if ("data".equals(entry.getKey())) continue;
            getDataMap.put((String)entry.getKey(), entry.getValue());
        }
        return getDataMap;
    }
}

