/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin.async;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlParameter;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.constant.ApiConstant;
import kd.bos.openapi.common.util.DataUtil;
import kd.bos.openapi.common.util.JacksonUtil;
import kd.bos.openapi.common.util.OpenJsonUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.form.util.ExportUtil;
import kd.bos.openapi.form.util.pdf.ExportAndDownloadUtil;

public class OpenApiAsyncDataPlugin
extends AbstractFormPlugin {
    private static final Log LOG = LogFactory.getLog(OpenApiAsyncDataPlugin.class);
    public static final String QUERYDETAIL = "querydetail";

    public void afterBindData(EventObject e) {
        long id = DataUtil.l((Object)this.getModel().getValue("id"));
        if (id <= 0L) {
            return;
        }
        String sql = "select LEFT(finputpara,500) as inputpara,LEFT(foutputpara,500) as outputpara  FROM t_openapi_asyncdata WHERE fid=?;";
        Object[] params = new SqlParameter[]{new SqlParameter(":fid", -5, (Object)id)};
        try (DataSet dataSet = DB.queryDataSet((String)"openapi.asyncdata", (DBRoute)ApiConstant.QUEUE_DB_ROUTE, (String)sql, (Object[])params);){
            for (Row row : dataSet) {
                this.getModel().setValue("inputpara", (Object)row.getString("inputpara"));
                this.getModel().setValue("outputpara", (Object)row.getString("outputpara"));
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        AbstractOperate operate;
        String operateKey;
        super.beforeDoOperation(args);
        if (args.getSource() instanceof AbstractOperate && QUERYDETAIL.equals(operateKey = (operate = (AbstractOperate)args.getSource()).getOperateKey())) {
            long id = DataUtil.l((Object)this.getModel().getValue("id"));
            if (id <= 0L) {
                this.getView().showTipNotification("No log info exists.");
                return;
            }
            String sql = "select finputpara as inputpara,foutputpara as outputpara  FROM t_openapi_asyncdata WHERE fid=?;";
            Object[] params = new SqlParameter[]{new SqlParameter(":fid", -5, (Object)id)};
            try (DataSet dataSet = DB.queryDataSet((String)"openapi.asyncdata", (DBRoute)ApiConstant.QUEUE_DB_ROUTE, (String)sql, (Object[])params);){
                for (Row row : dataSet) {
                    String inputpara = StringUtil.isNotEmpty((String)row.getString("inputpara")) ? row.getString("inputpara") : "";
                    String outputpara = StringUtil.isNotEmpty((String)row.getString("outputpara")) ? row.getString("outputpara") : "";
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("request", OpenJsonUtil.fromJson((String)inputpara));
                    map.put("response", OpenJsonUtil.fromJson((String)outputpara));
                    String txt = ExportUtil.createTxt(JacksonUtil.writeValueAsString(map));
                    String fileName = "asyncapi_log_" + id + ".json";
                    try {
                        ExportAndDownloadUtil.download(this.getView(), txt, fileName);
                    }
                    catch (Exception e) {
                        LOG.error("export log error.", (Throwable)e);
                    }
                }
            }
        }
    }
}

