/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.form.plugin.callback;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.encrypt.EncrypterFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.base.util.QFilterUtil;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.exception.OpenApiException;
import kd.bos.openapi.common.util.EncryptUtil;
import kd.bos.openapi.common.util.StringUtil;
import kd.bos.openapi.form.plugin.callback.CallBackInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.url.UrlService;

public class CallBackUtil {
    private static final Log log = LogFactory.getLog(CallBackUtil.class);
    private static final String BASEIC_AUTH_FIELDS_FBASIC_SIGN_CODE = "fbasesigncode";
    private static final String BASEIC_AUTH_FIELDS_FBASIC_SIGN_CODE_STATUS = "fstatus";
    private static final String BASEIC_AUTH_FIELDS_THIRD_ENABLE = "fenable";
    private static final String BASEIC_AUTH_FIELDS_VALID_STATUS = "1";
    private static final String BASEIC_AUTH_FIELDS_THIRD_BASEICAU_STATUS = "fisbasicauth";
    private static final String BASEIC_SQL = "select t.fid,t.fagentuserid,t.fbasesigncode,t.fstatus, t3.fenable, t3.fisbasicauth from t_open_3rdapps_basicauth t left join t_open_3rdapps t3 on t.fid=t3.fid  where t.fid=? and t.fagentuserid =? ";
    private static final String API_SERVICE_CALLBACK_SQL = "select t.fid,t.fapiid,t.fthirdid,t.fagentuserid from T_OPENAPI_CALLBACK t where t.fapiid=?";
    private static final String API_SERVICE_ID_URL = "id,urlformat";
    private static final String URL_SPLIT = "/";
    private static final String URL_ASK = "?";
    public static final String API_SERVICE_CALLBACK_THIRD = "fthirdid";
    public static final String API_SERVICE_CALLBACK_AGENT_USER_ID = "fagentuserid";
    public static final String API_SERVICE_CALLBACK_FID = "fid";

    public static CallBackInfo findCallbackUrl(String accountId, Long thirdId, Long agentUserId, Long apiId) {
        AtomicReference<String> baseCodeEncodeStatus;
        AtomicReference<String> baseCodeEncode;
        if (accountId == null || thirdId == null || agentUserId == null || apiId == null) {
            throw new OpenApiException(ApiErrorCode.Data_Invalid, " invalid params for accountId,thirdId, agentUserId", new Object[0]);
        }
        try (DataSet dataSet = DB.queryDataSet((String)CallBackUtil.class.getName(), (DBRoute)DBRoute.basedata, (String)BASEIC_SQL, (Object[])new Object[]{thirdId, agentUserId});){
            baseCodeEncode = new AtomicReference<String>("");
            baseCodeEncodeStatus = new AtomicReference<String>("0");
            dataSet.forEach(data -> {
                baseCodeEncode.set((String)data.get(BASEIC_AUTH_FIELDS_FBASIC_SIGN_CODE));
                String baseAuthStatus = (String)data.get(BASEIC_AUTH_FIELDS_FBASIC_SIGN_CODE_STATUS);
                String thirdStatus = (String)data.get(BASEIC_AUTH_FIELDS_THIRD_ENABLE);
                String thirdBaseAuthStatus = (String)data.get(BASEIC_AUTH_FIELDS_THIRD_BASEICAU_STATUS);
                if (BASEIC_AUTH_FIELDS_VALID_STATUS.equalsIgnoreCase(baseAuthStatus) && BASEIC_AUTH_FIELDS_VALID_STATUS.equalsIgnoreCase(thirdStatus) && BASEIC_AUTH_FIELDS_VALID_STATUS.equalsIgnoreCase(thirdBaseAuthStatus)) {
                    baseCodeEncodeStatus.set(BASEIC_AUTH_FIELDS_VALID_STATUS);
                }
            });
        }
        CallBackInfo result = new CallBackInfo();
        String baseCode = "";
        if (StringUtil.isNotEmpty((String)baseCodeEncode.get())) {
            if (EncrypterFactory.getEncrypter().isEncrypted(baseCodeEncode.get())) {
                baseCode = EncrypterFactory.getEncrypter().decode(baseCodeEncode.get());
            }
            StringBuilder urlBuilder = new StringBuilder();
            urlBuilder.append(UrlService.getDomainContextUrl()).append("/kapi");
            String accessKey = EncryptUtil.genSignWithAccountId((String)baseCode, (String)accountId);
            DynamicObject apiObj = QueryServiceHelper.queryOne((String)"openapi_apilist", (String)API_SERVICE_ID_URL, (QFilter[])QFilterUtil.builder().put("id", "=", (Object)apiId).build());
            String apiUrl = apiObj.getString("urlformat");
            if (StringUtil.isEmpty((String)apiUrl)) {
                throw new OpenApiException(ApiErrorCode.Data_Invalid, "cannot find api by apiId:" + apiId, new Object[0]);
            }
            urlBuilder.append(apiUrl);
            StringBuilder commonUrlBuilder = new StringBuilder();
            commonUrlBuilder.append((CharSequence)urlBuilder);
            commonUrlBuilder.append(URL_ASK).append("openApiSign").append("=").append(accessKey);
            StringBuilder pathVarUrlBuilder = new StringBuilder();
            pathVarUrlBuilder.append((CharSequence)urlBuilder);
            pathVarUrlBuilder.append("/$/").append("openApiSign").append(URL_SPLIT).append(accessKey).append(URL_SPLIT);
            result.setCommUrl(commonUrlBuilder.toString());
            result.setPathVarUrl(pathVarUrlBuilder.toString());
        } else {
            result.setCommUrl(ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u7b2c\u4e09\u65b9\u5e94\u7528\u57fa\u672c\u8ba4\u8bc1\u4ee3\u7406\u7528\u6237\u662f\u5426\u914d\u7f6e\u3002", (String)"CallBackUtil_0", (String)"bos-open-formplugin", (Object[])new Object[0]));
        }
        result.setStatus(baseCodeEncodeStatus.get());
        return result;
    }

    public static CallBackInfo findCallbackUrl(Long thirdId, Long agentUserId, Long apiId) {
        return CallBackUtil.findCallbackUrl(RequestContext.get().getAccountId(), thirdId, agentUserId, apiId);
    }

    public static List<CallBackInfo> findCallbackUrl(Long apiId) {
        ArrayList<CallBackInfo> list = new ArrayList<CallBackInfo>();
        if (apiId == null) {
            return list;
        }
        try (DataSet dataSet = DB.queryDataSet((String)CallBackUtil.class.getName(), (DBRoute)DBRoute.basedata, (String)API_SERVICE_CALLBACK_SQL, (Object[])new Object[]{apiId});){
            dataSet.forEach(data -> {
                CallBackInfo callBackInfo = CallBackUtil.findCallbackUrl(data.getLong(API_SERVICE_CALLBACK_THIRD), data.getLong(API_SERVICE_CALLBACK_AGENT_USER_ID), apiId);
                callBackInfo.setFid(data.getLong(API_SERVICE_CALLBACK_FID));
                list.add(callBackInfo);
            });
        }
        return list;
    }
}

